/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jnr.constants.platform.Errno;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jruby.runtime.Constants;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.runtime.load.LoadServiceResource;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.BasicObjectNodesFactory;
import org.jruby.truffle.nodes.core.BignumNodes;
import org.jruby.truffle.nodes.core.BignumNodesFactory;
import org.jruby.truffle.nodes.core.BindingNodesFactory;
import org.jruby.truffle.nodes.core.ClassNodesFactory;
import org.jruby.truffle.nodes.core.CoreMethodNodeManager;
import org.jruby.truffle.nodes.core.EncodingConverterNodesFactory;
import org.jruby.truffle.nodes.core.EncodingNodesFactory;
import org.jruby.truffle.nodes.core.ExceptionNodesFactory;
import org.jruby.truffle.nodes.core.FalseClassNodesFactory;
import org.jruby.truffle.nodes.core.FiberNodesFactory;
import org.jruby.truffle.nodes.core.FloatNodesFactory;
import org.jruby.truffle.nodes.core.IntegerNodesFactory;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.core.MainNodesFactory;
import org.jruby.truffle.nodes.core.MatchDataNodesFactory;
import org.jruby.truffle.nodes.core.MathNodesFactory;
import org.jruby.truffle.nodes.core.MethodNodesFactory;
import org.jruby.truffle.nodes.core.ModuleNodesFactory;
import org.jruby.truffle.nodes.core.MutexNodes;
import org.jruby.truffle.nodes.core.MutexNodesFactory;
import org.jruby.truffle.nodes.core.ObjectSpaceNodesFactory;
import org.jruby.truffle.nodes.core.ProcNodesFactory;
import org.jruby.truffle.nodes.core.ProcessNodesFactory;
import org.jruby.truffle.nodes.core.RangeNodesFactory;
import org.jruby.truffle.nodes.core.RegexpNodesFactory;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.StringNodesFactory;
import org.jruby.truffle.nodes.core.SymbolNodesFactory;
import org.jruby.truffle.nodes.core.ThreadBacktraceLocationNodesFactory;
import org.jruby.truffle.nodes.core.ThreadNodesFactory;
import org.jruby.truffle.nodes.core.TimeNodesFactory;
import org.jruby.truffle.nodes.core.TrueClassNodesFactory;
import org.jruby.truffle.nodes.core.TruffleInteropNodesFactory;
import org.jruby.truffle.nodes.core.TrufflePrimitiveNodesFactory;
import org.jruby.truffle.nodes.core.UnboundMethodNodesFactory;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.core.array.ArrayNodesFactory;
import org.jruby.truffle.nodes.core.fixnum.FixnumNodesFactory;
import org.jruby.truffle.nodes.core.hash.HashNodes;
import org.jruby.truffle.nodes.core.hash.HashNodesFactory;
import org.jruby.truffle.nodes.ext.BigDecimalNodes;
import org.jruby.truffle.nodes.ext.BigDecimalNodesFactory;
import org.jruby.truffle.nodes.ext.DigestNodesFactory;
import org.jruby.truffle.nodes.ext.ZlibNodesFactory;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.nodes.objects.FreezeNode;
import org.jruby.truffle.nodes.objects.FreezeNodeGen;
import org.jruby.truffle.nodes.objects.SingletonClassNode;
import org.jruby.truffle.nodes.objects.SingletonClassNodeGen;
import org.jruby.truffle.nodes.rubinius.ByteArrayNodesFactory;
import org.jruby.truffle.nodes.rubinius.IOPrimitiveNodes;
import org.jruby.truffle.nodes.rubinius.PointerPrimitiveNodes;
import org.jruby.truffle.nodes.rubinius.PosixNodesFactory;
import org.jruby.truffle.nodes.rubinius.RubiniusTypeNodesFactory;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.control.TruffleFatalException;
import org.jruby.truffle.runtime.core.CoreSourceSection;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyEncodingConverter;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.core.RubyFiber;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.truffle.runtime.core.RubyRegexp;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.core.RubyTime;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.hash.KeyValue;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.signal.SignalOperations;
import org.jruby.truffle.translator.NodeWrapper;
import org.jruby.util.cli.Options;
import org.jruby.util.cli.OutputStrings;

public class CoreLibrary {
    private static final String CLI_RECORD_SEPARATOR = (String)Options.CLI_RECORD_SEPARATOR.load();
    private final RubyContext context;
    private final RubyClass argumentErrorClass;
    private final RubyClass arrayClass;
    private final RubyClass basicObjectClass;
    private final RubyClass bignumClass;
    private final RubyClass bindingClass;
    private final RubyClass classClass;
    private final RubyClass complexClass;
    private final RubyClass dirClass;
    private final RubyClass encodingClass;
    private final RubyClass encodingErrorClass;
    private final RubyClass exceptionClass;
    private final RubyClass falseClass;
    private final RubyClass fiberClass;
    private final RubyClass fixnumClass;
    private final RubyClass floatClass;
    private final RubyClass floatDomainErrorClass;
    private final RubyClass hashClass;
    private final RubyClass integerClass;
    private final RubyClass indexErrorClass;
    private final RubyClass ioErrorClass;
    private final RubyClass loadErrorClass;
    private final RubyClass localJumpErrorClass;
    private final RubyClass lookupTableClass;
    private final RubyClass matchDataClass;
    private final RubyClass moduleClass;
    private final RubyClass nameErrorClass;
    private final RubyClass nilClass;
    private final RubyClass noMethodErrorClass;
    private final RubyClass notImplementedErrorClass;
    private final RubyClass numericClass;
    private final RubyClass objectClass;
    private final RubyClass procClass;
    private final RubyModule processModule;
    private final RubyClass rangeClass;
    private final RubyClass rangeErrorClass;
    private final RubyClass rationalClass;
    private final RubyClass regexpClass;
    private final RubyClass regexpErrorClass;
    private final RubyClass rubyTruffleErrorClass;
    private final RubyClass runtimeErrorClass;
    private final RubyClass securityErrorClass;
    private final RubyClass standardErrorClass;
    private final RubyClass stringClass;
    private final RubyClass stringDataClass;
    private final RubyClass symbolClass;
    private final RubyClass syntaxErrorClass;
    private final RubyClass systemCallErrorClass;
    private final RubyClass threadClass;
    private final RubyClass threadBacktraceClass;
    private final RubyClass threadBacktraceLocationClass;
    private final RubyClass timeClass;
    private final RubyClass transcodingClass;
    private final RubyClass trueClass;
    private final RubyClass tupleClass;
    private final RubyClass typeErrorClass;
    private final RubyClass zeroDivisionErrorClass;
    private final RubyModule enumerableModule;
    private final RubyModule errnoModule;
    private final RubyModule kernelModule;
    private final RubyModule rubiniusModule;
    private final RubyModule rubiniusFFIModule;
    private final RubyModule signalModule;
    private final RubyModule truffleModule;
    private final RubyClass bigDecimalClass;
    private final RubyClass encodingConverterClass;
    private final RubyClass encodingCompatibilityErrorClass;
    private final RubyClass methodClass;
    private final RubyClass unboundMethodClass;
    private final RubyClass byteArrayClass;
    private final RubyClass fiberErrorClass;
    private final RubyClass threadErrorClass;
    private final RubyClass ioBufferClass;
    private final RubyBasicObject argv;
    private final RubyBasicObject globalVariablesObject;
    private final RubyBasicObject mainObject;
    private final RubyBasicObject nilObject;
    private final RubyBasicObject rubiniusUndefined;
    private final ArrayNodes.MinBlock arrayMinBlock;
    private final ArrayNodes.MaxBlock arrayMaxBlock;
    private final RubyClass rubyInternalMethod;
    private final Map<Errno, RubyClass> errnoClasses = new HashMap<Errno, RubyClass>();
    @CompilerDirectives.CompilationFinal
    private RubySymbol eachSymbol;
    @CompilerDirectives.CompilationFinal
    private RubyBasicObject envHash;
    @CompilerDirectives.CompilationFinal
    private InternalMethod basicObjectSendMethod;
    private State state = State.INITIALIZING;
    private final Allocator NO_ALLOCATOR = new Allocator(){

        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(CoreLibrary.this.typeError(String.format("allocator undefined for %s", rubyClass.getName()), currentNode));
        }
    };
    private final CoreLibraryNode node;

    public CoreLibrary(RubyContext context) {
        this.context = context;
        this.node = new CoreLibraryNode(context, (SourceSection)new CoreSourceSection("CoreLibrary", "initialize"));
        this.classClass = RubyClass.createClassClass(context, new RubyClass.ClassAllocator());
        this.basicObjectClass = RubyClass.createBootClass(this.classClass, null, "BasicObject", new RubyBasicObject.BasicObjectAllocator());
        this.objectClass = RubyClass.createBootClass(this.classClass, this.basicObjectClass, "Object", this.basicObjectClass.getAllocator());
        this.moduleClass = RubyClass.createBootClass(this.classClass, this.objectClass, "Module", new RubyModule.ModuleAllocator());
        this.classClass.unsafeSetSuperclass(this.moduleClass);
        this.classClass.getAdoptedByLexicalParent(this.objectClass, "Class", this.node);
        this.basicObjectClass.getAdoptedByLexicalParent(this.objectClass, "BasicObject", this.node);
        this.objectClass.getAdoptedByLexicalParent(this.objectClass, "Object", this.node);
        this.moduleClass.getAdoptedByLexicalParent(this.objectClass, "Module", this.node);
        this.exceptionClass = this.defineClass("Exception", new RubyException.ExceptionAllocator());
        this.fiberErrorClass = this.defineClass(this.exceptionClass, "FiberError");
        this.defineClass(this.exceptionClass, "NoMemoryError");
        this.rubyTruffleErrorClass = this.defineClass(this.exceptionClass, "RubyTruffleError");
        this.standardErrorClass = this.defineClass(this.exceptionClass, "StandardError");
        this.argumentErrorClass = this.defineClass(this.standardErrorClass, "ArgumentError");
        this.encodingErrorClass = this.defineClass(this.standardErrorClass, "EncodingError");
        this.ioErrorClass = this.defineClass(this.standardErrorClass, "IOError");
        this.localJumpErrorClass = this.defineClass(this.standardErrorClass, "LocalJumpError");
        this.regexpErrorClass = this.defineClass(this.standardErrorClass, "RegexpError");
        this.runtimeErrorClass = this.defineClass(this.standardErrorClass, "RuntimeError");
        this.threadErrorClass = this.defineClass(this.standardErrorClass, "ThreadError");
        this.typeErrorClass = this.defineClass(this.standardErrorClass, "TypeError");
        this.zeroDivisionErrorClass = this.defineClass(this.standardErrorClass, "ZeroDivisionError");
        this.rangeErrorClass = this.defineClass(this.standardErrorClass, "RangeError");
        this.floatDomainErrorClass = this.defineClass(this.rangeErrorClass, "FloatDomainError");
        this.indexErrorClass = this.defineClass(this.standardErrorClass, "IndexError");
        this.defineClass(this.indexErrorClass, "KeyError");
        this.defineClass(this.ioErrorClass, "EOFError");
        this.nameErrorClass = this.defineClass(this.standardErrorClass, "NameError");
        this.noMethodErrorClass = this.defineClass(this.nameErrorClass, "NoMethodError");
        this.systemCallErrorClass = this.defineClass(this.standardErrorClass, "SystemCallError");
        this.errnoModule = this.defineModule("Errno");
        for (Errno errno : Errno.values()) {
            if (!errno.name().startsWith("E")) continue;
            this.errnoClasses.put(errno, this.defineClass(this.errnoModule, this.systemCallErrorClass, errno.name()));
        }
        RubyClass scriptErrorClass = this.defineClass(this.exceptionClass, "ScriptError");
        this.loadErrorClass = this.defineClass(scriptErrorClass, "LoadError");
        this.notImplementedErrorClass = this.defineClass(scriptErrorClass, "NotImplementedError");
        this.syntaxErrorClass = this.defineClass(scriptErrorClass, "SyntaxError");
        this.securityErrorClass = this.defineClass(this.exceptionClass, "SecurityError");
        RubyClass signalExceptionClass = this.defineClass(this.exceptionClass, "SignalException");
        this.defineClass(signalExceptionClass, "Interrupt");
        this.defineClass(this.exceptionClass, "SystemExit");
        this.defineClass(this.exceptionClass, "SystemStackError");
        this.numericClass = this.defineClass("Numeric");
        this.complexClass = this.defineClass(this.numericClass, "Complex");
        this.floatClass = this.defineClass(this.numericClass, "Float", this.NO_ALLOCATOR);
        this.integerClass = this.defineClass(this.numericClass, "Integer", this.NO_ALLOCATOR);
        this.fixnumClass = this.defineClass(this.integerClass, "Fixnum");
        this.bignumClass = this.defineClass(this.integerClass, "Bignum");
        this.rationalClass = this.defineClass(this.numericClass, "Rational");
        this.arrayClass = this.defineClass("Array", new ArrayNodes.ArrayAllocator());
        this.bindingClass = this.defineClass("Binding", new RubyBinding.BindingAllocator());
        this.dirClass = this.defineClass("Dir");
        this.encodingClass = this.defineClass("Encoding", this.NO_ALLOCATOR);
        this.falseClass = this.defineClass("FalseClass", this.NO_ALLOCATOR);
        this.fiberClass = this.defineClass("Fiber", new RubyFiber.FiberAllocator());
        this.defineModule("FileTest");
        this.hashClass = this.defineClass("Hash", new HashNodes.HashAllocator());
        this.matchDataClass = this.defineClass("MatchData");
        this.methodClass = this.defineClass("Method", this.NO_ALLOCATOR);
        this.defineClass("Mutex", new MutexNodes.MutexAllocator());
        this.nilClass = this.defineClass("NilClass", this.NO_ALLOCATOR);
        this.procClass = this.defineClass("Proc", new RubyProc.ProcAllocator());
        this.processModule = this.defineModule("Process");
        this.rangeClass = this.defineClass("Range", new RubyRange.RangeAllocator());
        this.regexpClass = this.defineClass("Regexp", new RubyRegexp.RegexpAllocator());
        this.stringClass = this.defineClass("String", new StringNodes.StringAllocator());
        this.symbolClass = this.defineClass("Symbol", this.NO_ALLOCATOR);
        this.threadClass = this.defineClass("Thread", new RubyThread.ThreadAllocator());
        this.threadBacktraceClass = this.defineClass((RubyModule)this.threadClass, this.objectClass, "Backtrace");
        this.threadBacktraceLocationClass = this.defineClass(this.threadBacktraceClass, this.objectClass, "Location", this.NO_ALLOCATOR);
        this.timeClass = this.defineClass("Time", new RubyTime.TimeAllocator());
        this.trueClass = this.defineClass("TrueClass", this.NO_ALLOCATOR);
        this.unboundMethodClass = this.defineClass("UnboundMethod", this.NO_ALLOCATOR);
        RubyClass ioClass = this.defineClass("IO", new IOPrimitiveNodes.IOAllocator());
        this.ioBufferClass = this.defineClass((RubyModule)ioClass, this.objectClass, "InternalBuffer");
        RubyModule comparableModule = this.defineModule("Comparable");
        this.defineModule("Config");
        this.enumerableModule = this.defineModule("Enumerable");
        this.defineModule("GC");
        this.kernelModule = this.defineModule("Kernel");
        this.defineModule("Math");
        this.defineModule("ObjectSpace");
        this.signalModule = this.defineModule("Signal");
        this.encodingCompatibilityErrorClass = this.defineClass((RubyModule)this.encodingClass, this.encodingErrorClass, "CompatibilityError");
        this.encodingConverterClass = this.defineClass(this.encodingClass, this.objectClass, "Converter", new RubyEncodingConverter.EncodingConverterAllocator());
        this.truffleModule = this.defineModule("Truffle");
        this.defineModule(this.truffleModule, "Interop");
        this.defineModule(this.truffleModule, "Debug");
        this.defineModule(this.truffleModule, "Primitive");
        this.defineModule(this.truffleModule, "Digest");
        this.defineModule(this.truffleModule, "Zlib");
        this.bigDecimalClass = this.defineClass(this.truffleModule, this.numericClass, "BigDecimal", new BigDecimalNodes.RubyBigDecimalAllocator());
        this.rubiniusModule = this.defineModule("Rubinius");
        this.rubiniusFFIModule = this.defineModule(this.rubiniusModule, "FFI");
        this.defineModule(this.defineModule(this.rubiniusFFIModule, "Platform"), "POSIX");
        this.defineClass(this.rubiniusFFIModule, this.objectClass, "Pointer", new PointerPrimitiveNodes.PointerAllocator());
        this.defineModule(this.rubiniusModule, "Type");
        this.byteArrayClass = this.defineClass(this.rubiniusModule, this.objectClass, "ByteArray");
        this.lookupTableClass = this.defineClass(this.rubiniusModule, this.hashClass, "LookupTable");
        this.stringDataClass = this.defineClass(this.rubiniusModule, this.objectClass, "StringData");
        this.transcodingClass = this.defineClass((RubyModule)this.encodingClass, this.objectClass, "Transcoding");
        this.tupleClass = this.defineClass(this.rubiniusModule, this.arrayClass, "Tuple");
        this.rubyInternalMethod = null;
        this.includeModules(comparableModule);
        this.mainObject = new RubyBasicObject(this.objectClass);
        this.nilObject = new RubyBasicObject(this.nilClass);
        this.argv = ArrayNodes.createEmptyArray(this.arrayClass);
        this.rubiniusUndefined = new RubyBasicObject(this.objectClass);
        this.globalVariablesObject = new RubyBasicObject(this.objectClass);
        this.arrayMinBlock = new ArrayNodes.MinBlock(context);
        this.arrayMaxBlock = new ArrayNodes.MaxBlock(context);
    }

    private void includeModules(RubyModule comparableModule) {
        this.objectClass.include(this.node, this.kernelModule);
        this.numericClass.include(this.node, comparableModule);
        this.symbolClass.include(this.node, comparableModule);
        this.arrayClass.include(this.node, this.enumerableModule);
        this.dirClass.include(this.node, this.enumerableModule);
        this.hashClass.include(this.node, this.enumerableModule);
        this.rangeClass.include(this.node, this.enumerableModule);
    }

    public void initialize() {
        this.addCoreMethods();
        this.initializeGlobalVariables();
        this.initializeConstants();
        this.initializeEncodingConstants();
        this.initializeSignalConstants();
    }

    private void addCoreMethods() {
        CoreMethodNodeManager coreMethodNodeManager = new CoreMethodNodeManager(this.objectClass, this.node.getSingletonClassNode());
        coreMethodNodeManager.addCoreMethodNodes(ArrayNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(BasicObjectNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(BindingNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(BignumNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(ClassNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(ExceptionNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(FalseClassNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(FiberNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(FixnumNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(FloatNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(HashNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(IntegerNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(KernelNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(MainNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(MatchDataNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(MathNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(ModuleNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(MutexNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(ObjectSpaceNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(ProcessNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(ProcNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(RangeNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(RegexpNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(StringNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(SymbolNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(ThreadNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(TrueClassNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(TrufflePrimitiveNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(EncodingNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(EncodingConverterNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(TruffleInteropNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(MethodNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(UnboundMethodNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(ByteArrayNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(TimeNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(PosixNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(RubiniusTypeNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(ThreadBacktraceLocationNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(DigestNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(BigDecimalNodesFactory.getFactories());
        coreMethodNodeManager.addCoreMethodNodes(ZlibNodesFactory.getFactories());
        this.basicObjectSendMethod = this.basicObjectClass.getMethods().get("__send__");
        assert (this.basicObjectSendMethod != null);
    }

    private void initializeGlobalVariables() {
        RubyBasicObject globals = this.globalVariablesObject;
        RubyBasicObject.setInstanceVariable(globals, "$LOAD_PATH", ArrayNodes.createEmptyArray(this.arrayClass));
        RubyBasicObject.setInstanceVariable(globals, "$LOADED_FEATURES", ArrayNodes.createEmptyArray(this.arrayClass));
        RubyBasicObject.setInstanceVariable(globals, "$:", globals.getInstanceVariable("$LOAD_PATH"));
        RubyBasicObject.setInstanceVariable(globals, "$\"", globals.getInstanceVariable("$LOADED_FEATURES"));
        RubyBasicObject.setInstanceVariable(globals, "$,", this.nilObject);
        RubyBasicObject.setInstanceVariable(globals, "$0", this.context.toTruffle(this.context.getRuntime().getGlobalVariables().get("$0")));
        RubyBasicObject.setInstanceVariable(globals, "$DEBUG", this.context.getRuntime().isDebug());
        RubyBasicObject value = this.context.getRuntime().warningsEnabled() ? Boolean.valueOf(this.context.getRuntime().isVerbose()) : this.nilObject;
        RubyBasicObject.setInstanceVariable(globals, "$VERBOSE", value);
        RubyBasicObject defaultRecordSeparator = StringNodes.createString(this.stringClass, CLI_RECORD_SEPARATOR);
        this.node.freezeNode.executeFreeze(defaultRecordSeparator);
        RubyBasicObject.setInstanceVariable(globals, "$/", defaultRecordSeparator);
        RubyBasicObject.setInstanceVariable(globals, "$SAFE", 0);
    }

    private void initializeConstants() {
        this.objectClass.setConstant(this.node, "RUBY_VERSION", StringNodes.createString(this.stringClass, "2.2.2"));
        this.objectClass.setConstant(this.node, "JRUBY_VERSION", StringNodes.createString(this.stringClass, "9.0.0.0.rc1"));
        this.objectClass.setConstant(this.node, "RUBY_PATCHLEVEL", 0);
        this.objectClass.setConstant(this.node, "RUBY_REVISION", Constants.RUBY_REVISION);
        this.objectClass.setConstant(this.node, "RUBY_ENGINE", StringNodes.createString(this.stringClass, "jruby+truffle"));
        this.objectClass.setConstant(this.node, "RUBY_PLATFORM", StringNodes.createString(this.stringClass, "java"));
        this.objectClass.setConstant(this.node, "RUBY_RELEASE_DATE", StringNodes.createString(this.stringClass, "2015-06-10"));
        this.objectClass.setConstant(this.node, "RUBY_DESCRIPTION", StringNodes.createString(this.stringClass, OutputStrings.getVersionString()));
        this.objectClass.setConstant(this.node, "RUBY_COPYRIGHT", StringNodes.createString(this.stringClass, OutputStrings.getCopyrightString()));
        this.basicObjectClass.setConstant(this.node, "BasicObject", this.basicObjectClass);
        this.objectClass.setConstant(this.node, "ARGV", this.argv);
        this.rubiniusModule.setConstant(this.node, "UNDEFINED", this.rubiniusUndefined);
        this.processModule.setConstant(this.node, "CLOCK_MONOTONIC", 1);
        this.processModule.setConstant(this.node, "CLOCK_REALTIME", 2);
        this.encodingConverterClass.setConstant(this.node, "INVALID_MASK", 15);
        this.encodingConverterClass.setConstant(this.node, "INVALID_REPLACE", 2);
        this.encodingConverterClass.setConstant(this.node, "UNDEF_MASK", 240);
        this.encodingConverterClass.setConstant(this.node, "UNDEF_REPLACE", 32);
        this.encodingConverterClass.setConstant(this.node, "UNDEF_HEX_CHARREF", 48);
        this.encodingConverterClass.setConstant(this.node, "PARTIAL_INPUT", 65536);
        this.encodingConverterClass.setConstant(this.node, "AFTER_OUTPUT", 131072);
        this.encodingConverterClass.setConstant(this.node, "UNIVERSAL_NEWLINE_DECORATOR", 256);
        this.encodingConverterClass.setConstant(this.node, "CRLF_NEWLINE_DECORATOR", 4096);
        this.encodingConverterClass.setConstant(this.node, "CR_NEWLINE_DECORATOR", 8192);
        this.encodingConverterClass.setConstant(this.node, "XML_TEXT_DECORATOR", 16384);
        this.encodingConverterClass.setConstant(this.node, "XML_ATTR_CONTENT_DECORATOR", 32768);
        this.encodingConverterClass.setConstant(this.node, "XML_ATTR_QUOTE_DECORATOR", 0x100000);
    }

    private void initializeSignalConstants() {
        Object[] signals = new Object[SignalOperations.SIGNALS_LIST.size()];
        int i = 0;
        for (Map.Entry<String, Integer> signal : SignalOperations.SIGNALS_LIST.entrySet()) {
            RubyBasicObject signalName = StringNodes.createString(this.context.getCoreLibrary().getStringClass(), signal.getKey());
            signals[i++] = ArrayNodes.fromObjects(this.arrayClass, signalName, signal.getValue());
        }
        this.signalModule.setConstant(this.node, "SIGNAL_LIST", ArrayNodes.createArray(this.arrayClass, signals, signals.length));
    }

    private RubyClass defineClass(String name) {
        return this.defineClass(this.objectClass, name, this.objectClass.getAllocator());
    }

    private RubyClass defineClass(String name, Allocator allocator) {
        return this.defineClass(this.objectClass, name, allocator);
    }

    private RubyClass defineClass(RubyClass superclass, String name) {
        return new RubyClass(this.context, (RubyModule)this.objectClass, superclass, name, superclass.getAllocator());
    }

    private RubyClass defineClass(RubyClass superclass, String name, Allocator allocator) {
        return new RubyClass(this.context, (RubyModule)this.objectClass, superclass, name, allocator);
    }

    private RubyClass defineClass(RubyModule lexicalParent, RubyClass superclass, String name) {
        return new RubyClass(this.context, lexicalParent, superclass, name, superclass.getAllocator());
    }

    private RubyClass defineClass(RubyModule lexicalParent, RubyClass superclass, String name, Allocator allocator) {
        return new RubyClass(this.context, lexicalParent, superclass, name, allocator);
    }

    private RubyModule defineModule(String name) {
        return this.defineModule(this.objectClass, name);
    }

    private RubyModule defineModule(RubyModule lexicalParent, String name) {
        return new RubyModule(this.context, this.moduleClass, lexicalParent, name, this.node);
    }

    public void initializeAfterMethodsAdded() {
        this.initializeRubiniusFFI();
        this.envHash = this.getSystemEnv();
        this.objectClass.setConstant(this.node, "ENV", this.envHash);
        try {
            this.state = State.LOADING_RUBY_CORE;
            this.loadRubyCore("core.rb");
        }
        catch (RaiseException e) {
            RubyException rubyException = e.getRubyException();
            for (String line : Backtrace.DISPLAY_FORMATTER.format(this.getContext(), rubyException, rubyException.getBacktrace())) {
                System.err.println(line);
            }
            throw new TruffleFatalException("couldn't load the core library", e);
        }
        finally {
            this.state = State.LOADED;
        }
    }

    private void initializeRubiniusFFI() {
        this.rubiniusFFIModule.setConstant(this.node, "TYPE_CHAR", 0);
        this.rubiniusFFIModule.setConstant(this.node, "TYPE_UCHAR", 1);
        this.rubiniusFFIModule.setConstant(this.node, "TYPE_BOOL", 2);
        this.rubiniusFFIModule.setConstant(this.node, "TYPE_SHORT", 3);
        this.rubiniusFFIModule.setConstant(this.node, "TYPE_USHORT", 4);
        this.rubiniusFFIModule.setConstant(this.node, "TYPE_INT", 5);
        this.rubiniusFFIModule.setConstant(this.node, "TYPE_UINT", 6);
        this.rubiniusFFIModule.setConstant(this.node, "TYPE_LONG", 7);
        this.rubiniusFFIModule.setConstant(this.node, "TYPE_ULONG", 8);
        this.rubiniusFFIModule.setConstant(this.node, "TYPE_LL", 9);
        this.rubiniusFFIModule.setConstant(this.node, "TYPE_ULL", 10);
        this.rubiniusFFIModule.setConstant(this.node, "TYPE_FLOAT", 11);
        this.rubiniusFFIModule.setConstant(this.node, "TYPE_DOUBLE", 12);
        this.rubiniusFFIModule.setConstant(this.node, "TYPE_PTR", 13);
        this.rubiniusFFIModule.setConstant(this.node, "TYPE_VOID", 14);
        this.rubiniusFFIModule.setConstant(this.node, "TYPE_STRING", 15);
        this.rubiniusFFIModule.setConstant(this.node, "TYPE_STRPTR", 16);
        this.rubiniusFFIModule.setConstant(this.node, "TYPE_CHARARR", 17);
        this.rubiniusFFIModule.setConstant(this.node, "TYPE_ENUM", 18);
        this.rubiniusFFIModule.setConstant(this.node, "TYPE_VARARGS", 19);
    }

    public void loadRubyCore(String fileName) {
        this.loadRubyCore(fileName, "core:/");
    }

    public void loadRubyCore(String fileName, String prefix) {
        Source source;
        try {
            source = Source.fromReader((Reader)new InputStreamReader(this.getRubyCoreInputStream(fileName), StandardCharsets.UTF_8), (String)(prefix + fileName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.context.load(source, this.node, NodeWrapper.IDENTITY);
    }

    public InputStream getRubyCoreInputStream(String fileName) {
        LoadServiceResource resource = this.context.getRuntime().getLoadService().getClassPathResource(this.getClass().getClassLoader(), fileName);
        if (resource == null) {
            throw new RuntimeException("couldn't load Truffle core library " + fileName);
        }
        try {
            return resource.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void initializeEncodingConstants() {
        this.getContext().getRuntime().getEncodingService().defineEncodings(new EncodingService.EncodingDefinitionVisitor(){

            public void defineEncoding(EncodingDB.Entry encodingEntry, byte[] name, int p, int end) {
                Encoding e = encodingEntry.getEncoding();
                RubyEncoding re = RubyEncoding.newEncoding(CoreLibrary.this.encodingClass, e, name, p, end, encodingEntry.isDummy());
                RubyEncoding.storeEncoding(encodingEntry.getIndex(), re);
            }

            public void defineConstant(int encodingListIndex, String constName) {
                CoreLibrary.this.encodingClass.setConstant(CoreLibrary.this.node, constName, RubyEncoding.getEncoding(encodingListIndex));
            }
        });
        this.getContext().getRuntime().getEncodingService().defineAliases(new EncodingService.EncodingAliasVisitor(){

            public void defineAlias(int encodingListIndex, String constName) {
                RubyEncoding re = RubyEncoding.getEncoding(encodingListIndex);
                RubyEncoding.storeAlias(constName, re);
            }

            public void defineConstant(int encodingListIndex, String constName) {
                CoreLibrary.this.encodingClass.setConstant(CoreLibrary.this.node, constName, RubyEncoding.getEncoding(encodingListIndex));
            }
        });
    }

    public RubyClass getMetaClass(Object object) {
        if (object instanceof RubyBasicObject) {
            return ((RubyBasicObject)object).getMetaClass();
        }
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return this.trueClass;
            }
            return this.falseClass;
        }
        if (object instanceof Integer) {
            return this.fixnumClass;
        }
        if (object instanceof Long) {
            return this.fixnumClass;
        }
        if (object instanceof Double) {
            return this.floatClass;
        }
        if (object == null) {
            throw new RuntimeException("Can't get metaclass for null");
        }
        CompilerDirectives.transferToInterpreter();
        throw new UnsupportedOperationException(String.format("Don't know how to get the metaclass for %s", object.getClass()));
    }

    public RubyClass getLogicalClass(Object object) {
        if (object instanceof RubyBasicObject) {
            return ((RubyBasicObject)object).getLogicalClass();
        }
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                return this.trueClass;
            }
            return this.falseClass;
        }
        if (object instanceof Integer) {
            return this.fixnumClass;
        }
        if (object instanceof Long) {
            return this.fixnumClass;
        }
        if (object instanceof Double) {
            return this.floatClass;
        }
        if (object == null) {
            throw new RuntimeException();
        }
        CompilerDirectives.transferToInterpreter();
        throw new UnsupportedOperationException(String.format("Don't know how to get the logical class for %s", object.getClass()));
    }

    public static double toDouble(Object value, RubyBasicObject nil) {
        assert (value != null);
        if (value == nil) {
            return 0.0;
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return ((Long)value).longValue();
        }
        if (RubyGuards.isRubyBignum(value)) {
            return BignumNodes.getBigIntegerValue((RubyBasicObject)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        CompilerDirectives.transferToInterpreter();
        throw new UnsupportedOperationException();
    }

    public static boolean fitsIntoInteger(long value) {
        return value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE;
    }

    public RubyException runtimeError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.runtimeErrorClass, StringNodes.createString(this.context.getCoreLibrary().getStringClass(), message), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException frozenError(String className, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.runtimeError(String.format("can't modify frozen %s", className), currentNode);
    }

    public RubyException argumentError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.argumentErrorClass, StringNodes.createString(this.context.getCoreLibrary().getStringClass(), message), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException argumentErrorOutOfRange(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.argumentError("out of range", currentNode);
    }

    public RubyException argumentErrorInvalidRadix(int radix, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.argumentError(String.format("invalid radix %d", radix), currentNode);
    }

    public RubyException argumentErrorMissingKeyword(String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.argumentError(String.format("missing keyword: %s", name), currentNode);
    }

    public RubyException argumentError(int passed, int required, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.argumentError(String.format("wrong number of arguments (%d for %d)", passed, required), currentNode);
    }

    public RubyException argumentError(int passed, int required, int optional, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.argumentError(String.format("wrong number of arguments (%d for %d..%d)", passed, required, required + optional), currentNode);
    }

    public RubyException argumentErrorEmptyVarargs(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.argumentError("wrong number of arguments (0 for 1+)", currentNode);
    }

    public RubyException errnoError(int errno, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        Errno errnoObj = Errno.valueOf((long)errno);
        if (errnoObj == null) {
            return this.systemCallError(String.format("Unknown Error (%s)", errno), currentNode);
        }
        return new RubyException(this.getErrnoClass(errnoObj), StringNodes.createString(this.context.getCoreLibrary().getStringClass(), errnoObj.description()), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException indexError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.indexErrorClass, StringNodes.createString(this.context.getCoreLibrary().getStringClass(), message), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException indexTooSmallError(String type, int index, int length, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.indexError(String.format("index %d too small for %s; minimum: -%d", index, type, length), currentNode);
    }

    public RubyException indexNegativeLength(int length, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.indexError(String.format("negative length (%d)", length), currentNode);
    }

    public RubyException localJumpError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.localJumpErrorClass, StringNodes.createString(this.context.getCoreLibrary().getStringClass(), message), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException noBlockGiven(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.localJumpError("no block given", currentNode);
    }

    public RubyException unexpectedReturn(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.localJumpError("unexpected return", currentNode);
    }

    public RubyException noBlockToYieldTo(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.localJumpError("no block given (yield)", currentNode);
    }

    public RubyException typeError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.typeErrorClass, StringNodes.createString(this.context.getCoreLibrary().getStringClass(), message), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException typeErrorCantDefineSingleton(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError("can't define singleton", currentNode);
    }

    public RubyException typeErrorNoClassToMakeAlias(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError("no class to make alias", currentNode);
    }

    public RubyException typeErrorShouldReturn(String object, String method, String expectedType, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError(String.format("%s#%s should return %s", object, method, expectedType), currentNode);
    }

    public RubyException typeErrorCantConvertTo(Object from, RubyClass to, String methodUsed, Object result, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        String fromClass = this.getLogicalClass(from).getName();
        return this.typeError(String.format("can't convert %s to %s (%s#%s gives %s)", fromClass, to.getName(), fromClass, methodUsed, this.getLogicalClass(result).toString()), currentNode);
    }

    public RubyException typeErrorCantConvertInto(Object from, RubyClass to, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError(String.format("can't convert %s into %s", this.getLogicalClass(from).getName(), to.getName()), currentNode);
    }

    public RubyException typeErrorIsNotA(String value, String expectedType, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError(String.format("%s is not a %s", value, expectedType), currentNode);
    }

    public RubyException typeErrorNoImplicitConversion(Object from, String to, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError(String.format("no implicit conversion of %s into %s", this.getLogicalClass(from).getName(), to), currentNode);
    }

    public RubyException typeErrorMustBe(String variable, String type, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError(String.format("value of %s must be %s", variable, type), currentNode);
    }

    public RubyException typeErrorBadCoercion(Object from, String to, String coercionMethod, Object coercedTo, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        String badClassName = this.getLogicalClass(from).getName();
        return this.typeError(String.format("can't convert %s to %s (%s#%s gives %s)", badClassName, to, badClassName, coercionMethod, this.getLogicalClass(coercedTo).getName()), currentNode);
    }

    public RubyException typeErrorCantCoerce(Object from, String to, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.typeError(String.format("%s can't be coerced into %s", from, to), currentNode);
    }

    public RubyException typeErrorWrongArgumentType(Object object, String expectedType, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        String badClassName = this.getLogicalClass(object).getName();
        return this.typeError(String.format("wrong argument type %s (expected %s)", badClassName, expectedType), currentNode);
    }

    public RubyException nameError(String message, String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        RubyException nameError = new RubyException(this.nameErrorClass, StringNodes.createString(this.context.getCoreLibrary().getStringClass(), message), RubyCallStack.getBacktrace(currentNode));
        RubyBasicObject.setInstanceVariable(nameError, "@name", this.context.getSymbolTable().getSymbol(name));
        return nameError;
    }

    public RubyException nameErrorConstantNotDefined(RubyModule module, String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.nameError(String.format("constant %s::%s not defined", module.getName(), name), name, currentNode);
    }

    public RubyException nameErrorUninitializedConstant(RubyModule module, String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        String message = module == this.objectClass ? String.format("uninitialized constant %s", name) : String.format("uninitialized constant %s::%s", module.getName(), name);
        return this.nameError(message, name, currentNode);
    }

    public RubyException nameErrorUninitializedClassVariable(RubyModule module, String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.nameError(String.format("uninitialized class variable %s in %s", name, module.getName()), name, currentNode);
    }

    public RubyException nameErrorPrivateConstant(RubyModule module, String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.nameError(String.format("private constant %s::%s referenced", module.getName(), name), name, currentNode);
    }

    public RubyException nameErrorInstanceNameNotAllowable(String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.nameError(String.format("`%s' is not allowable as an instance variable name", name), name, currentNode);
    }

    public RubyException nameErrorReadOnly(String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.nameError(String.format("%s is a read-only variable", name), name, currentNode);
    }

    public RubyException nameErrorUndefinedLocalVariableOrMethod(String name, String object, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.nameError(String.format("undefined local variable or method `%s' for %s", name, object), name, currentNode);
    }

    public RubyException nameErrorUndefinedMethod(String name, RubyModule module, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.nameError(String.format("undefined method `%s' for %s", name, module.getName()), name, currentNode);
    }

    public RubyException nameErrorMethodNotDefinedIn(RubyModule module, String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.nameError(String.format("method `%s' not defined in %s", name, module.getName()), name, currentNode);
    }

    public RubyException nameErrorPrivateMethod(String name, RubyModule module, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.nameError(String.format("method `%s' for %s is private", name, module.getName()), name, currentNode);
    }

    public RubyException nameErrorLocalVariableNotDefined(String name, RubyBinding binding, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.nameError(String.format("local variable `%s' not defined for %s", name, binding.toString()), name, currentNode);
    }

    public RubyException noMethodError(String message, String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        RubyException noMethodError = new RubyException(this.context.getCoreLibrary().getNoMethodErrorClass(), StringNodes.createString(this.context.getCoreLibrary().getStringClass(), message), RubyCallStack.getBacktrace(currentNode));
        RubyBasicObject.setInstanceVariable(noMethodError, "@name", this.context.getSymbolTable().getSymbol(name));
        return noMethodError;
    }

    public RubyException noMethodErrorOnModule(String name, RubyModule module, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.noMethodError(String.format("undefined method `%s' for %s", name, module.getName()), name, currentNode);
    }

    public RubyException noMethodErrorOnReceiver(String name, Object receiver, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        RubyClass logicalClass = this.getLogicalClass(receiver);
        String repr = logicalClass.getName();
        if (receiver instanceof RubyModule) {
            repr = ((RubyModule)receiver).getName() + ":" + repr;
        }
        return this.noMethodError(String.format("undefined method `%s' for %s", name, repr), name, currentNode);
    }

    public RubyException privateMethodError(String name, RubyModule module, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.noMethodError(String.format("private method `%s' called for %s", name, module.toString()), name, currentNode);
    }

    public RubyException loadError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.context.getCoreLibrary().getLoadErrorClass(), StringNodes.createString(this.context.getCoreLibrary().getStringClass(), message), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException loadErrorCannotLoad(String name, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.loadError(String.format("cannot load such file -- %s", name), currentNode);
    }

    public RubyException zeroDivisionError(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.context.getCoreLibrary().getZeroDivisionErrorClass(), StringNodes.createString(this.context.getCoreLibrary().getStringClass(), "divided by 0"), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException notImplementedError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.notImplementedErrorClass, StringNodes.createString(this.context.getCoreLibrary().getStringClass(), String.format("Method %s not implemented", message)), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException syntaxError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.syntaxErrorClass, StringNodes.createString(this.context.getCoreLibrary().getStringClass(), message), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException floatDomainError(String value, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.floatDomainErrorClass, StringNodes.createString(this.context.getCoreLibrary().getStringClass(), value), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException mathDomainError(String method, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.getErrnoClass(Errno.EDOM), StringNodes.createString(this.context.getCoreLibrary().getStringClass(), String.format("Numerical argument is out of domain - \"%s\"", method)), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException invalidArgumentError(String value, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.getErrnoClass(Errno.EINVAL), StringNodes.createString(this.context.getCoreLibrary().getStringClass(), String.format("Invalid argument -  %s", value)), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException ioError(String fileName, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.ioErrorClass, StringNodes.createString(this.context.getCoreLibrary().getStringClass(), String.format("Error reading file -  %s", fileName)), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException badAddressError(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.getErrnoClass(Errno.EFAULT), StringNodes.createString(this.context.getCoreLibrary().getStringClass(), "Bad address"), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException badFileDescriptor(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.getErrnoClass(Errno.EBADF), StringNodes.createString(this.context.getCoreLibrary().getStringClass(), "Bad file descriptor"), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException fileExistsError(String fileName, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.getErrnoClass(Errno.EEXIST), StringNodes.createString(this.context.getCoreLibrary().getStringClass(), String.format("File exists - %s", fileName)), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException fileNotFoundError(String fileName, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.getErrnoClass(Errno.ENOENT), StringNodes.createString(this.context.getCoreLibrary().getStringClass(), String.format("No such file or directory -  %s", fileName)), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException dirNotEmptyError(String path, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.getErrnoClass(Errno.ENOTEMPTY), StringNodes.createString(this.context.getCoreLibrary().getStringClass(), String.format("Directory not empty - %s", path)), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException operationNotPermittedError(String path, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.getErrnoClass(Errno.EPERM), StringNodes.createString(this.context.getCoreLibrary().getStringClass(), String.format("Operation not permitted - %s", path)), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException permissionDeniedError(String path, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.getErrnoClass(Errno.EACCES), StringNodes.createString(this.context.getCoreLibrary().getStringClass(), String.format("Permission denied - %s", path)), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException notDirectoryError(String path, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.getErrnoClass(Errno.ENOTDIR), StringNodes.createString(this.context.getCoreLibrary().getStringClass(), String.format("Not a directory - %s", path)), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException rangeError(int code, RubyEncoding encoding, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.rangeError(String.format("invalid codepoint %x in %s", code, encoding.getEncoding()), currentNode);
    }

    public RubyException rangeError(String type, String value, String range, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.rangeError(String.format("%s %s out of range of %s", type, value, range), currentNode);
    }

    public RubyException rangeError(RubyRange.IntegerFixnumRange range, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.rangeError(String.format("%d..%s%d out of range", range.getBegin(), range.doesExcludeEnd() ? "." : "", range.getEnd()), currentNode);
    }

    public RubyException rangeError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.rangeErrorClass, StringNodes.createString(this.context.getCoreLibrary().getStringClass(), message), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException internalError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.context.getCoreLibrary().getRubyTruffleErrorClass(), StringNodes.createString(this.context.getCoreLibrary().getStringClass(), "internal implementation error - " + message), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException regexpError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.regexpErrorClass, StringNodes.createString(this.context.getCoreLibrary().getStringClass(), message), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException encodingCompatibilityErrorIncompatible(String a, String b, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.encodingCompatibilityError(String.format("incompatible character encodings: %s and %s", a, b), currentNode);
    }

    public RubyException encodingCompatibilityError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.encodingCompatibilityErrorClass, StringNodes.createString(this.context.getCoreLibrary().getStringClass(), message), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException fiberError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.fiberErrorClass, StringNodes.createString(this.context.getCoreLibrary().getStringClass(), message), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException deadFiberCalledError(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.fiberError("dead fiber called", currentNode);
    }

    public RubyException yieldFromRootFiberError(Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return this.fiberError("can't yield from root fiber", currentNode);
    }

    public RubyException threadError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.threadErrorClass, StringNodes.createString(this.context.getCoreLibrary().getStringClass(), message), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException securityError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.securityErrorClass, StringNodes.createString(this.context.getCoreLibrary().getStringClass(), message), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyException systemCallError(String message, Node currentNode) {
        CompilerAsserts.neverPartOfCompilation();
        return new RubyException(this.systemCallErrorClass, StringNodes.createString(this.context.getCoreLibrary().getStringClass(), message), RubyCallStack.getBacktrace(currentNode));
    }

    public RubyContext getContext() {
        return this.context;
    }

    public RubyClass getArrayClass() {
        return this.arrayClass;
    }

    public RubyClass getBasicObjectClass() {
        return this.basicObjectClass;
    }

    public RubyClass getBignumClass() {
        return this.bignumClass;
    }

    public RubyClass getBigDecimalClass() {
        return this.bigDecimalClass;
    }

    public RubyClass getBindingClass() {
        return this.bindingClass;
    }

    public RubyClass getClassClass() {
        return this.classClass;
    }

    public RubyClass getFalseClass() {
        return this.falseClass;
    }

    public RubyClass getFiberClass() {
        return this.fiberClass;
    }

    public RubyClass getFixnumClass() {
        return this.fixnumClass;
    }

    public RubyClass getFloatClass() {
        return this.floatClass;
    }

    public RubyClass getHashClass() {
        return this.hashClass;
    }

    public RubyClass getLoadErrorClass() {
        return this.loadErrorClass;
    }

    public RubyClass getMatchDataClass() {
        return this.matchDataClass;
    }

    public RubyClass getModuleClass() {
        return this.moduleClass;
    }

    public RubyClass getNameErrorClass() {
        return this.nameErrorClass;
    }

    public RubyClass getNilClass() {
        return this.nilClass;
    }

    public RubyClass getRubyInternalMethod() {
        return this.rubyInternalMethod;
    }

    public RubyClass getNoMethodErrorClass() {
        return this.noMethodErrorClass;
    }

    public RubyClass getObjectClass() {
        return this.objectClass;
    }

    public RubyClass getProcClass() {
        return this.procClass;
    }

    public RubyClass getRangeClass() {
        return this.rangeClass;
    }

    public RubyClass getRationalClass() {
        return this.rationalClass;
    }

    public RubyClass getRegexpClass() {
        return this.regexpClass;
    }

    public RubyClass getRubyTruffleErrorClass() {
        return this.rubyTruffleErrorClass;
    }

    public RubyClass getRuntimeErrorClass() {
        return this.runtimeErrorClass;
    }

    public RubyClass getStringClass() {
        return this.stringClass;
    }

    public RubyClass getThreadClass() {
        return this.threadClass;
    }

    public RubyClass getTimeClass() {
        return this.timeClass;
    }

    public RubyClass getTypeErrorClass() {
        return this.typeErrorClass;
    }

    public RubyClass getTrueClass() {
        return this.trueClass;
    }

    public RubyClass getZeroDivisionErrorClass() {
        return this.zeroDivisionErrorClass;
    }

    public RubyModule getKernelModule() {
        return this.kernelModule;
    }

    public RubyBasicObject getArgv() {
        return this.argv;
    }

    public RubyBasicObject getGlobalVariablesObject() {
        return this.globalVariablesObject;
    }

    public RubyBasicObject getLoadPath() {
        return (RubyBasicObject)this.globalVariablesObject.getInstanceVariable("$LOAD_PATH");
    }

    public RubyBasicObject getLoadedFeatures() {
        return (RubyBasicObject)this.globalVariablesObject.getInstanceVariable("$LOADED_FEATURES");
    }

    public RubyBasicObject getMainObject() {
        return this.mainObject;
    }

    public RubyBasicObject getNilObject() {
        return this.nilObject;
    }

    public RubyBasicObject getENV() {
        return this.envHash;
    }

    private RubyBasicObject getSystemEnv() {
        ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
        for (Map.Entry<String, String> variable : System.getenv().entrySet()) {
            entries.add(new KeyValue(StringNodes.createString(this.context.getCoreLibrary().getStringClass(), variable.getKey()), StringNodes.createString(this.context.getCoreLibrary().getStringClass(), variable.getValue())));
        }
        return HashOperations.verySlowFromEntries(this.context, entries, false);
    }

    public ArrayNodes.MinBlock getArrayMinBlock() {
        return this.arrayMinBlock;
    }

    public ArrayNodes.MaxBlock getArrayMaxBlock() {
        return this.arrayMaxBlock;
    }

    public RubyClass getNumericClass() {
        return this.numericClass;
    }

    public RubyClass getIntegerClass() {
        return this.integerClass;
    }

    public RubyClass getEncodingConverterClass() {
        return this.encodingConverterClass;
    }

    public RubyClass getUnboundMethodClass() {
        return this.unboundMethodClass;
    }

    public RubyClass getMethodClass() {
        return this.methodClass;
    }

    public RubyClass getComplexClass() {
        return this.complexClass;
    }

    public RubyClass getByteArrayClass() {
        return this.byteArrayClass;
    }

    public RubyClass getLookupTableClass() {
        return this.lookupTableClass;
    }

    public RubyClass getStringDataClass() {
        return this.stringDataClass;
    }

    public RubyClass getTranscodingClass() {
        return this.transcodingClass;
    }

    public RubyClass getTupleClass() {
        return this.tupleClass;
    }

    public RubyBasicObject getRubiniusUndefined() {
        return this.rubiniusUndefined;
    }

    public RubyClass getErrnoClass(Errno errno) {
        return this.errnoClasses.get(errno);
    }

    public RubyClass getSymbolClass() {
        return this.symbolClass;
    }

    public RubyClass getThreadBacktraceLocationClass() {
        return this.threadBacktraceLocationClass;
    }

    public RubyClass getIOBufferClass() {
        return this.ioBufferClass;
    }

    public boolean isLoadingRubyCore() {
        return this.state == State.LOADING_RUBY_CORE;
    }

    public boolean isLoaded() {
        return this.state == State.LOADED;
    }

    public boolean isSend(InternalMethod method) {
        return method.getCallTarget() == this.basicObjectSendMethod.getCallTarget();
    }

    private static class CoreLibraryNode
    extends RubyNode {
        @Node.Child
        SingletonClassNode singletonClassNode;
        @Node.Child
        FreezeNode freezeNode;

        public CoreLibraryNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.singletonClassNode = SingletonClassNodeGen.create(context, sourceSection, null);
            this.freezeNode = FreezeNodeGen.create(context, sourceSection, null);
            this.adoptChildren();
        }

        public SingletonClassNode getSingletonClassNode() {
            return this.singletonClassNode;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.nil();
        }
    }

    private static enum State {
        INITIALIZING,
        LOADING_RUBY_CORE,
        LOADED;

    }
}

