/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.pack.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.pack.nodes.PackNode;
import org.jruby.truffle.pack.runtime.PackEncoding;
import org.jruby.truffle.pack.runtime.PackFrameDescriptor;
import org.jruby.truffle.pack.runtime.PackResult;
import org.jruby.truffle.runtime.array.ArrayUtils;

public class PackRootNode
extends RootNode {
    private final String description;
    private final PackEncoding encoding;
    @Node.Child
    private PackNode child;
    @CompilerDirectives.CompilationFinal
    private int expectedLength = ArrayUtils.capacity(0, 0);

    public PackRootNode(String description, PackEncoding encoding, PackNode child) {
        super((SourceSection)new NullSourceSection("pack", description), PackFrameDescriptor.FRAME_DESCRIPTOR);
        this.description = description;
        this.encoding = encoding;
        this.child = child;
    }

    public Object execute(VirtualFrame frame) {
        boolean taint;
        byte[] output;
        int outputLength;
        frame.setObject(PackFrameDescriptor.SOURCE_SLOT, frame.getArguments()[0]);
        frame.setInt(PackFrameDescriptor.SOURCE_LENGTH_SLOT, ((Integer)frame.getArguments()[1]).intValue());
        frame.setInt(PackFrameDescriptor.SOURCE_POSITION_SLOT, 0);
        frame.setObject(PackFrameDescriptor.OUTPUT_SLOT, (Object)new byte[this.expectedLength]);
        frame.setInt(PackFrameDescriptor.OUTPUT_POSITION_SLOT, 0);
        frame.setBoolean(PackFrameDescriptor.TAINT_SLOT, false);
        this.child.execute(frame);
        try {
            outputLength = frame.getInt(PackFrameDescriptor.OUTPUT_POSITION_SLOT);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
        if (outputLength > this.expectedLength) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.expectedLength = ArrayUtils.capacity(this.expectedLength, outputLength);
        }
        try {
            output = (byte[])frame.getObject(PackFrameDescriptor.OUTPUT_SLOT);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
        try {
            taint = frame.getBoolean(PackFrameDescriptor.TAINT_SLOT);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
        return new PackResult(output, outputLength, taint, this.encoding);
    }

    public boolean isCloningAllowed() {
        return true;
    }

    public String toString() {
        return this.description;
    }
}

