/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.joni.Matcher;
import org.joni.Regex;
import org.jruby.truffle.nodes.core.RegexpGuards;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyRegexp;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.util.ByteList;

public abstract class RegexpPrimitiveNodes {

    @RubiniusPrimitive(name="regexp_set_block_last_match")
    public static abstract class RegexpSetBlockLastMatchPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpSetBlockLastMatchPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject setBlockLastMatch(RubyClass regexpClass) {
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="regexp_set_last_match")
    public static abstract class RegexpSetLastMatchPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpSetLastMatchPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object setLastMatch(RubyClass regexpClass, Object matchData) {
            RubyBasicObject.setInstanceVariable(this.getContext().getThreadManager().getCurrentThread().getThreadLocals(), "$~", matchData);
            return matchData;
        }
    }

    @RubiniusPrimitive(name="regexp_search_region", lowerFixnumParameters={1, 2})
    public static abstract class RegexpSearchRegionPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpSearchRegionPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object searchRegion(RubyRegexp regexp, RubyString string, int start, int end, boolean forward) {
            if (regexp.getRegex() == null) {
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("uninitialized Regexp", this));
            }
            if (StringNodes.scanForCodeRange(string) == 48) {
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError(String.format("invalid byte sequence in %s", StringNodes.getByteList(string).getEncoding()), this));
            }
            ByteList bl = regexp.getSource();
            Regex r = new Regex(bl.getUnsafeBytes(), bl.getBegin(), bl.getBegin() + bl.getRealSize(), regexp.getRegex().getOptions(), regexp.checkEncoding(StringNodes.getCodeRangeable(string), true));
            Matcher matcher = r.matcher(StringNodes.getByteList(string).bytes());
            return regexp.matchCommon(string, false, false, matcher, start, end);
        }
    }

    @RubiniusPrimitive(name="regexp_options")
    @ImportStatic(value={RegexpGuards.class})
    public static abstract class RegexpOptionsPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpOptionsPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isInitialized(regexp)"})
        public int options(RubyRegexp regexp) {
            return regexp.getOptions().toOptions();
        }

        @Specialization(guards={"!isInitialized(regexp)"})
        public int optionsNotInitialized(RubyRegexp regexp) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("uninitialized Regexp", this));
        }
    }

    @RubiniusPrimitive(name="regexp_initialize")
    @ImportStatic(value={RegexpGuards.class})
    public static abstract class RegexpInitializePrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpInitializePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRegexpLiteral(regexp)"})
        public RubyRegexp initializeRegexpLiteral(RubyRegexp regexp, RubyString pattern, int options) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().securityError("can't modify literal regexp", this));
        }

        @Specialization(guards={"!isRegexpLiteral(regexp)", "isInitialized(regexp)"})
        public RubyRegexp initializeAlreadyInitialized(RubyRegexp regexp, RubyString pattern, int options) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("already initialized regexp", this));
        }

        @Specialization(guards={"!isRegexpLiteral(regexp)", "!isInitialized(regexp)"})
        public RubyRegexp initialize(RubyRegexp regexp, RubyString pattern, int options) {
            regexp.initialize(this, StringNodes.getByteList(pattern), options);
            return regexp;
        }
    }

    @RubiniusPrimitive(name="regexp_fixed_encoding_p")
    public static abstract class RegexpFixedEncodingPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpFixedEncodingPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean fixedEncoding(RubyRegexp regexp) {
            return regexp.getOptions().isFixed();
        }
    }
}

