/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.core.BignumNodes;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

public abstract class BignumPrimitiveNodes {

    @RubiniusPrimitive(name="bignum_pow")
    public static abstract class BignumPowPrimitiveNode
    extends RubiniusPrimitiveNode {
        private final ConditionProfile negativeProfile = ConditionProfile.createBinaryProfile();

        public BignumPowPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject pow(RubyBasicObject a, int b) {
            return this.pow(a, (long)b);
        }

        @Specialization
        public RubyBasicObject pow(RubyBasicObject a, long b) {
            if (this.negativeProfile.profile(b < 0L)) {
                return null;
            }
            return BignumNodes.createRubyBignum(this.getContext().getCoreLibrary().getBignumClass(), BignumNodes.getBigIntegerValue(a).pow((int)b));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public double pow(RubyBasicObject a, double b) {
            return Math.pow(BignumNodes.getBigIntegerValue(a).doubleValue(), b);
        }

        @Specialization(guards={"isRubyBignum(b)"})
        public Void pow(RubyBasicObject a, RubyBasicObject b) {
            throw new UnsupportedOperationException();
        }
    }
}

