/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;

@NodeChild(value="object", type=RubyNode.class)
public abstract class ClassNode
extends RubyNode {
    public ClassNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract RubyClass executeGetClass(VirtualFrame var1, Object var2);

    @Specialization(guards={"value"})
    protected RubyClass getClassTrue(boolean value) {
        return this.getContext().getCoreLibrary().getTrueClass();
    }

    @Specialization(guards={"!value"})
    protected RubyClass getClassFalse(boolean value) {
        return this.getContext().getCoreLibrary().getFalseClass();
    }

    @Specialization
    protected RubyClass getClass(int value) {
        return this.getContext().getCoreLibrary().getFixnumClass();
    }

    @Specialization
    protected RubyClass getClass(long value) {
        return this.getContext().getCoreLibrary().getFixnumClass();
    }

    @Specialization
    protected RubyClass getClass(double value) {
        return this.getContext().getCoreLibrary().getFloatClass();
    }

    @Specialization
    protected RubyClass getClass(RubyBasicObject object) {
        return object.getLogicalClass();
    }
}

