/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.instrument;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrument.KillException;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyString;

@NodeInfo(cost=NodeCost.NONE)
public final class RubyWrapperNode
extends RubyNode
implements ProbeNode.WrapperNode {
    @Node.Child
    private RubyNode child;
    @Node.Child
    private ProbeNode probeNode;

    public RubyWrapperNode(RubyNode child) {
        super(child.getContext(), child.getSourceSection());
        assert (!(child instanceof RubyWrapperNode));
        this.child = child;
    }

    public String instrumentationInfo() {
        return "Wrapper node for Ruby";
    }

    public void insertProbe(ProbeNode newProbeNode) {
        this.probeNode = (ProbeNode)this.insert((Node)newProbeNode);
    }

    public Probe getProbe() {
        try {
            return this.probeNode.getProbe();
        }
        catch (IllegalStateException e) {
            throw new UnsupportedOperationException("A lite-Probed wrapper has no explicit Probe");
        }
    }

    @Override
    public boolean isInstrumentable() {
        return false;
    }

    public RubyNode getChild() {
        return this.child;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object result;
        this.probeNode.enter((Node)this.child, frame);
        try {
            result = this.child.execute(frame);
            this.probeNode.returnValue((Node)this.child, frame, result);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.probeNode.returnExceptional((Node)this.child, frame, e);
            throw e;
        }
        return result;
    }

    @Override
    public RubyArray executeRubyArray(VirtualFrame frame) throws UnexpectedResultException {
        RubyArray result;
        this.probeNode.enter((Node)this.child, frame);
        try {
            result = this.child.executeRubyArray(frame);
            this.probeNode.returnValue((Node)this.child, frame, (Object)result);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.probeNode.returnExceptional((Node)this.child, frame, e);
            throw e;
        }
        return result;
    }

    @Override
    public boolean executeBoolean(VirtualFrame frame) throws UnexpectedResultException {
        boolean result;
        this.probeNode.enter((Node)this.child, frame);
        try {
            result = this.child.executeBoolean(frame);
            this.probeNode.returnValue((Node)this.child, frame, (Object)result);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.probeNode.returnExceptional((Node)this.child, frame, e);
            throw e;
        }
        return result;
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.child.isDefined(frame);
    }

    @Override
    public int executeInteger(VirtualFrame frame) throws UnexpectedResultException {
        int result;
        this.probeNode.enter((Node)this.child, frame);
        try {
            result = this.child.executeInteger(frame);
            this.probeNode.returnValue((Node)this.child, frame, (Object)result);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.probeNode.returnExceptional((Node)this.child, frame, e);
            throw e;
        }
        return result;
    }

    @Override
    public long executeLong(VirtualFrame frame) throws UnexpectedResultException {
        long result;
        this.probeNode.enter((Node)this.child, frame);
        try {
            result = this.child.executeLong(frame);
            this.probeNode.returnValue((Node)this.child, frame, (Object)result);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.probeNode.returnExceptional((Node)this.child, frame, e);
            throw e;
        }
        return result;
    }

    @Override
    public double executeDouble(VirtualFrame frame) throws UnexpectedResultException {
        double result;
        this.probeNode.enter((Node)this.child, frame);
        try {
            result = this.child.executeDouble(frame);
            this.probeNode.returnValue((Node)this.child, frame, (Object)result);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.probeNode.returnExceptional((Node)this.child, frame, e);
            throw e;
        }
        return result;
    }

    @Override
    public RubyString executeRubyString(VirtualFrame frame) throws UnexpectedResultException {
        RubyString result;
        this.probeNode.enter((Node)this.child, frame);
        try {
            result = this.child.executeRubyString(frame);
            this.probeNode.returnValue((Node)this.child, frame, (Object)result);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.probeNode.returnExceptional((Node)this.child, frame, e);
            throw e;
        }
        return result;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        this.probeNode.enter((Node)this.child, frame);
        try {
            this.child.executeVoid(frame);
            this.probeNode.returnVoid((Node)this.child, frame);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.probeNode.returnExceptional((Node)this.child, frame, e);
            throw e;
        }
    }
}

