/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.exceptions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.exceptions.RescueNode;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyException;

public class RescueClassesNode
extends RescueNode {
    @Node.Children
    final RubyNode[] handlingClassNodes;

    public RescueClassesNode(RubyContext context, SourceSection sourceSection, RubyNode[] handlingClassNodes, RubyNode body) {
        super(context, sourceSection, body);
        this.handlingClassNodes = handlingClassNodes;
    }

    @Override
    public boolean canHandle(VirtualFrame frame, RubyException exception) {
        CompilerDirectives.transferToInterpreter();
        RubyClass exceptionRubyClass = exception.getLogicalClass();
        for (RubyNode handlingClassNode : this.handlingClassNodes) {
            RubyClass handlingClass = (RubyClass)handlingClassNode.execute(frame);
            if (!ModuleOperations.assignableTo(exceptionRubyClass, handlingClass)) continue;
            return true;
        }
        return false;
    }
}

