/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.conversion.ToJavaStringNode;
import org.jruby.truffle.nodes.conversion.ToJavaStringNodeGen;
import org.jruby.truffle.nodes.conversion.ToSymbolNode;
import org.jruby.truffle.nodes.conversion.ToSymbolNodeGen;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.objects.MetaClassNode;
import org.jruby.truffle.nodes.objects.MetaClassNodeGen;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class UncachedDispatchNode
extends DispatchNode {
    private final boolean ignoreVisibility;
    private final MissingBehavior missingBehavior;
    @Node.Child
    private IndirectCallNode callNode;
    @Node.Child
    private ToSymbolNode toSymbolNode;
    @Node.Child
    private ToJavaStringNode toJavaStringNode;
    @Node.Child
    private MetaClassNode metaClassNode;
    private final BranchProfile methodMissingProfile = BranchProfile.create();

    public UncachedDispatchNode(RubyContext context, boolean ignoreVisibility, DispatchAction dispatchAction, MissingBehavior missingBehavior) {
        super(context, dispatchAction);
        this.ignoreVisibility = ignoreVisibility;
        this.missingBehavior = missingBehavior;
        this.callNode = Truffle.getRuntime().createIndirectCallNode();
        this.toSymbolNode = ToSymbolNodeGen.create(context, null, null);
        this.toJavaStringNode = ToJavaStringNodeGen.create(context, null, null);
        this.metaClassNode = MetaClassNodeGen.create(context, null, null);
    }

    @Override
    protected boolean guard(Object methodName, Object receiver) {
        return true;
    }

    @Override
    public Object executeDispatch(VirtualFrame frame, Object receiverObject, Object name, Object blockObject, Object argumentsObjects) {
        DispatchAction dispatchAction = this.getDispatchAction();
        RubyClass callerClass = this.ignoreVisibility ? null : this.metaClassNode.executeMetaClass(frame, RubyArguments.getSelf(frame.getArguments()));
        InternalMethod method = this.lookup(callerClass, receiverObject, this.toJavaStringNode.executeJavaString(frame, name), this.ignoreVisibility);
        if (method != null) {
            if (dispatchAction == DispatchAction.CALL_METHOD) {
                return this.callNode.call(frame, method.getCallTarget(), RubyArguments.pack(method, method.getDeclarationFrame(), receiverObject, (RubyProc)blockObject, (Object[])argumentsObjects));
            }
            if (dispatchAction == DispatchAction.RESPOND_TO_METHOD) {
                return true;
            }
            throw new UnsupportedOperationException();
        }
        if (dispatchAction == DispatchAction.CALL_METHOD && this.missingBehavior == MissingBehavior.RETURN_MISSING) {
            return DispatchNode.MISSING;
        }
        this.methodMissingProfile.enter();
        InternalMethod missingMethod = this.lookup(callerClass, receiverObject, "method_missing", true);
        if (missingMethod == null) {
            if (dispatchAction == DispatchAction.RESPOND_TO_METHOD) {
                return false;
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().runtimeError(receiverObject.toString() + " didn't have a #method_missing", this));
        }
        if (dispatchAction == DispatchAction.CALL_METHOD) {
            Object[] argumentsObjectsArray = (Object[])argumentsObjects;
            Object[] modifiedArgumentsObjects = new Object[1 + argumentsObjectsArray.length];
            modifiedArgumentsObjects[0] = this.toSymbolNode.executeRubySymbol(frame, name);
            ArrayUtils.arraycopy(argumentsObjectsArray, 0, modifiedArgumentsObjects, 1, argumentsObjectsArray.length);
            return this.callNode.call(frame, missingMethod.getCallTarget(), RubyArguments.pack(missingMethod, missingMethod.getDeclarationFrame(), receiverObject, (RubyProc)blockObject, modifiedArgumentsObjects));
        }
        if (dispatchAction == DispatchAction.RESPOND_TO_METHOD) {
            return false;
        }
        throw new UnsupportedOperationException();
    }
}

