/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNode;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.util.cli.Options;

public abstract class DispatchNode
extends RubyNode {
    public static final int DISPATCH_POLYMORPHIC_MAX = (Integer)Options.TRUFFLE_DISPATCH_POLYMORPHIC_MAX.load();
    public static final boolean DISPATCH_METAPROGRAMMING_ALWAYS_UNCACHED = (Boolean)Options.TRUFFLE_DISPATCH_METAPROGRAMMING_ALWAYS_UNCACHED.load();
    public static final boolean DISPATCH_METAPROGRAMMING_ALWAYS_INDIRECT = (Boolean)Options.TRUFFLE_DISPATCH_METAPROGRAMMING_ALWAYS_INDIRECT.load();
    private final DispatchAction dispatchAction;
    public static final Object MISSING = new Missing();

    public DispatchNode(RubyContext context, DispatchAction dispatchAction) {
        super(context, null);
        this.dispatchAction = dispatchAction;
        assert (dispatchAction != null);
    }

    protected abstract boolean guard(Object var1, Object var2);

    protected DispatchNode getNext() {
        return null;
    }

    public abstract Object executeDispatch(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

    @CompilerDirectives.TruffleBoundary
    protected InternalMethod lookup(RubyClass callerClass, Object receiver, String name, boolean ignoreVisibility) {
        InternalMethod method = ModuleOperations.lookupMethod(this.getContext().getCoreLibrary().getMetaClass(receiver), name);
        if (method == null) {
            return null;
        }
        if (method.isUndefined()) {
            return null;
        }
        if (!ignoreVisibility && !method.isVisibleTo(this, callerClass)) {
            DispatchAction dispatchAction = this.getHeadNode().getDispatchAction();
            if (dispatchAction == DispatchAction.CALL_METHOD) {
                throw new RaiseException(this.getContext().getCoreLibrary().privateMethodError(name, this.getContext().getCoreLibrary().getLogicalClass(receiver), this));
            }
            if (dispatchAction == DispatchAction.RESPOND_TO_METHOD) {
                return null;
            }
            throw new UnsupportedOperationException();
        }
        return method;
    }

    protected Object resetAndDispatch(VirtualFrame frame, Object receiverObject, Object methodName, RubyProc blockObject, Object argumentsObjects, String reason) {
        DispatchHeadNode head = this.getHeadNode();
        head.reset(reason);
        return head.dispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
    }

    protected DispatchHeadNode getHeadNode() {
        return (DispatchHeadNode)((Object)NodeUtil.findParent((Node)this, DispatchHeadNode.class));
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        throw new IllegalStateException("do not call execute on dispatch nodes");
    }

    public DispatchAction getDispatchAction() {
        return this.dispatchAction;
    }

    public boolean couldOptimizeKeywordArguments() {
        return false;
    }

    private static final class Missing {
        private Missing() {
        }
    }
}

