/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class)})
public abstract class ArrayDropTailNode
extends RubyNode {
    final int index;

    public ArrayDropTailNode(RubyContext context, SourceSection sourceSection, int index) {
        super(context, sourceSection);
        this.index = index;
    }

    @Specialization(guards={"isNullArray(array)"})
    public RubyBasicObject getHeadNull(RubyArray array) {
        CompilerDirectives.transferToInterpreter();
        return this.createEmptyArray();
    }

    @Specialization(guards={"isIntArray(array)"})
    public RubyBasicObject getHeadIntegerFixnum(RubyArray array) {
        CompilerDirectives.transferToInterpreter();
        if (this.index >= ArrayNodes.getSize(array)) {
            return this.createEmptyArray();
        }
        return this.createArray(ArrayUtils.extractRange((int[])ArrayNodes.getStore(array), 0, ArrayNodes.getSize(array) - this.index), ArrayNodes.getSize(array) - this.index);
    }

    @Specialization(guards={"isLongArray(array)"})
    public RubyBasicObject geHeadLongFixnum(RubyArray array) {
        CompilerDirectives.transferToInterpreter();
        if (this.index >= ArrayNodes.getSize(array)) {
            return this.createEmptyArray();
        }
        int size = ArrayNodes.getSize(array) - this.index;
        return this.createArray(ArrayUtils.extractRange((long[])ArrayNodes.getStore(array), 0, size), size);
    }

    @Specialization(guards={"isDoubleArray(array)"})
    public RubyBasicObject getHeadFloat(RubyArray array) {
        CompilerDirectives.transferToInterpreter();
        if (this.index >= ArrayNodes.getSize(array)) {
            return this.createEmptyArray();
        }
        int size = ArrayNodes.getSize(array) - this.index;
        return this.createArray(ArrayUtils.extractRange((double[])ArrayNodes.getStore(array), 0, size), size);
    }

    @Specialization(guards={"isObjectArray(array)"})
    public RubyBasicObject getHeadObject(RubyArray array) {
        CompilerDirectives.transferToInterpreter();
        if (this.index >= ArrayNodes.getSize(array)) {
            return this.createEmptyArray();
        }
        int size = ArrayNodes.getSize(array) - this.index;
        return this.createArray(ArrayUtils.extractRange((Object[])ArrayNodes.getStore(array), 0, size), size);
    }
}

