/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.util.Arrays;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayMirror;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array"), @NodeChild(value="otherSize"), @NodeChild(value="other")})
public abstract class AppendManyNode
extends RubyNode {
    public AppendManyNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract RubyArray executeAppendMany(RubyArray var1, int var2, Object var3);

    @Specialization(guards={"isEmptyArray(array)"})
    public RubyBasicObject appendManyEmpty(RubyArray array, int otherSize, int[] other) {
        ArrayNodes.setStore(array, Arrays.copyOf(other, otherSize), otherSize);
        return array;
    }

    @Specialization(guards={"isEmptyArray(array)"})
    public RubyBasicObject appendManyEmpty(RubyArray array, int otherSize, long[] other) {
        ArrayNodes.setStore(array, Arrays.copyOf(other, otherSize), otherSize);
        return array;
    }

    @Specialization(guards={"isEmptyArray(array)"})
    public RubyBasicObject appendManyEmpty(RubyArray array, int otherSize, double[] other) {
        ArrayNodes.setStore(array, Arrays.copyOf(other, otherSize), otherSize);
        return array;
    }

    @Specialization(guards={"isEmptyArray(array)"})
    public RubyBasicObject appendManyEmpty(RubyArray array, int otherSize, Object[] other) {
        ArrayNodes.setStore(array, Arrays.copyOf(other, otherSize), otherSize);
        return array;
    }

    @Specialization(guards={"isIntArray(array)"})
    public RubyBasicObject appendManySameType(RubyArray array, int otherSize, int[] other, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendManySameTypeGeneric(array, ArrayMirror.reflect((int[])ArrayNodes.getStore(array)), otherSize, ArrayMirror.reflect(other), extendProfile);
        return array;
    }

    @Specialization(guards={"isLongArray(array)"})
    public RubyBasicObject appendManySameType(RubyArray array, int otherSize, long[] other, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendManySameTypeGeneric(array, ArrayMirror.reflect((long[])ArrayNodes.getStore(array)), otherSize, ArrayMirror.reflect(other), extendProfile);
        return array;
    }

    @Specialization(guards={"isDoubleArray(array)"})
    public RubyBasicObject appendManySameType(RubyArray array, int otherSize, double[] other, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendManySameTypeGeneric(array, ArrayMirror.reflect((double[])ArrayNodes.getStore(array)), otherSize, ArrayMirror.reflect(other), extendProfile);
        return array;
    }

    @Specialization(guards={"isObjectArray(array)"})
    public RubyBasicObject appendManySameType(RubyArray array, int otherSize, Object[] other, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendManySameTypeGeneric(array, ArrayMirror.reflect((Object[])ArrayNodes.getStore(array)), otherSize, ArrayMirror.reflect(other), extendProfile);
        return array;
    }

    public void appendManySameTypeGeneric(RubyArray array, ArrayMirror storeMirror, int otherSize, ArrayMirror otherStoreMirror, ConditionProfile extendProfile) {
        int oldSize = ArrayNodes.getSize(array);
        int newSize = oldSize + otherSize;
        ArrayMirror newStoreMirror = extendProfile.profile(newSize > storeMirror.getLength()) ? storeMirror.copyArrayAndMirror(ArrayUtils.capacity(storeMirror.getLength(), newSize)) : storeMirror;
        otherStoreMirror.copyTo(newStoreMirror, 0, oldSize, otherSize);
        ArrayNodes.setStore(array, newStoreMirror.getArray(), newSize);
    }

    @Specialization(guards={"isObjectArray(array)"})
    public RubyBasicObject appendManyBoxIntoObject(RubyArray array, int otherSize, int[] other, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendManyBoxIntoObjectGeneric(array, otherSize, ArrayMirror.reflect(other), extendProfile);
        return array;
    }

    @Specialization(guards={"isObjectArray(array)"})
    public RubyBasicObject appendManyBoxIntoObject(RubyArray array, int otherSize, long[] other, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendManyBoxIntoObjectGeneric(array, otherSize, ArrayMirror.reflect(other), extendProfile);
        return array;
    }

    @Specialization(guards={"isObjectArray(array)"})
    public RubyBasicObject appendManyBoxIntoObject(RubyArray array, int otherSize, double[] other, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendManyBoxIntoObjectGeneric(array, otherSize, ArrayMirror.reflect(other), extendProfile);
        return array;
    }

    public void appendManyBoxIntoObjectGeneric(RubyArray array, int otherSize, ArrayMirror otherStoreMirror, ConditionProfile extendProfile) {
        Object[] oldStore;
        int oldSize = ArrayNodes.getSize(array);
        int newSize = oldSize + otherSize;
        Object[] newStore = extendProfile.profile(newSize > (oldStore = (Object[])ArrayNodes.getStore(array)).length) ? ArrayUtils.copyOf(oldStore, ArrayUtils.capacity(oldStore.length, newSize)) : oldStore;
        otherStoreMirror.copyTo(newStore, 0, oldSize, otherSize);
        ArrayNodes.setStore(array, newStore, newSize);
    }

    @Specialization(guards={"isIntArray(array)"})
    public RubyBasicObject appendManyLongIntoInteger(RubyArray array, int otherSize, long[] other) {
        int oldSize = ArrayNodes.getSize(array);
        int newSize = oldSize + otherSize;
        int[] oldStore = (int[])ArrayNodes.getStore(array);
        long[] newStore = ArrayUtils.longCopyOf(oldStore, ArrayUtils.capacity(oldStore.length, newSize));
        System.arraycopy(other, 0, newStore, oldSize, otherSize);
        ArrayNodes.setStore(array, newStore, newSize);
        return array;
    }

    @Specialization(guards={"isIntArray(array)"})
    public RubyBasicObject appendManyGeneralizeIntegerDouble(RubyArray array, int otherSize, double[] other) {
        this.appendManyGeneralizeGeneric(array, ArrayMirror.reflect((int[])ArrayNodes.getStore(array)), otherSize, ArrayMirror.reflect(other));
        return array;
    }

    @Specialization(guards={"isIntArray(array)"})
    public RubyBasicObject appendManyGeneralizeIntegerDouble(RubyArray array, int otherSize, Object[] other) {
        this.appendManyGeneralizeGeneric(array, ArrayMirror.reflect((int[])ArrayNodes.getStore(array)), otherSize, ArrayMirror.reflect(other));
        return array;
    }

    @Specialization(guards={"isLongArray(array)"})
    public RubyBasicObject appendManyGeneralizeLongDouble(RubyArray array, int otherSize, double[] other) {
        this.appendManyGeneralizeGeneric(array, ArrayMirror.reflect((long[])ArrayNodes.getStore(array)), otherSize, ArrayMirror.reflect(other));
        return array;
    }

    @Specialization(guards={"isLongArray(array)"})
    public RubyBasicObject appendManyGeneralizeLongDouble(RubyArray array, int otherSize, Object[] other) {
        this.appendManyGeneralizeGeneric(array, ArrayMirror.reflect((long[])ArrayNodes.getStore(array)), otherSize, ArrayMirror.reflect(other));
        return array;
    }

    @Specialization(guards={"isDoubleArray(array)"})
    public RubyBasicObject appendManyGeneralizeDoubleInteger(RubyArray array, int otherSize, int[] other) {
        this.appendManyGeneralizeGeneric(array, ArrayMirror.reflect((double[])ArrayNodes.getStore(array)), otherSize, ArrayMirror.reflect(other));
        return array;
    }

    @Specialization(guards={"isDoubleArray(array)"})
    public RubyBasicObject appendManyGeneralizeDoubleLong(RubyArray array, int otherSize, long[] other) {
        this.appendManyGeneralizeGeneric(array, ArrayMirror.reflect((double[])ArrayNodes.getStore(array)), otherSize, ArrayMirror.reflect(other));
        return array;
    }

    @Specialization(guards={"isDoubleArray(array)"})
    public RubyBasicObject appendManyGeneralizeDoubleObject(RubyArray array, int otherSize, Object[] other) {
        this.appendManyGeneralizeGeneric(array, ArrayMirror.reflect((double[])ArrayNodes.getStore(array)), otherSize, ArrayMirror.reflect(other));
        return array;
    }

    public void appendManyGeneralizeGeneric(RubyArray array, ArrayMirror storeMirror, int otherSize, ArrayMirror otherStoreMirror) {
        int oldSize = ArrayNodes.getSize(array);
        int newSize = oldSize + otherSize;
        Object[] newStore = storeMirror.getBoxedCopy(ArrayUtils.capacity(storeMirror.getLength(), newSize));
        otherStoreMirror.copyTo(newStore, 0, oldSize, otherSize);
        ArrayNodes.setStore(array, newStore, newSize);
    }
}

