/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.core.BignumNodes;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.object.ObjectIDOperations;

@CoreClass(name="ObjectSpace")
public abstract class ObjectSpaceNodes {

    @CoreMethod(names={"undefine_finalizer"}, isModuleFunction=true, required=1)
    public static abstract class UndefineFinalizerNode
    extends CoreMethodArrayArgumentsNode {
        public UndefineFinalizerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object undefineFinalizer(Object object) {
            this.getContext().getObjectSpaceManager().undefineFinalizer((RubyBasicObject)object);
            return object;
        }
    }

    @CoreMethod(names={"define_finalizer"}, isModuleFunction=true, required=2)
    public static abstract class DefineFinalizerNode
    extends CoreMethodArrayArgumentsNode {
        public DefineFinalizerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject defineFinalizer(Object object, RubyProc finalizer) {
            this.getContext().getObjectSpaceManager().defineFinalizer((RubyBasicObject)object, finalizer);
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), 0, finalizer);
        }
    }

    @CoreMethod(names={"each_object"}, isModuleFunction=true, needsBlock=true, optional=1, returnsEnumeratorIfNoBlock=true)
    public static abstract class EachObjectNode
    extends YieldingCoreMethodNode {
        public EachObjectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int eachObject(VirtualFrame frame, NotProvided ofClass, RubyProc block) {
            CompilerDirectives.transferToInterpreter();
            int count = 0;
            for (RubyBasicObject object : this.getContext().getObjectSpaceManager().collectLiveObjects().values()) {
                if (this.isHidden(object)) continue;
                this.yield(frame, block, object);
                ++count;
            }
            return count;
        }

        @Specialization
        public int eachObject(VirtualFrame frame, RubyClass ofClass, RubyProc block) {
            CompilerDirectives.transferToInterpreter();
            int count = 0;
            for (RubyBasicObject object : this.getContext().getObjectSpaceManager().collectLiveObjects().values()) {
                if (this.isHidden(object) || !ModuleOperations.assignableTo(object.getLogicalClass(), ofClass)) continue;
                this.yield(frame, block, object);
                ++count;
            }
            return count;
        }

        private boolean isHidden(RubyBasicObject object) {
            return object instanceof RubyClass && ((RubyClass)object).isSingleton();
        }
    }

    @CoreMethod(names={"_id2ref"}, isModuleFunction=true, required=1)
    public static abstract class ID2RefNode
    extends CoreMethodArrayArgumentsNode {
        public ID2RefNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object id2Ref(int id) {
            return this.id2Ref((long)id);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object id2Ref(long id) {
            if (id == 4L) {
                return this.nil();
            }
            if (id == 2L) {
                return true;
            }
            if (id == 0L) {
                return false;
            }
            if (ObjectIDOperations.isSmallFixnumID(id)) {
                return ObjectIDOperations.toFixnum(id);
            }
            RubyBasicObject object = this.getContext().getObjectSpaceManager().collectLiveObjects().get(id);
            if (object == null) {
                return this.nil();
            }
            return object;
        }

        @Specialization(guards={"isRubyBignum(id)", "isLargeFixnumID(id)"})
        public Object id2RefLargeFixnum(RubyBasicObject id) {
            return BignumNodes.getBigIntegerValue(id).longValue();
        }

        @Specialization(guards={"isRubyBignum(id)", "isFloatID(id)"})
        public double id2RefFloat(RubyBasicObject id) {
            return Double.longBitsToDouble(BignumNodes.getBigIntegerValue(id).longValue());
        }

        protected boolean isLargeFixnumID(RubyBasicObject id) {
            return ObjectIDOperations.isLargeFixnumID(BignumNodes.getBigIntegerValue(id));
        }

        protected boolean isFloatID(RubyBasicObject id) {
            return ObjectIDOperations.isFloatID(BignumNodes.getBigIntegerValue(id));
        }
    }
}

