/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.RubyThread;
import org.jruby.exceptions.MainExitException;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeGen;
import org.jruby.truffle.nodes.cast.NumericToFloatNode;
import org.jruby.truffle.nodes.cast.NumericToFloatNodeGen;
import org.jruby.truffle.nodes.coerce.ToStrNodeGen;
import org.jruby.truffle.nodes.core.BasicObjectNodes;
import org.jruby.truffle.nodes.core.BasicObjectNodesFactory;
import org.jruby.truffle.nodes.core.BignumNodes;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.core.MethodNodes;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.ThreadBacktraceLocationNodes;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.dispatch.DoesRespondDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.objects.ClassNode;
import org.jruby.truffle.nodes.objects.ClassNodeGen;
import org.jruby.truffle.nodes.objects.FreezeNode;
import org.jruby.truffle.nodes.objects.FreezeNodeGen;
import org.jruby.truffle.nodes.objects.IsFrozenNode;
import org.jruby.truffle.nodes.objects.IsFrozenNodeGen;
import org.jruby.truffle.nodes.objects.IsTaintedNode;
import org.jruby.truffle.nodes.objects.IsTaintedNodeGen;
import org.jruby.truffle.nodes.objects.MetaClassNode;
import org.jruby.truffle.nodes.objects.MetaClassNodeGen;
import org.jruby.truffle.nodes.objects.SingletonClassNode;
import org.jruby.truffle.nodes.objects.SingletonClassNodeGen;
import org.jruby.truffle.nodes.objects.TaintNode;
import org.jruby.truffle.nodes.objects.TaintNodeGen;
import org.jruby.truffle.nodes.objectstorage.WriteHeadObjectFieldNode;
import org.jruby.truffle.nodes.rubinius.ObjectPrimitiveNodes;
import org.jruby.truffle.nodes.rubinius.ObjectPrimitiveNodesFactory;
import org.jruby.truffle.pack.parser.FormatParser;
import org.jruby.truffle.pack.runtime.PackResult;
import org.jruby.truffle.pack.runtime.exceptions.CantCompressNegativeException;
import org.jruby.truffle.pack.runtime.exceptions.CantConvertException;
import org.jruby.truffle.pack.runtime.exceptions.FormatException;
import org.jruby.truffle.pack.runtime.exceptions.NoImplicitConversionException;
import org.jruby.truffle.pack.runtime.exceptions.OutsideOfStringException;
import org.jruby.truffle.pack.runtime.exceptions.PackException;
import org.jruby.truffle.pack.runtime.exceptions.RangeException;
import org.jruby.truffle.pack.runtime.exceptions.TooFewArgumentsException;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.ThreadLocalObject;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.backtrace.Activation;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.hash.KeyValue;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.subsystems.FeatureManager;
import org.jruby.truffle.runtime.subsystems.ThreadManager;
import org.jruby.util.ByteList;

@CoreClass(name="Kernel")
public abstract class KernelNodes {

    @CoreMethod(names={"untaint"})
    public static abstract class UntaintNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private WriteHeadObjectFieldNode writeTaintNode = new WriteHeadObjectFieldNode(RubyBasicObject.TAINTED_IDENTIFIER);

        public UntaintNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object taint(boolean object) {
            return this.frozen(object);
        }

        @Specialization
        public Object taint(int object) {
            return this.frozen(object);
        }

        @Specialization
        public Object taint(long object) {
            return this.frozen(object);
        }

        @Specialization
        public Object taint(double object) {
            return this.frozen(object);
        }

        private Object frozen(Object object) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().frozenError(this.getContext().getCoreLibrary().getLogicalClass(object).getName(), this));
        }

        @Specialization
        public Object taint(RubyBasicObject object) {
            this.writeTaintNode.execute(object, false);
            return object;
        }
    }

    @CoreMethod(names={"to_s", "inspect"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ClassNode classNode;
        @Node.Child
        private ObjectPrimitiveNodes.ObjectIDPrimitiveNode objectIDNode;
        @Node.Child
        private ToHexStringNode toHexStringNode;

        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.classNode = ClassNodeGen.create(context, sourceSection, null);
            this.objectIDNode = ObjectPrimitiveNodesFactory.ObjectIDPrimitiveNodeFactory.create(context, sourceSection, new RubyNode[]{null});
            this.toHexStringNode = KernelNodesFactory.ToHexStringNodeFactory.create(context, sourceSection, new RubyNode[]{null});
        }

        public abstract RubyBasicObject executeToS(VirtualFrame var1, Object var2);

        @Specialization
        public RubyBasicObject toS(VirtualFrame frame, Object self) {
            CompilerDirectives.transferToInterpreter();
            String className = this.classNode.executeGetClass(frame, self).getName();
            Object id = this.objectIDNode.executeObjectID(frame, self);
            String hexID = this.toHexStringNode.executeToHexString(frame, id);
            return this.createString("#<" + className + ":0x" + hexID + ">");
        }
    }

    public static abstract class ToHexStringNode
    extends CoreMethodArrayArgumentsNode {
        public ToHexStringNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract String executeToHexString(VirtualFrame var1, Object var2);

        @Specialization
        public String toHexString(int value) {
            return this.toHexString((long)value);
        }

        @Specialization
        public String toHexString(long value) {
            return Long.toHexString(value);
        }

        @Specialization(guards={"isRubyBignum(value)"})
        public String toHexString(RubyBasicObject value) {
            return BignumNodes.getBigIntegerValue(value).toString(16);
        }
    }

    @CoreMethod(names={"tainted?"})
    public static abstract class KernelIsTaintedNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsTaintedNode isTaintedNode;

        public KernelIsTaintedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isTainted(Object object) {
            if (this.isTaintedNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.isTaintedNode = (IsTaintedNode)this.insert(IsTaintedNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
            }
            return this.isTaintedNode.executeIsTainted(object);
        }
    }

    @CoreMethod(names={"taint"})
    public static abstract class KernelTaintNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TaintNode taintNode;

        public KernelTaintNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object taint(Object object) {
            if (this.taintNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintNode = (TaintNode)this.insert(TaintNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
            }
            return this.taintNode.executeTaint(object);
        }
    }

    @CoreMethod(names={"system"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class SystemNode
    extends CoreMethodArrayArgumentsNode {
        public SystemNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean system(RubyString command) {
            CompilerDirectives.transferToInterpreter();
            RubyBasicObject env = this.getContext().getCoreLibrary().getENV();
            ArrayList<String> envp = new ArrayList<String>();
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(env)) {
                envp.add(keyValue.getKey().toString() + "=" + keyValue.getValue().toString());
            }
            try {
                Runtime.getRuntime().exec(new String[]{"bash", "-c", command.toString()}, envp.toArray(new String[envp.size()]));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
    }

    @CoreMethod(names={"format", "sprintf"}, isModuleFunction=true, argumentsAsArray=true, required=1, taintFromParameter=0)
    public static abstract class FormatNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TaintNode taintNode;

        public FormatNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(firstArgument(arguments))", "byteListsEqual(asRubyString(firstArgument(arguments)), cachedFormat)"})
        public RubyBasicObject formatCached(VirtualFrame frame, Object[] arguments, @Cached(value="privatizeByteList(asRubyString(firstArgument(arguments)))") ByteList cachedFormat, @Cached(value="create(compileFormat(asRubyString(firstArgument(arguments))))") DirectCallNode callPackNode) {
            PackResult result;
            Object[] store = ArrayUtils.extractRange(arguments, 1, arguments.length);
            try {
                result = (PackResult)callPackNode.call(frame, new Object[]{store, store.length});
            }
            catch (PackException e) {
                CompilerDirectives.transferToInterpreter();
                throw this.handleException(e);
            }
            return this.finishFormat(cachedFormat, result);
        }

        @Specialization(guards={"isRubyString(firstArgument(arguments))"}, contains={"formatCached"})
        public RubyBasicObject formatUncached(VirtualFrame frame, Object[] arguments, @Cached(value="create()") IndirectCallNode callPackNode) {
            PackResult result;
            RubyString format = (RubyString)arguments[0];
            Object[] store = ArrayUtils.extractRange(arguments, 1, arguments.length);
            try {
                result = (PackResult)callPackNode.call(frame, this.compileFormat((RubyString)arguments[0]), new Object[]{store, store.length});
            }
            catch (PackException e) {
                CompilerDirectives.transferToInterpreter();
                throw this.handleException(e);
            }
            return this.finishFormat(StringNodes.getByteList(format), result);
        }

        private RuntimeException handleException(PackException exception) {
            try {
                throw exception;
            }
            catch (TooFewArgumentsException e) {
                return new RaiseException(this.getContext().getCoreLibrary().argumentError("too few arguments", this));
            }
            catch (NoImplicitConversionException e) {
                return new RaiseException(this.getContext().getCoreLibrary().typeErrorNoImplicitConversion(e.getObject(), e.getTarget(), this));
            }
            catch (OutsideOfStringException e) {
                return new RaiseException(this.getContext().getCoreLibrary().argumentError("X outside of string", this));
            }
            catch (CantCompressNegativeException e) {
                return new RaiseException(this.getContext().getCoreLibrary().argumentError("can't compress negative numbers", this));
            }
            catch (RangeException e) {
                return new RaiseException(this.getContext().getCoreLibrary().rangeError(e.getMessage(), (Node)this));
            }
            catch (CantConvertException e) {
                return new RaiseException(this.getContext().getCoreLibrary().typeError(e.getMessage(), this));
            }
        }

        private RubyBasicObject finishFormat(ByteList format, PackResult result) {
            RubyBasicObject string = this.createString(new ByteList(result.getOutput(), 0, result.getOutputLength()));
            if (format.length() == 0) {
                StringNodes.forceEncoding(string, (Encoding)USASCIIEncoding.INSTANCE);
            } else {
                switch (result.getEncoding()) {
                    case DEFAULT: 
                    case ASCII_8BIT: {
                        break;
                    }
                    case US_ASCII: {
                        StringNodes.forceEncoding(string, (Encoding)USASCIIEncoding.INSTANCE);
                        break;
                    }
                    case UTF_8: {
                        StringNodes.forceEncoding(string, (Encoding)UTF8Encoding.INSTANCE);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            if (result.isTainted()) {
                if (this.taintNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.taintNode = (TaintNode)this.insert(TaintNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
                }
                this.taintNode.executeTaint(string);
            }
            return string;
        }

        protected ByteList privatizeByteList(RubyString string) {
            return StringNodes.getByteList(string).dup();
        }

        protected boolean byteListsEqual(RubyString string, ByteList byteList) {
            return StringNodes.getByteList(string).equal(byteList);
        }

        protected CallTarget compileFormat(RubyString format) {
            try {
                return new FormatParser(this.getContext()).parse(StringNodes.getByteList(format));
            }
            catch (FormatException e) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError(e.getMessage(), this));
            }
        }

        protected Object firstArgument(Object[] args) {
            return args[0];
        }

        protected RubyString asRubyString(Object arg) {
            return (RubyString)arg;
        }
    }

    @CoreMethod(names={"sleep"}, isModuleFunction=true, optional=1)
    public static abstract class SleepNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        NumericToFloatNode floatCastNode;

        public SleepNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public long sleep(NotProvided duration) {
            return this.doSleepMillis(Long.MAX_VALUE);
        }

        @Specialization
        public long sleep(int duration) {
            return this.doSleepMillis((long)duration * 1000L);
        }

        @Specialization
        public long sleep(long duration) {
            return this.doSleepMillis(duration * 1000L);
        }

        @Specialization
        public long sleep(double duration) {
            return this.doSleepMillis((long)(duration * 1000.0));
        }

        @Specialization(guards={"isRubiniusUndefined(duration)"})
        public long sleep(RubyBasicObject duration) {
            return this.sleep(NotProvided.INSTANCE);
        }

        @Specialization(guards={"!isRubiniusUndefined(duration)"})
        public long sleep(VirtualFrame frame, RubyBasicObject duration) {
            if (this.floatCastNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.floatCastNode = (NumericToFloatNode)this.insert(NumericToFloatNodeGen.create(this.getContext(), this.getSourceSection(), "to_f", null));
            }
            return this.sleep(this.floatCastNode.executeDouble(frame, duration));
        }

        @CompilerDirectives.TruffleBoundary
        private long doSleepMillis(final long durationInMillis) {
            if (durationInMillis < 0L) {
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("time interval must be positive", this));
            }
            final long start = System.currentTimeMillis();
            final RubyThread thread = this.getContext().getThreadManager().getCurrentThread();
            long slept = this.getContext().getThreadManager().runUntilResult(new ThreadManager.BlockingActionWithoutGlobalLock<Long>(){
                boolean shouldWakeUp = false;

                @Override
                public Long block() throws InterruptedException {
                    long now = System.currentTimeMillis();
                    long slept = now - start;
                    if (this.shouldWakeUp || slept >= durationInMillis) {
                        return slept;
                    }
                    try {
                        Thread.sleep(durationInMillis - slept);
                        return System.currentTimeMillis() - start;
                    }
                    catch (InterruptedException e) {
                        if (thread.getStatus() == RubyThread.Status.RUN) {
                            this.shouldWakeUp = true;
                        }
                        throw e;
                    }
                }
            });
            return slept / 1000L;
        }
    }

    @CoreMethod(names={"String"}, isModuleFunction=true, required=1)
    public static abstract class StringNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode toS;

        public StringNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toS = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public RubyBasicObject string(RubyString value) {
            return value;
        }

        @Specialization(guards={"!isRubyString(value)"})
        public Object string(VirtualFrame frame, Object value) {
            return this.toS.call(frame, value, "to_s", null, new Object[0]);
        }
    }

    @CoreMethod(names={"singleton_methods"}, optional=1)
    public static abstract class SingletonMethodsNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private MetaClassNode metaClassNode;
        @Node.Child
        private BooleanCastNode booleanCastNode;

        public SingletonMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
        }

        public abstract RubyBasicObject executeSingletonMethods(VirtualFrame var1, Object var2, boolean var3);

        @Specialization
        public RubyBasicObject singletonMethods(VirtualFrame frame, Object self, NotProvided includeAncestors) {
            return this.singletonMethods(frame, self, true);
        }

        @Specialization
        public RubyBasicObject singletonMethods(VirtualFrame frame, Object self, boolean includeAncestors) {
            RubyClass metaClass = this.metaClassNode.executeMetaClass(frame, self);
            if (!metaClass.isSingleton()) {
                return this.createEmptyArray();
            }
            CompilerDirectives.transferToInterpreter();
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), metaClass.filterSingletonMethods(includeAncestors, RubyModule.MethodFilter.PUBLIC_PROTECTED).toArray());
        }

        @Specialization
        public RubyBasicObject singletonMethods(VirtualFrame frame, Object self, Object includeAncestors) {
            if (this.booleanCastNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.booleanCastNode = (BooleanCastNode)this.insert(BooleanCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.singletonMethods(frame, self, this.booleanCastNode.executeBoolean(frame, includeAncestors));
        }
    }

    @CoreMethod(names={"singleton_class"})
    public static abstract class SingletonClassMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private SingletonClassNode singletonClassNode;

        public SingletonClassMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.singletonClassNode = SingletonClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public RubyClass singletonClass(VirtualFrame frame, Object self) {
            return this.singletonClassNode.executeSingletonClass(frame, self);
        }
    }

    @CoreMethod(names={"set_trace_func"}, isModuleFunction=true, required=1)
    public static abstract class SetTraceFuncNode
    extends CoreMethodArrayArgumentsNode {
        public SetTraceFuncNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNil(nil)"})
        public RubyBasicObject setTraceFunc(Object nil) {
            CompilerDirectives.transferToInterpreter();
            this.getContext().getTraceManager().setTraceFunc(null);
            return this.nil();
        }

        @Specialization
        public RubyProc setTraceFunc(RubyProc traceFunc) {
            CompilerDirectives.transferToInterpreter();
            this.getContext().getTraceManager().setTraceFunc(traceFunc);
            return traceFunc;
        }
    }

    @CoreMethod(names={"respond_to_missing?"}, required=1, optional=1)
    public static abstract class RespondToMissingNode
    extends CoreMethodArrayArgumentsNode {
        public RespondToMissingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean doesRespondToMissing(Object object, RubyString name, NotProvided includeAll) {
            return false;
        }

        @Specialization
        public boolean doesRespondToMissing(Object object, RubySymbol name, NotProvided includeAll) {
            return false;
        }

        @Specialization
        public boolean doesRespondToMissing(Object object, RubySymbol name, boolean includeAll) {
            return false;
        }

        @Specialization
        public boolean doesRespondToMissing(Object object, RubyString name, boolean includeAll) {
            return false;
        }
    }

    @CoreMethod(names={"respond_to?"}, required=1, optional=1)
    public static abstract class RespondToNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private DoesRespondDispatchHeadNode dispatch;
        @Node.Child
        private DoesRespondDispatchHeadNode dispatchIgnoreVisibility;

        public RespondToNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dispatch = new DoesRespondDispatchHeadNode(context, false, false, MissingBehavior.RETURN_MISSING, null);
            this.dispatchIgnoreVisibility = new DoesRespondDispatchHeadNode(context, true, false, MissingBehavior.RETURN_MISSING, null);
            if (DispatchNode.DISPATCH_METAPROGRAMMING_ALWAYS_UNCACHED) {
                this.dispatch.forceUncached();
                this.dispatchIgnoreVisibility.forceUncached();
            }
        }

        public abstract boolean executeDoesRespondTo(VirtualFrame var1, Object var2, Object var3, boolean var4);

        @Specialization
        public boolean doesRespondTo(VirtualFrame frame, Object object, RubyString name, NotProvided checkVisibility) {
            return this.doesRespondTo(frame, object, name, false);
        }

        @Specialization
        public boolean doesRespondTo(VirtualFrame frame, Object object, RubyString name, RubyBasicObject checkVisibility) {
            return this.doesRespondTo(frame, object, name, false);
        }

        @Specialization
        public boolean doesRespondTo(VirtualFrame frame, Object object, RubyString name, boolean ignoreVisibility) {
            if (ignoreVisibility) {
                return this.dispatchIgnoreVisibility.doesRespondTo(frame, name, object);
            }
            return this.dispatch.doesRespondTo(frame, name, object);
        }

        @Specialization
        public boolean doesRespondTo(VirtualFrame frame, Object object, RubySymbol name, NotProvided checkVisibility) {
            return this.doesRespondTo(frame, object, name, false);
        }

        @Specialization
        public boolean doesRespondTo(VirtualFrame frame, Object object, RubySymbol name, RubyBasicObject checkVisibility) {
            return this.doesRespondTo(frame, object, name, false);
        }

        @Specialization
        public boolean doesRespondTo(VirtualFrame frame, Object object, RubySymbol name, boolean ignoreVisibility) {
            if (ignoreVisibility) {
                return this.dispatchIgnoreVisibility.doesRespondTo(frame, name, object);
            }
            return this.dispatch.doesRespondTo(frame, name, object);
        }
    }

    @CoreMethod(names={"require_relative"}, isModuleFunction=true, required=1)
    public static abstract class RequireRelativeNode
    extends CoreMethodArrayArgumentsNode {
        public RequireRelativeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean requireRelative(RubyString feature) {
            String featurePath;
            CompilerDirectives.transferToInterpreter();
            FeatureManager featureManager = this.getContext().getFeatureManager();
            String featureString = feature.toString();
            if (featureManager.isAbsolutePath(featureString)) {
                featurePath = featureString;
            } else {
                Source source = Truffle.getRuntime().getCallerFrame().getCallNode().getEncapsulatingSourceSection().getSource();
                String sourcePath = featureManager.getSourcePath(source);
                if (sourcePath == null) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().loadError("cannot infer basepath", this));
                }
                featurePath = this.dirname(sourcePath) + "/" + featureString;
            }
            try {
                featureManager.require(featurePath, this);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }

        private String dirname(String path) {
            int lastSlash = path.lastIndexOf(47);
            assert (lastSlash > 0);
            return path.substring(0, lastSlash);
        }
    }

    @CoreMethod(names={"require"}, isModuleFunction=true, required=1)
    public static abstract class RequireNode
    extends CoreMethodArrayArgumentsNode {
        public RequireNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean require(RubyString feature) {
            CompilerDirectives.transferToInterpreter();
            if (feature.toString().equals("strscan") && Truffle.getRuntime().getCallerFrame().getCallNode().getEncapsulatingSourceSection().getSource().getName().endsWith("erb.rb")) {
                throw new RaiseException(this.getContext().getCoreLibrary().loadErrorCannotLoad(feature.toString(), this));
            }
            if (feature.toString().equals("openssl") && Truffle.getRuntime().getCallerFrame().getCallNode().getEncapsulatingSourceSection().getSource().getName().endsWith("securerandom.rb")) {
                this.getContext().getCoreLibrary().getObjectClass().getConstants().remove("OpenSSL");
                throw new RaiseException(this.getContext().getCoreLibrary().loadErrorCannotLoad(feature.toString(), this));
            }
            try {
                this.getContext().getFeatureManager().require(feature.toString(), this);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
    }

    @CoreMethod(names={"rand"}, isModuleFunction=true, optional=1)
    public static abstract class RandNode
    extends CoreMethodArrayArgumentsNode {
        public RandNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public double rand(NotProvided max) {
            return this.getContext().getRandom().nextDouble();
        }

        @Specialization(guards={"isZero(max)"})
        public double randZero(int max) {
            return this.getContext().getRandom().nextDouble();
        }

        @Specialization(guards={"isNonZero(max)"})
        public int randNonZero(int max) {
            return this.getContext().getRandom().nextInt(max);
        }

        @Specialization(guards={"isZero(max)"})
        public double randZero(long max) {
            return this.getContext().getRandom().nextDouble();
        }

        @Specialization(guards={"isNonZero(max)"})
        public long randNonZero(long max) {
            return this.getContext().getRandom().nextLong() % max;
        }

        protected boolean isZero(int max) {
            return max == 0;
        }

        protected boolean isNonZero(int max) {
            return max != 0;
        }

        protected boolean isZero(long max) {
            return max == 0L;
        }

        protected boolean isNonZero(long max) {
            return max != 0L;
        }
    }

    @CoreMethod(names={"public_methods"}, optional=1)
    public static abstract class PublicMethodsNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private MetaClassNode metaClassNode;
        @Node.Child
        private BooleanCastNode booleanCastNode;

        public PublicMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public RubyBasicObject publicMethods(VirtualFrame frame, Object self, NotProvided includeAncestors) {
            return this.publicMethods(frame, self, true);
        }

        @Specialization
        public RubyBasicObject publicMethods(VirtualFrame frame, Object self, boolean includeAncestors) {
            RubyClass metaClass = this.metaClassNode.executeMetaClass(frame, self);
            CompilerDirectives.transferToInterpreter();
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), metaClass.filterMethodsOnObject(includeAncestors, RubyModule.MethodFilter.PUBLIC).toArray());
        }

        @Specialization
        public RubyBasicObject publicMethods(VirtualFrame frame, RubyBasicObject self, Object includeAncestors) {
            if (this.booleanCastNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.booleanCastNode = (BooleanCastNode)this.insert(BooleanCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.publicMethods(frame, (Object)self, this.booleanCastNode.executeBoolean(frame, includeAncestors));
        }
    }

    @CoreMethod(names={"protected_methods"}, optional=1)
    public static abstract class ProtectedMethodsNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private MetaClassNode metaClassNode;
        @Node.Child
        private BooleanCastNode booleanCastNode;

        public ProtectedMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public RubyBasicObject protectedMethods(VirtualFrame frame, Object self, NotProvided includeAncestors) {
            return this.protectedMethods(frame, self, true);
        }

        @Specialization
        public RubyBasicObject protectedMethods(VirtualFrame frame, Object self, boolean includeAncestors) {
            RubyClass metaClass = this.metaClassNode.executeMetaClass(frame, self);
            CompilerDirectives.transferToInterpreter();
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), metaClass.filterMethodsOnObject(includeAncestors, RubyModule.MethodFilter.PROTECTED).toArray());
        }

        @Specialization
        public RubyBasicObject protectedMethods(VirtualFrame frame, RubyBasicObject self, Object includeAncestors) {
            if (this.booleanCastNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.booleanCastNode = (BooleanCastNode)this.insert(BooleanCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.protectedMethods(frame, (Object)self, this.booleanCastNode.executeBoolean(frame, includeAncestors));
        }
    }

    @CoreMethod(names={"proc"}, isModuleFunction=true, needsBlock=true)
    public static abstract class ProcNode
    extends CoreMethodArrayArgumentsNode {
        public ProcNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyProc proc(RubyProc block) {
            CompilerDirectives.transferToInterpreter();
            return new RubyProc(this.getContext().getCoreLibrary().getProcClass(), RubyProc.Type.PROC, block.getSharedMethodInfo(), block.getCallTargetForProcs(), block.getCallTargetForProcs(), block.getCallTargetForLambdas(), block.getDeclarationFrame(), block.getMethod(), block.getSelfCapturedInScope(), block.getBlockCapturedInScope());
        }
    }

    @CoreMethod(names={"private_methods"}, optional=1)
    public static abstract class PrivateMethodsNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private MetaClassNode metaClassNode;
        @Node.Child
        private BooleanCastNode booleanCastNode;

        public PrivateMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public RubyBasicObject privateMethods(VirtualFrame frame, Object self, NotProvided includeAncestors) {
            return this.privateMethods(frame, self, true);
        }

        @Specialization
        public RubyBasicObject privateMethods(VirtualFrame frame, Object self, boolean includeAncestors) {
            RubyClass metaClass = this.metaClassNode.executeMetaClass(frame, self);
            CompilerDirectives.transferToInterpreter();
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), metaClass.filterMethodsOnObject(includeAncestors, RubyModule.MethodFilter.PRIVATE).toArray());
        }

        @Specialization
        public RubyBasicObject privateMethods(VirtualFrame frame, RubyBasicObject self, Object includeAncestors) {
            if (this.booleanCastNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.booleanCastNode = (BooleanCastNode)this.insert(BooleanCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.privateMethods(frame, (Object)self, this.booleanCastNode.executeBoolean(frame, includeAncestors));
        }
    }

    @CoreMethod(names={"nil?"}, needsSelf=false)
    public static abstract class NilNode
    extends CoreMethodArrayArgumentsNode {
        public NilNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isNil() {
            return false;
        }
    }

    @CoreMethod(names={"methods"}, optional=1)
    public static abstract class MethodsNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private MetaClassNode metaClassNode;
        @Node.Child
        private SingletonMethodsNode singletonMethodsNode;
        @Node.Child
        private BooleanCastNode booleanCastNode;

        public MethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public RubyBasicObject methods(VirtualFrame frame, Object self, NotProvided regular) {
            return this.methods(frame, self, true);
        }

        @Specialization
        public RubyBasicObject methods(VirtualFrame frame, Object self, boolean regular) {
            RubyClass metaClass = this.metaClassNode.executeMetaClass(frame, self);
            CompilerDirectives.transferToInterpreter();
            if (regular) {
                return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), metaClass.filterMethodsOnObject(regular, RubyModule.MethodFilter.PUBLIC_PROTECTED).toArray());
            }
            if (this.singletonMethodsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.singletonMethodsNode = (SingletonMethodsNode)this.insert(KernelNodesFactory.SingletonMethodsNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null}));
            }
            return this.singletonMethodsNode.executeSingletonMethods(frame, self, false);
        }

        @Specialization
        public RubyBasicObject methods(VirtualFrame frame, RubyBasicObject self, Object regular) {
            if (this.booleanCastNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.booleanCastNode = (BooleanCastNode)this.insert(BooleanCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.methods(frame, (Object)self, this.booleanCastNode.executeBoolean(frame, regular));
        }
    }

    @CoreMethod(names={"method"}, required=1)
    public static abstract class MethodNode
    extends CoreMethodArrayArgumentsNode {
        public MethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject method(Object object, RubySymbol name) {
            return this.method(object, name.toString());
        }

        @Specialization
        public RubyBasicObject method(Object object, RubyString name) {
            return this.method(object, name.toString());
        }

        private RubyBasicObject method(Object object, String name) {
            CompilerDirectives.transferToInterpreter();
            InternalMethod method = ModuleOperations.lookupMethod(this.getContext().getCoreLibrary().getMetaClass(object), name);
            if (method == null) {
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUndefinedMethod(name, this.getContext().getCoreLibrary().getLogicalClass(object), this));
            }
            return MethodNodes.createMethod(this.getContext().getCoreLibrary().getMethodClass(), object, method);
        }
    }

    @CoreMethod(names={"__method__"}, needsSelf=false)
    public static abstract class MethodNameNode
    extends CoreMethodArrayArgumentsNode {
        public MethodNameNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubySymbol methodName() {
            CompilerDirectives.transferToInterpreter();
            return this.getContext().getSymbolTable().getSymbol(RubyCallStack.getCallingMethod(this.getContext()).getSharedMethodInfo().getName());
        }
    }

    @CoreMethod(names={"local_variables"}, needsSelf=false)
    public static abstract class LocalVariablesNode
    extends CoreMethodArrayArgumentsNode {
        public LocalVariablesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject localVariables() {
            CompilerDirectives.transferToInterpreter();
            RubyBasicObject array = this.createEmptyArray();
            for (Object name : Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.READ_ONLY, false).getFrameDescriptor().getIdentifiers()) {
                if (!(name instanceof String)) continue;
                ArrayNodes.slowPush(array, this.getContext().getSymbol((String)name));
            }
            return array;
        }
    }

    @CoreMethod(names={"load"}, isModuleFunction=true, required=1, optional=1)
    public static abstract class LoadNode
    extends CoreMethodArrayArgumentsNode {
        public LoadNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean load(RubyString file, boolean wrap) {
            if (wrap) {
                throw new UnsupportedOperationException();
            }
            try {
                this.getContext().loadFile(file.toString(), this);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().loadErrorCannotLoad(file.toString(), this));
                }
                throw e;
            }
            return true;
        }

        @Specialization
        public boolean load(RubyString file, NotProvided wrap) {
            return this.load(file, false);
        }
    }

    @CoreMethod(names={"lambda"}, isModuleFunction=true, needsBlock=true)
    public static abstract class LambdaNode
    extends CoreMethodArrayArgumentsNode {
        public LambdaNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyProc proc(NotProvided block) {
            Frame parentFrame = Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.READ_ONLY, true);
            RubyProc parentBlock = RubyArguments.getBlock(parentFrame.getArguments());
            if (parentBlock == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("tried to create Proc object without a block", this));
            }
            return this.proc(parentBlock);
        }

        @Specialization
        public RubyProc proc(RubyProc block) {
            return new RubyProc(this.getContext().getCoreLibrary().getProcClass(), RubyProc.Type.LAMBDA, block.getSharedMethodInfo(), block.getCallTargetForLambdas(), block.getCallTargetForLambdas(), block.getCallTargetForLambdas(), block.getDeclarationFrame(), block.getMethod(), block.getSelfCapturedInScope(), block.getBlockCapturedInScope());
        }
    }

    @CoreMethod(names={"is_a?", "kind_of?"}, required=1)
    public static abstract class IsANode
    extends CoreMethodArrayArgumentsNode {
        public IsANode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract boolean executeIsA(VirtualFrame var1, Object var2, RubyModule var3);

        @Specialization(guards={"isNil(nil)", "!isRubyModule(nil)"})
        public boolean isANil(RubyBasicObject self, Object nil) {
            return false;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean isA(Object self, RubyModule rubyClass) {
            CompilerDirectives.transferToInterpreter();
            return ModuleOperations.assignableTo(this.getContext().getCoreLibrary().getMetaClass(self), rubyClass);
        }
    }

    @CoreMethod(names={"instance_variables", "__instance_variables__"})
    public static abstract class InstanceVariablesNode
    extends CoreMethodArrayArgumentsNode {
        public InstanceVariablesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject instanceVariables(RubyBasicObject self) {
            CompilerDirectives.transferToInterpreter();
            Object[] instanceVariableNames = RubyBasicObject.getFieldNames(self);
            Arrays.sort(instanceVariableNames);
            RubyBasicObject array = this.createEmptyArray();
            for (Object name : instanceVariableNames) {
                if (!(name instanceof String)) continue;
                ArrayNodes.slowPush(array, this.getContext().getSymbolTable().getSymbol((String)name));
            }
            return array;
        }
    }

    @CoreMethod(names={"instance_variable_set", "__instance_variable_set__"}, raiseIfFrozenSelf=true, required=2)
    public static abstract class InstanceVariableSetNode
    extends CoreMethodArrayArgumentsNode {
        public InstanceVariableSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object instanceVariableSet(RubyBasicObject object, RubyString name, Object value) {
            RubyBasicObject.setInstanceVariable(object, RubyContext.checkInstanceVariableName(this.getContext(), name.toString(), this), value);
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object instanceVariableSet(RubyBasicObject object, RubySymbol name, Object value) {
            RubyBasicObject.setInstanceVariable(object, RubyContext.checkInstanceVariableName(this.getContext(), name.toString(), this), value);
            return value;
        }
    }

    @CoreMethod(names={"instance_variable_get"}, required=1)
    public static abstract class InstanceVariableGetNode
    extends CoreMethodArrayArgumentsNode {
        public InstanceVariableGetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object instanceVariableGet(RubyBasicObject object, RubyString name) {
            return this.instanceVariableGet(object, name.toString());
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object instanceVariableGet(RubyBasicObject object, RubySymbol name) {
            return this.instanceVariableGet(object, name.toString());
        }

        private Object instanceVariableGet(RubyBasicObject object, String name) {
            return object.getInstanceVariable(RubyContext.checkInstanceVariableName(this.getContext(), name, this));
        }
    }

    @CoreMethod(names={"instance_variable_defined?"}, required=1)
    public static abstract class InstanceVariableDefinedNode
    extends CoreMethodArrayArgumentsNode {
        public InstanceVariableDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isInstanceVariableDefined(RubyBasicObject object, RubyString name) {
            CompilerDirectives.transferToInterpreter();
            return object.isFieldDefined(RubyContext.checkInstanceVariableName(this.getContext(), name.toString(), this));
        }

        @Specialization
        public boolean isInstanceVariableDefined(RubyBasicObject object, RubySymbol name) {
            CompilerDirectives.transferToInterpreter();
            return object.isFieldDefined(RubyContext.checkInstanceVariableName(this.getContext(), name.toString(), this));
        }
    }

    @CoreMethod(names={"instance_of?"}, required=1)
    public static abstract class InstanceOfNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ClassNode classNode;

        public InstanceOfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.classNode = ClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public boolean instanceOf(VirtualFrame frame, Object self, RubyClass rubyClass) {
            return this.classNode.executeGetClass(frame, self) == rubyClass;
        }
    }

    @CoreMethod(names={"initialize_dup", "initialize_clone"}, required=1)
    public static abstract class InitializeDupCloneNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode initializeCopyNode;

        public InitializeDupCloneNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.initializeCopyNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
        }

        @Specialization
        public Object initializeDup(VirtualFrame frame, RubyBasicObject self, RubyBasicObject from) {
            return this.initializeCopyNode.call(frame, self, "initialize_copy", null, from);
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object initializeCopy(RubyBasicObject self, RubyBasicObject from) {
            CompilerDirectives.transferToInterpreter();
            if (self.getLogicalClass() != from.getLogicalClass()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("initialize_copy should take same class object", this));
            }
            return self;
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        public HashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int hash(int value) {
            return value;
        }

        @Specialization
        public int hash(long value) {
            return Long.valueOf(value).hashCode();
        }

        @Specialization
        public int hash(double value) {
            return Double.valueOf(value).hashCode();
        }

        @Specialization
        public int hash(boolean value) {
            return Boolean.valueOf(value).hashCode();
        }

        @Specialization
        public int hash(RubyBasicObject self) {
            return System.identityHashCode(self);
        }
    }

    @CoreMethod(names={"gets"}, isModuleFunction=true)
    public static abstract class GetsNode
    extends CoreMethodArrayArgumentsNode {
        public GetsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject gets(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            InputStream in = this.getContext().getRuntime().getInstanceConfig().getInput();
            Encoding encoding = this.getContext().getRuntime().getDefaultExternalEncoding();
            final BufferedReader reader = new BufferedReader(new InputStreamReader(in, encoding.getCharset()));
            String line = this.getContext().getThreadManager().runUntilResult(new ThreadManager.BlockingActionWithoutGlobalLock<String>(){

                @Override
                public String block() throws InterruptedException {
                    return GetsNode.gets(reader);
                }
            });
            RubyBasicObject rubyLine = this.createString(line);
            Frame caller = Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.READ_WRITE, false);
            FrameSlot slot = caller.getFrameDescriptor().findFrameSlot((Object)"$_");
            if (slot != null) {
                caller.setObject(slot, (Object)ThreadLocalObject.wrap(this.getContext(), rubyLine));
            }
            return rubyLine;
        }

        @CompilerDirectives.TruffleBoundary
        private static String gets(BufferedReader reader) throws InterruptedException {
            try {
                return reader.readLine() + "\n";
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @CoreMethod(names={"frozen?"})
    public static abstract class KernelFrozenNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsFrozenNode isFrozenNode;

        public KernelFrozenNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isFrozen(Object self) {
            if (this.isFrozenNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.isFrozenNode = (IsFrozenNode)this.insert(IsFrozenNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
            }
            return this.isFrozenNode.executeIsFrozen(self);
        }
    }

    @CoreMethod(names={"freeze"})
    public static abstract class KernelFreezeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private FreezeNode freezeNode;

        public KernelFreezeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object freeze(Object self) {
            if (this.freezeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.freezeNode = (FreezeNode)this.insert(FreezeNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
            }
            return this.freezeNode.executeFreeze(self);
        }
    }

    @CoreMethod(names={"fork"}, isModuleFunction=true, argumentsAsArray=true)
    public static abstract class ForkNode
    extends CoreMethodArrayArgumentsNode {
        public ForkNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object fork(Object[] args) {
            CompilerDirectives.transferToInterpreter();
            this.getContext().getWarnings().warn("Kernel#fork not implemented - defined to satisfy some metaprogramming in RubySpec");
            return this.nil();
        }
    }

    @CoreMethod(names={"exit!"}, isModuleFunction=true, optional=1)
    public static abstract class ExitBangNode
    extends CoreMethodArrayArgumentsNode {
        public ExitBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject exit(NotProvided exitCode) {
            return this.exit(1);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject exit(int exitCode) {
            this.getContext().innerShutdown(false);
            throw new MainExitException(exitCode, true);
        }
    }

    @CoreMethod(names={"exit"}, isModuleFunction=true, optional=1, lowerFixnumParameters={0})
    public static abstract class ExitNode
    extends CoreMethodArrayArgumentsNode {
        public ExitNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object exit(NotProvided exitCode) {
            return this.exit(0);
        }

        @Specialization
        public Object exit(int exitCode) {
            CompilerDirectives.transferToInterpreter();
            this.getContext().shutdown();
            System.exit(exitCode);
            return null;
        }

        @Specialization
        public Object exit(boolean status) {
            CompilerDirectives.transferToInterpreter();
            this.getContext().shutdown();
            System.exit(status ? 0 : -1);
            return null;
        }
    }

    @CoreMethod(names={"exec"}, isModuleFunction=true, required=1, argumentsAsArray=true)
    public static abstract class ExecNode
    extends CoreMethodArrayArgumentsNode {
        public ExecNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object require(Object[] args) {
            CompilerDirectives.transferToInterpreter();
            String[] commandLine = new String[args.length];
            for (int n = 0; n < args.length; ++n) {
                commandLine[n] = args[n].toString();
            }
            ExecNode.exec(this.getContext(), commandLine);
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        private static void exec(RubyContext context, String[] commandLine) {
            Process process;
            ProcessBuilder builder = new ProcessBuilder(commandLine);
            builder.inheritIO();
            RubyBasicObject env = context.getCoreLibrary().getENV();
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(env)) {
                builder.environment().put(keyValue.getKey().toString(), keyValue.getValue().toString());
            }
            try {
                process = builder.start();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            int exitCode = context.getThreadManager().runUntilResult(new ThreadManager.BlockingActionWithoutGlobalLock<Integer>(){

                @Override
                public Integer block() throws InterruptedException {
                    return process.waitFor();
                }
            });
            System.exit(exitCode);
        }
    }

    @CoreMethod(names={"eval"}, isModuleFunction=true, required=1, optional=3, lowerFixnumParameters={3})
    @NodeChildren(value={@NodeChild(value="source", type=RubyNode.class), @NodeChild(value="binding", type=RubyNode.class), @NodeChild(value="filename", type=RubyNode.class), @NodeChild(value="lineNumber", type=RubyNode.class)})
    public static abstract class EvalNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode toStr;
        @Node.Child
        private BindingNode bindingNode;

        public EvalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"source"})
        public RubyNode coerceSourceToString(RubyNode source) {
            return ToStrNodeGen.create(this.getContext(), this.getSourceSection(), source);
        }

        protected RubyBinding getCallerBinding(VirtualFrame frame) {
            if (this.bindingNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.bindingNode = (BindingNode)this.insert(KernelNodesFactory.BindingNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
            }
            return this.bindingNode.executeRubyBinding(frame);
        }

        @Specialization
        public Object eval(VirtualFrame frame, RubyString source, NotProvided binding, NotProvided filename, NotProvided lineNumber) {
            CompilerDirectives.transferToInterpreter();
            return this.getContext().eval(StringNodes.getByteList(source), this.getCallerBinding(frame), true, this);
        }

        @Specialization(guards={"isNil(noBinding)"})
        public Object eval(VirtualFrame frame, RubyString source, Object noBinding, RubyString filename, int lineNumber) {
            CompilerDirectives.transferToInterpreter();
            return this.eval(frame, source, NotProvided.INSTANCE, NotProvided.INSTANCE, NotProvided.INSTANCE);
        }

        @Specialization
        public Object eval(RubyString source, RubyBinding binding, NotProvided filename, NotProvided lineNumber) {
            CompilerDirectives.transferToInterpreter();
            return this.getContext().eval(StringNodes.getByteList(source), binding, false, this);
        }

        @Specialization
        public Object eval(RubyString source, RubyBinding binding, RubyString filename, NotProvided lineNumber) {
            CompilerDirectives.transferToInterpreter();
            return this.getContext().eval(StringNodes.getByteList(source), binding, false, filename.toString(), (Node)this);
        }

        @Specialization
        public Object eval(RubyString source, RubyBinding binding, RubyString filename, int lineNumber) {
            CompilerDirectives.transferToInterpreter();
            return this.getContext().eval(StringNodes.getByteList(source), binding, false, filename.toString(), (Node)this);
        }

        @Specialization(guards={"!isRubyBinding(badBinding)"})
        public Object eval(RubyString source, RubyBasicObject badBinding, NotProvided filename, NotProvided lineNumber) {
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorWrongArgumentType(badBinding, "binding", this));
        }
    }

    @CoreMethod(names={"dup"}, taintFromSelf=true)
    public static abstract class DupNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CopyNode copyNode;
        @Node.Child
        private CallDispatchHeadNode initializeDupNode;

        public DupNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.copyNode = KernelNodesFactory.CopyNodeFactory.create(context, sourceSection, null);
            this.initializeDupNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
        }

        @Specialization
        public RubyBasicObject dup(VirtualFrame frame, RubyBasicObject self) {
            RubyBasicObject newObject = this.copyNode.executeCopy(frame, self);
            this.initializeDupNode.call(frame, newObject, "initialize_dup", null, self);
            return newObject;
        }
    }

    @CoreMethod(names={"clone"}, taintFromSelf=true)
    public static abstract class CloneNode
    extends CoreMethodArrayArgumentsNode {
        private final ConditionProfile frozenProfile = ConditionProfile.createBinaryProfile();
        @Node.Child
        private CopyNode copyNode;
        @Node.Child
        private CallDispatchHeadNode initializeCloneNode;
        @Node.Child
        private IsFrozenNode isFrozenNode;
        @Node.Child
        private FreezeNode freezeNode;
        @Node.Child
        private SingletonClassNode singletonClassNode;

        public CloneNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.copyNode = KernelNodesFactory.CopyNodeFactory.create(context, sourceSection, null);
            this.initializeCloneNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
            this.isFrozenNode = IsFrozenNodeGen.create(context, sourceSection, null);
            this.freezeNode = FreezeNodeGen.create(context, sourceSection, null);
            this.singletonClassNode = SingletonClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public RubyBasicObject clone(VirtualFrame frame, RubyBasicObject self) {
            CompilerDirectives.transferToInterpreter();
            RubyBasicObject newObject = this.copyNode.executeCopy(frame, self);
            if (self.getMetaClass().isSingleton()) {
                this.singletonClassNode.executeSingletonClass(frame, newObject).initCopy(self.getMetaClass());
            }
            this.initializeCloneNode.call(frame, newObject, "initialize_clone", null, self);
            if (this.frozenProfile.profile(this.isFrozenNode.executeIsFrozen(self))) {
                this.freezeNode.executeFreeze(newObject);
            }
            return newObject;
        }
    }

    public static abstract class CopyNode
    extends UnaryCoreMethodNode {
        public CopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract RubyBasicObject executeCopy(VirtualFrame var1, RubyBasicObject var2);

        @Specialization
        public RubyBasicObject copy(VirtualFrame frame, RubyBasicObject self) {
            RubyBasicObject newObject = self.getLogicalClass().allocate(this);
            RubyBasicObject.setInstanceVariables(newObject, RubyBasicObject.getInstanceVariables(self));
            return newObject;
        }
    }

    @CoreMethod(names={"class"})
    public static abstract class KernelClassNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ClassNode classNode;

        public KernelClassNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.classNode = ClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public RubyClass getClass(VirtualFrame frame, Object self) {
            return this.classNode.executeGetClass(frame, self);
        }
    }

    @CoreMethod(names={"caller_locations"}, isModuleFunction=true, optional=2, lowerFixnumParameters={0, 1})
    public static abstract class CallerLocationsNode
    extends CoreMethodArrayArgumentsNode {
        public CallerLocationsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject callerLocations(NotProvided omit, NotProvided length) {
            return this.callerLocations(1, -1);
        }

        @Specialization
        public RubyBasicObject callerLocations(int omit, NotProvided length) {
            return this.callerLocations(omit, -1);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject callerLocations(int omit, int length) {
            RubyClass threadBacktraceLocationClass = this.getContext().getCoreLibrary().getThreadBacktraceLocationClass();
            Backtrace backtrace = RubyCallStack.getBacktrace(this, 1 + omit, true);
            int locationsCount = backtrace.getActivations().size();
            if (length != -1 && locationsCount > length) {
                locationsCount = length;
            }
            Object[] locations = new Object[locationsCount];
            for (int n = 0; n < locationsCount; ++n) {
                Activation activation = backtrace.getActivations().get(n);
                locations[n] = ThreadBacktraceLocationNodes.createRubyThreadBacktraceLocation(threadBacktraceLocationClass, activation);
            }
            return this.createArray(locations, locations.length);
        }
    }

    @CoreMethod(names={"__callee__"}, needsSelf=false)
    public static abstract class CalleeNameNode
    extends CoreMethodArrayArgumentsNode {
        public CalleeNameNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubySymbol calleeName() {
            CompilerDirectives.transferToInterpreter();
            return this.getContext().getSymbolTable().getSymbol(RubyCallStack.getCallingMethod(this.getContext()).getName());
        }
    }

    @CoreMethod(names={"block_given?"}, isModuleFunction=true)
    public static abstract class BlockGivenNode
    extends CoreMethodArrayArgumentsNode {
        public BlockGivenNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean blockGiven() {
            return RubyArguments.getBlock(Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.READ_ONLY, false).getArguments()) != null;
        }
    }

    @CoreMethod(names={"binding"}, isModuleFunction=true)
    public static abstract class BindingNode
    extends CoreMethodArrayArgumentsNode {
        public BindingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract RubyBinding executeRubyBinding(VirtualFrame var1);

        @Override
        public Object execute(VirtualFrame frame) {
            return this.executeRubyBinding(frame);
        }

        @Specialization
        public RubyBinding binding() {
            MaterializedFrame callerFrame = Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.MATERIALIZE, false).materialize();
            return new RubyBinding(this.getContext().getCoreLibrary().getBindingClass(), RubyArguments.getSelf(callerFrame.getArguments()), callerFrame);
        }
    }

    @CoreMethod(names={"abort"}, isModuleFunction=true, optional=1)
    public static abstract class AbortNode
    extends CoreMethodArrayArgumentsNode {
        public AbortNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(message)"})
        public RubyBasicObject abort(RubyBasicObject message) {
            System.err.println(message.toString());
            return this.abort();
        }

        @Specialization
        public RubyBasicObject abort(NotProvided message) {
            return this.abort();
        }

        @CompilerDirectives.TruffleBoundary
        private RubyBasicObject abort() {
            this.getContext().innerShutdown(false);
            throw new MainExitException(1, true);
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private SameOrEqualNode equalNode;

        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.equalNode = KernelNodesFactory.SameOrEqualNodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
        }

        @Specialization
        public Object compare(VirtualFrame frame, Object self, Object other) {
            if (this.equalNode.executeSameOrEqual(frame, self, other)) {
                return 0;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"!~"}, required=1)
    public static abstract class NotMatchNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode matchNode;

        public NotMatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.matchNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public boolean notMatch(VirtualFrame frame, Object self, Object other) {
            return !this.matchNode.callBoolean(frame, self, "=~", null, other);
        }
    }

    @CoreMethod(names={"=~"}, required=1, needsSelf=false)
    public static abstract class MatchNode
    extends CoreMethodArrayArgumentsNode {
        public MatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject equal(Object other) {
            return this.nil();
        }
    }

    @CoreMethod(names={"==="}, required=1)
    public static abstract class SameOrEqualNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private BasicObjectNodes.ReferenceEqualNode referenceEqualNode;
        @Node.Child
        private CallDispatchHeadNode equalNode;
        private final ConditionProfile sameProfile = ConditionProfile.createBinaryProfile();

        public SameOrEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract boolean executeSameOrEqual(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        public boolean sameOrEqual(VirtualFrame frame, Object a, Object b) {
            if (this.sameProfile.profile(this.areSame(frame, a, b))) {
                return true;
            }
            return this.areEqual(frame, a, b);
        }

        private boolean areSame(VirtualFrame frame, Object left, Object right) {
            if (this.referenceEqualNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.referenceEqualNode = (BasicObjectNodes.ReferenceEqualNode)this.insert(BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(this.getContext(), this.getSourceSection(), null, null));
            }
            return this.referenceEqualNode.executeReferenceEqual(frame, left, right);
        }

        private boolean areEqual(VirtualFrame frame, Object left, Object right) {
            if (this.equalNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.equalNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            return this.equalNode.callBoolean(frame, left, "==", null, right);
        }
    }

    @CoreMethod(names={"`"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class BacktickNode
    extends CoreMethodArrayArgumentsNode {
        public BacktickNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject backtick(RubyString command) {
            Process process;
            CompilerDirectives.transferToInterpreter();
            RubyContext context = this.getContext();
            RubyBasicObject env = context.getCoreLibrary().getENV();
            ArrayList<String> envp = new ArrayList<String>();
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(env)) {
                envp.add(keyValue.getKey().toString() + "=" + keyValue.getValue().toString());
            }
            try {
                process = Runtime.getRuntime().exec(new String[]{"bash", "-c", command.toString()}, envp.toArray(new String[envp.size()]));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            InputStream stdout = process.getInputStream();
            InputStreamReader reader = new InputStreamReader(stdout, StandardCharsets.UTF_8);
            StringBuilder resultBuilder = new StringBuilder();
            try {
                int c;
                while ((c = reader.read()) != -1) {
                    resultBuilder.append((char)c);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.createString(resultBuilder.toString(), RubyEncoding.getEncoding("UTF-8").getEncoding());
        }
    }
}

