/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.BignumNodes;
import org.jruby.truffle.runtime.RubyContext;

public class FixnumOrBignumNode
extends RubyNode {
    private final BranchProfile lowerProfile = BranchProfile.create();
    private final BranchProfile integerFromBignumProfile = BranchProfile.create();
    private final BranchProfile longFromBignumProfile = BranchProfile.create();
    private final BranchProfile integerFromDoubleProfile = BranchProfile.create();
    private final BranchProfile longFromDoubleProfile = BranchProfile.create();
    private final BranchProfile bignumProfile = BranchProfile.create();
    private final BranchProfile checkLongProfile = BranchProfile.create();

    public FixnumOrBignumNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public Object fixnumOrBignum(BigInteger value) {
        if (value.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) >= 0 && value.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0) {
            this.lowerProfile.enter();
            long longValue = value.longValue();
            if (longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE) {
                this.integerFromBignumProfile.enter();
                return (int)longValue;
            }
            this.longFromBignumProfile.enter();
            return longValue;
        }
        return BignumNodes.createRubyBignum(this.getContext().getCoreLibrary().getBignumClass(), value);
    }

    public Object fixnumOrBignum(double value) {
        if (value > -2.147483648E9 && value < 2.147483647E9) {
            this.integerFromDoubleProfile.enter();
            return (int)value;
        }
        this.checkLongProfile.enter();
        if (value > -9.223372036854776E18 && value < 9.223372036854776E18) {
            this.longFromDoubleProfile.enter();
            return (long)value;
        }
        this.bignumProfile.enter();
        return this.fixnumOrBignum(FixnumOrBignumNode.doubleToBigInteger(value));
    }

    @CompilerDirectives.TruffleBoundary
    private static BigInteger doubleToBigInteger(double value) {
        return new BigDecimal(value).toBigInteger();
    }

    @Override
    public Object execute(VirtualFrame frame) {
        throw new UnsupportedOperationException();
    }
}

