/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.ModuleNodes;
import org.jruby.truffle.nodes.core.ModuleNodesFactory;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyProc;

@CoreClass(name="Class")
public abstract class ClassNodes {

    @CoreMethod(names={"superclass"})
    public static abstract class SuperClassNode
    extends CoreMethodArrayArgumentsNode {
        public SuperClassNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object getSuperClass(RubyClass rubyClass) {
            RubyClass superclass = rubyClass.getSuperClass();
            if (superclass == null) {
                return this.nil();
            }
            return superclass;
        }
    }

    @CoreMethod(names={"inherited"}, required=1, visibility=Visibility.PRIVATE)
    public static abstract class InheritedNode
    extends CoreMethodArrayArgumentsNode {
        public InheritedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject inherited(Object subclass) {
            return this.nil();
        }
    }

    @CoreMethod(names={"initialize"}, optional=1, needsBlock=true)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ModuleNodes.InitializeNode moduleInitializeNode;

        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        void moduleInitialize(VirtualFrame frame, RubyClass rubyClass, RubyProc block) {
            if (this.moduleInitializeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.moduleInitializeNode = (ModuleNodes.InitializeNode)this.insert(ModuleNodesFactory.InitializeNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null}));
            }
            this.moduleInitializeNode.executeInitialize(frame, rubyClass, block);
        }

        @Specialization
        public RubyClass initialize(RubyClass rubyClass, NotProvided superclass, NotProvided block) {
            return this.initialize(rubyClass, this.getContext().getCoreLibrary().getObjectClass(), block);
        }

        @Specialization
        public RubyClass initialize(RubyClass rubyClass, RubyClass superclass, NotProvided block) {
            rubyClass.initialize(superclass);
            return rubyClass;
        }

        @Specialization
        public RubyClass initialize(VirtualFrame frame, RubyClass rubyClass, NotProvided superclass, RubyProc block) {
            return this.initialize(frame, rubyClass, this.getContext().getCoreLibrary().getObjectClass(), block);
        }

        @Specialization
        public RubyClass initialize(VirtualFrame frame, RubyClass rubyClass, RubyClass superclass, RubyProc block) {
            rubyClass.initialize(superclass);
            this.moduleInitialize(frame, rubyClass, block);
            return rubyClass;
        }
    }

    @CoreMethod(names={"new"}, needsBlock=true, argumentsAsArray=true)
    public static abstract class NewNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode allocateNode;
        @Node.Child
        private CallDispatchHeadNode initialize;

        public NewNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
            this.initialize = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
        }

        @Specialization
        public Object newInstance(VirtualFrame frame, RubyClass rubyClass, Object[] args, NotProvided block) {
            return this.doNewInstance(frame, rubyClass, args, null);
        }

        @Specialization
        public Object newInstance(VirtualFrame frame, RubyClass rubyClass, Object[] args, RubyProc block) {
            return this.doNewInstance(frame, rubyClass, args, block);
        }

        private Object doNewInstance(VirtualFrame frame, RubyClass rubyClass, Object[] args, RubyProc block) {
            Object instance = this.allocateNode.call(frame, rubyClass, "allocate", null, new Object[0]);
            this.initialize.call(frame, instance, "initialize", block, args);
            return instance;
        }
    }

    @CoreMethod(names={"allocate"})
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract RubyBasicObject executeAllocate(VirtualFrame var1, RubyClass var2);

        @Specialization
        public RubyBasicObject allocate(RubyClass rubyClass) {
            if (rubyClass.isSingleton()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("can't create instance of singleton class", this));
            }
            return rubyClass.allocate(this);
        }
    }
}

