/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.control;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyProc;

public class TraceNode
extends RubyNode {
    private final RubyContext context;
    @CompilerDirectives.CompilationFinal
    private Assumption traceAssumption;
    @CompilerDirectives.CompilationFinal
    private RubyProc traceFunc;
    @Node.Child
    private DirectCallNode callNode;
    private final RubyBasicObject event;
    private final RubyBasicObject file;
    private final int line;

    public TraceNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.context = context;
        this.traceAssumption = context.getTraceManager().getTraceAssumption();
        this.traceFunc = null;
        this.callNode = null;
        this.event = this.createString("line");
        this.file = this.createString(sourceSection.getSource().getName());
        this.line = sourceSection.getStartLine();
    }

    @Override
    public Object execute(VirtualFrame frame) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        this.trace(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(VirtualFrame frame) {
        try {
            this.traceAssumption.check();
        }
        catch (InvalidAssumptionException e) {
            this.traceAssumption = this.context.getTraceManager().getTraceAssumption();
            this.traceFunc = this.context.getTraceManager().getTraceFunc();
            this.callNode = this.traceFunc != null ? (DirectCallNode)this.insert((Node)Truffle.getRuntime().createDirectCallNode(this.traceFunc.getCallTargetForBlocks())) : null;
        }
        if (this.traceFunc != null && !this.context.getTraceManager().isInTraceFunc()) {
            this.context.getTraceManager().setInTraceFunc(true);
            Object[] args = new Object[]{this.event, this.file, this.line, this.context.getCoreLibrary().getNilObject(), new RubyBinding(this.context.getCoreLibrary().getBindingClass(), RubyArguments.getSelf(frame.getArguments()), frame.materialize()), this.context.getCoreLibrary().getNilObject()};
            try {
                this.callNode.call(frame, RubyArguments.pack(this.traceFunc.getMethod(), this.traceFunc.getDeclarationFrame(), this.traceFunc.getSelfCapturedInScope(), this.traceFunc.getBlockCapturedInScope(), args));
            }
            finally {
                this.context.getTraceManager().setInTraceFunc(false);
            }
        }
    }
}

