/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.util;

import com.oracle.truffle.api.CompilerAsserts;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyArguments;

public abstract class ArrayUtils {
    public static int[] extractRange(int[] source, int start, int end) {
        assert (ArrayUtils.assertExtractRangeArgs(source, start, end));
        int length = end - start;
        int[] result = new int[length];
        System.arraycopy(source, start, result, 0, length);
        return result;
    }

    public static long[] extractRange(long[] source, int start, int end) {
        assert (ArrayUtils.assertExtractRangeArgs(source, start, end));
        int length = end - start;
        long[] result = new long[length];
        System.arraycopy(source, start, result, 0, length);
        return result;
    }

    public static double[] extractRange(double[] source, int start, int end) {
        assert (ArrayUtils.assertExtractRangeArgs(source, start, end));
        int length = end - start;
        double[] result = new double[length];
        System.arraycopy(source, start, result, 0, length);
        return result;
    }

    public static Object[] extractRange(Object[] source, int start, int end) {
        assert (ArrayUtils.assertExtractRangeArgs(source, start, end));
        int length = end - start;
        Object[] result = new Object[length];
        System.arraycopy(source, start, result, 0, length);
        return result;
    }

    private static boolean assertExtractRangeArgs(Object source, int start, int end) {
        assert (source != null);
        assert (start >= 0);
        assert (start <= Array.getLength(source));
        assert (end >= start);
        assert (end <= Array.getLength(source));
        return true;
    }

    public static boolean contains(int[] array, int value) {
        for (int n = 0; n < array.length; ++n) {
            if (array[n] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(long[] array, long value) {
        for (int n = 0; n < array.length; ++n) {
            if (array[n] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(double[] array, double value) {
        for (int n = 0; n < array.length; ++n) {
            if (array[n] != value) continue;
            return true;
        }
        return false;
    }

    public static Object[] box(int[] unboxed) {
        return ArrayUtils.box(unboxed, 0);
    }

    public static Object[] box(long[] unboxed) {
        return ArrayUtils.box(unboxed, 0);
    }

    public static Object[] box(double[] unboxed) {
        return ArrayUtils.box(unboxed, 0);
    }

    public static Object[] box(Object array) {
        return ArrayUtils.box(array, 0);
    }

    public static Object[] box(int[] unboxed, int extra) {
        Object[] boxed = new Object[unboxed.length + extra];
        for (int n = 0; n < unboxed.length; ++n) {
            boxed[n] = unboxed[n];
        }
        return boxed;
    }

    public static Object[] box(long[] unboxed, int extra) {
        Object[] boxed = new Object[unboxed.length + extra];
        for (int n = 0; n < unboxed.length; ++n) {
            boxed[n] = unboxed[n];
        }
        return boxed;
    }

    public static Object[] box(double[] unboxed, int extra) {
        Object[] boxed = new Object[unboxed.length + extra];
        for (int n = 0; n < unboxed.length; ++n) {
            boxed[n] = unboxed[n];
        }
        return boxed;
    }

    public static Object[] boxUntil(int[] unboxed, int length) {
        Object[] boxed = new Object[length];
        for (int n = 0; n < length; ++n) {
            boxed[n] = unboxed[n];
        }
        return boxed;
    }

    public static Object[] boxUntil(long[] unboxed, int length) {
        Object[] boxed = new Object[length];
        for (int n = 0; n < length; ++n) {
            boxed[n] = unboxed[n];
        }
        return boxed;
    }

    public static Object[] boxUntil(double[] unboxed, int length) {
        Object[] boxed = new Object[length];
        for (int n = 0; n < length; ++n) {
            boxed[n] = unboxed[n];
        }
        return boxed;
    }

    public static Object[] box(Object array, int extra) {
        CompilerAsserts.neverPartOfCompilation();
        if (array == null) {
            return new Object[extra];
        }
        if (array instanceof int[]) {
            return ArrayUtils.box((int[])array, extra);
        }
        if (array instanceof long[]) {
            return ArrayUtils.box((long[])array, extra);
        }
        if (array instanceof double[]) {
            return ArrayUtils.box((double[])array, extra);
        }
        if (array instanceof Object[]) {
            Object[] objectArray = (Object[])array;
            return Arrays.copyOf(objectArray, objectArray.length + extra);
        }
        throw new UnsupportedOperationException();
    }

    public static int[] unboxInteger(Object[] unboxed, int length) {
        CompilerAsserts.neverPartOfCompilation();
        int[] boxed = new int[length];
        for (int n = 0; n < length; ++n) {
            boxed[n] = (Integer)unboxed[n];
        }
        return boxed;
    }

    public static long[] unboxLong(Object[] unboxed, int length) {
        CompilerAsserts.neverPartOfCompilation();
        long[] boxed = new long[length];
        for (int n = 0; n < length; ++n) {
            Object value = unboxed[n];
            if (value instanceof Integer) {
                boxed[n] = ((Integer)unboxed[n]).intValue();
                continue;
            }
            if (!(value instanceof Long)) continue;
            boxed[n] = (Long)unboxed[n];
        }
        return boxed;
    }

    public static double[] unboxDouble(Object[] unboxed, int length) {
        CompilerAsserts.neverPartOfCompilation();
        double[] boxed = new double[length];
        for (int n = 0; n < length; ++n) {
            boxed[n] = (Double)unboxed[n];
        }
        return boxed;
    }

    public static void copy(Object source, Object[] destination, int destinationStart, int length) {
        RubyNode.notDesignedForCompilation();
        if (length == 0) {
            return;
        }
        if (source instanceof int[]) {
            int[] unboxedSource = (int[])source;
            for (int n = 0; n < length; ++n) {
                destination[destinationStart + n] = unboxedSource[n];
            }
        } else if (source instanceof long[]) {
            long[] unboxedSource = (long[])source;
            for (int n = 0; n < length; ++n) {
                destination[destinationStart + n] = unboxedSource[n];
            }
        } else if (source instanceof double[]) {
            double[] unboxedSource = (double[])source;
            for (int n = 0; n < length; ++n) {
                destination[destinationStart + n] = unboxedSource[n];
            }
        } else if (source instanceof Object[]) {
            RubyArguments.arraycopy((Object[])source, 0, destination, destinationStart, length);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static long[] longCopyOf(int[] ints) {
        long[] longs = new long[ints.length];
        for (int n = 0; n < ints.length; ++n) {
            longs[n] = ints[n];
        }
        return longs;
    }

    public static int capacity(int current, int needed) {
        int capacity;
        if (needed < 16) {
            return 16;
        }
        for (capacity = current; capacity < needed; capacity *= 2) {
        }
        return capacity;
    }
}

