/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.util.Arrays;
import org.jruby.RubyFile;
import org.jruby.RubyString;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;

public class FeatureManager {
    private final RubyContext context;
    private Source mainScriptSource = null;
    private String mainScriptFullPath = null;

    public FeatureManager(RubyContext context) {
        this.context = context;
    }

    public boolean require(String feature, Node currentNode) throws IOException {
        RubyConstant dataConstantBefore = ModuleOperations.lookupConstant(this.context, LexicalScope.NONE, this.context.getCoreLibrary().getObjectClass(), "DATA");
        try {
            if (this.isAbsolutePath(feature)) {
                if (this.requireInPath(null, feature, currentNode)) {
                    boolean bl = true;
                    return bl;
                }
            } else {
                if (feature.equals("zlib")) {
                    this.context.getWarnings().warn("zlib not yet implemented");
                    boolean bl = true;
                    return bl;
                }
                if (feature.equals("rbconfig")) {
                    boolean bl = true;
                    return bl;
                }
                for (Object pathObject : this.context.getCoreLibrary().getLoadPath().slowToArray()) {
                    String loadPath = pathObject.toString();
                    if (!this.isAbsolutePath(loadPath)) {
                        loadPath = FeatureManager.expandPath(this.context, loadPath);
                    }
                    if (!this.requireInPath(loadPath, feature, currentNode)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            throw new RaiseException(this.context.getCoreLibrary().loadErrorCannotLoad(feature, currentNode));
        }
        finally {
            if (dataConstantBefore == null) {
                this.context.getCoreLibrary().getObjectClass().removeConstant(currentNode, "DATA");
            } else {
                this.context.getCoreLibrary().getObjectClass().setConstant(currentNode, "DATA", dataConstantBefore.getValue());
            }
        }
    }

    private boolean requireInPath(String path, String feature, Node currentNode) throws IOException {
        String fullPath = new File(path, feature).getPath();
        if (this.requireFile(fullPath, currentNode)) {
            return true;
        }
        return this.requireFile(fullPath + ".rb", currentNode);
    }

    public boolean isAbsolutePath(String path) {
        return path.startsWith("uri:classloader:") || path.startsWith("core:") || new File(path).isAbsolute();
    }

    private boolean requireFile(String path, Node currentNode) throws IOException {
        if ((path = path.replace('\\', '/')).startsWith("uri:classloader:/")) {
            for (Object loaded : Arrays.asList(this.context.getCoreLibrary().getLoadedFeatures().slowToArray())) {
                if (!loaded.toString().equals(path)) continue;
                return true;
            }
            String coreFileName = path.substring("uri:classloader:/".length());
            coreFileName = FileSystems.getDefault().getPath(coreFileName, new String[0]).normalize().toString();
            if (this.context.getRuntime().getLoadService().getClassPathResource((ClassLoader)this.context.getRuntime().getJRubyClassLoader(), coreFileName) == null) {
                return false;
            }
            this.context.getCoreLibrary().loadRubyCore(coreFileName, "uri:classloader:/");
            this.context.getCoreLibrary().getLoadedFeatures().slowPush(this.context.makeString(path));
            return true;
        }
        if (path.startsWith("core:/")) {
            for (Object loaded : Arrays.asList(this.context.getCoreLibrary().getLoadedFeatures().slowToArray())) {
                if (!loaded.toString().equals(path)) continue;
                return true;
            }
            String coreFileName = path.substring("core:/".length());
            if (this.context.getRuntime().getLoadService().getClassPathResource((ClassLoader)this.context.getRuntime().getJRubyClassLoader(), coreFileName) == null) {
                return false;
            }
            this.context.getCoreLibrary().loadRubyCore(coreFileName, "core:/");
            this.context.getCoreLibrary().getLoadedFeatures().slowPush(this.context.makeString(path));
            return true;
        }
        File file = new File(path);
        assert (file.isAbsolute());
        if (!file.isAbsolute() || !file.isFile()) {
            return false;
        }
        String expandedPath = FeatureManager.expandPath(this.context, path);
        for (Object loaded : Arrays.asList(this.context.getCoreLibrary().getLoadedFeatures().slowToArray())) {
            if (!loaded.toString().equals(expandedPath)) continue;
            return true;
        }
        this.context.getCoreLibrary().getLoadedFeatures().slowPush(this.context.makeString(expandedPath));
        this.context.loadFile(path, currentNode);
        return true;
    }

    public void setMainScriptSource(Source source) {
        this.mainScriptSource = source;
        if (!source.getPath().equals("-e")) {
            this.mainScriptFullPath = FeatureManager.expandPath(this.context, source.getPath());
        }
    }

    public static String expandPath(RubyContext context, String fileName) {
        RubyNode.notDesignedForCompilation();
        if (context.isRunningOnWindows()) {
            RubyString path = context.toJRuby(context.makeString(fileName));
            RubyString expanded = (RubyString)RubyFile.expand_path19((ThreadContext)context.getRuntime().getCurrentContext(), null, (IRubyObject[])new IRubyObject[]{path});
            return expanded.asJavaString();
        }
        return FeatureManager.expandPath(fileName, null);
    }

    public static String expandPath(String fileName, String dir) {
        RubyNode.notDesignedForCompilation();
        return RubyFile.canonicalize((String)new File(dir, fileName).getAbsolutePath());
    }

    public String getSourcePath(Source source) {
        if (source == this.mainScriptSource) {
            return this.mainScriptFullPath;
        }
        return source.getPath();
    }
}

