/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.methods.SymbolProcNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.methods.Arity;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.util.ByteList;
import org.jruby.util.CodeRangeable;
import org.jruby.util.StringSupport;

public class RubySymbol
extends RubyBasicObject
implements CodeRangeable {
    private final String symbol;
    private final ByteList bytes;
    private int codeRange = 0;

    private RubySymbol(RubyClass symbolClass, String symbol, ByteList bytes) {
        super(symbolClass);
        this.symbol = symbol;
        this.bytes = bytes;
    }

    public static RubySymbol newSymbol(RubyContext runtime, String name) {
        return runtime.getSymbolTable().getSymbol(name, (Encoding)ASCIIEncoding.INSTANCE);
    }

    public RubyProc toProc(SourceSection sourceSection, Node currentNode) {
        RubyNode.notDesignedForCompilation();
        RubyContext context = this.getContext();
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, null, Arity.NO_ARGUMENTS, this.symbol, true, null, false);
        RubyRootNode rootNode = new RubyRootNode(context, sourceSection, new FrameDescriptor(), sharedMethodInfo, new SymbolProcNode(context, sourceSection, this.symbol));
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)rootNode);
        return new RubyProc(context.getCoreLibrary().getProcClass(), RubyProc.Type.PROC, sharedMethodInfo, (CallTarget)callTarget, (CallTarget)callTarget, (CallTarget)callTarget, null, null, this.getContext().getCoreLibrary().getNilObject(), null);
    }

    public ByteList getSymbolBytes() {
        return this.bytes;
    }

    public org.jruby.RubySymbol getJRubySymbol() {
        RubyNode.notDesignedForCompilation();
        return this.getContext().getRuntime().newSymbol(this.bytes);
    }

    public String toString() {
        return this.symbol;
    }

    public RubyString toRubyString() {
        return this.getContext().makeString(this.toString());
    }

    public int getCodeRange() {
        return this.codeRange;
    }

    @CompilerDirectives.TruffleBoundary
    public int scanForCodeRange() {
        int cr = this.getCodeRange();
        if (cr == 0) {
            cr = this.slowCodeRangeScan();
            this.setCodeRange(cr);
        }
        return cr;
    }

    public boolean isCodeRangeValid() {
        return this.codeRange == 32;
    }

    public final void setCodeRange(int codeRange) {
        this.codeRange = codeRange;
    }

    public final void clearCodeRange() {
        this.codeRange = 0;
    }

    public final void keepCodeRange() {
        if (this.getCodeRange() == 48) {
            this.clearCodeRange();
        }
    }

    public final void modify() {
        throw new UnsupportedOperationException();
    }

    public final void modify(int length) {
        throw new UnsupportedOperationException();
    }

    public final void modifyAndKeepCodeRange() {
        this.modify();
        this.keepCodeRange();
    }

    public Encoding checkEncoding(CodeRangeable other) {
        return this.bytes.getEncoding();
    }

    public ByteList getByteList() {
        return this.bytes;
    }

    @CompilerDirectives.TruffleBoundary
    private int slowCodeRangeScan() {
        return StringSupport.codeRangeScan((Encoding)this.bytes.getEncoding(), (ByteList)this.bytes);
    }

    @Override
    public boolean hasNoSingleton() {
        return true;
    }

    public static final class SymbolTable {
        private final ConcurrentHashMap<ByteList, RubySymbol> symbolsTable = new ConcurrentHashMap();
        private final RubyContext context;

        public SymbolTable(RubyContext context) {
            this.context = context;
        }

        @CompilerDirectives.TruffleBoundary
        public RubySymbol getSymbol(String name) {
            return this.getSymbol(name, (Encoding)ASCIIEncoding.INSTANCE);
        }

        @CompilerDirectives.TruffleBoundary
        public RubySymbol getSymbol(String name, Encoding encoding) {
            ByteList byteList = org.jruby.RubySymbol.symbolBytesFromString((Ruby)this.context.getRuntime(), (String)name);
            byteList.setEncoding(encoding);
            RubySymbol symbol = this.symbolsTable.get(byteList);
            if (symbol == null) {
                symbol = this.createSymbol(name, byteList);
            }
            return symbol;
        }

        @CompilerDirectives.TruffleBoundary
        public RubySymbol getSymbol(ByteList byteList) {
            RubySymbol symbol = this.symbolsTable.get(byteList);
            if (symbol == null) {
                symbol = this.createSymbol(byteList.toString(), byteList);
            }
            return symbol;
        }

        private RubySymbol createSymbol(String name, ByteList byteList) {
            RubySymbol symbol = new RubySymbol(this.context.getCoreLibrary().getSymbolClass(), name, byteList);
            RubySymbol existingSymbol = this.symbolsTable.putIfAbsent(byteList, symbol);
            return existingSymbol == null ? symbol : existingSymbol;
        }

        @CompilerDirectives.TruffleBoundary
        public Collection<RubySymbol> allSymbols() {
            return this.symbolsTable.values();
        }
    }
}

