/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.subsystems.ObjectSpaceManager;

public abstract class RubyRange
extends RubyBasicObject {
    public RubyRange(RubyClass rangeClass) {
        super(rangeClass);
    }

    public abstract boolean doesExcludeEnd();

    public static class RangeAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return new ObjectRange(rubyClass, context.getCoreLibrary().getNilObject(), context.getCoreLibrary().getNilObject(), false);
        }
    }

    public static class ObjectRange
    extends RubyRange {
        private boolean excludeEnd;
        private Object begin;
        private Object end;

        public ObjectRange(RubyClass rangeClass, Object begin, Object end, boolean excludeEnd) {
            super(rangeClass);
            this.begin = begin;
            this.end = end;
            this.excludeEnd = excludeEnd;
        }

        public void initialize(Object begin, Object end, boolean excludeEnd) {
            this.begin = begin;
            this.end = end;
            this.excludeEnd = excludeEnd;
        }

        public Object getBegin() {
            return this.begin;
        }

        @Override
        public boolean doesExcludeEnd() {
            return this.excludeEnd;
        }

        public Object getEnd() {
            return this.end;
        }

        @Override
        public void visitObjectGraphChildren(ObjectSpaceManager.ObjectGraphVisitor visitor) {
            if (this.begin instanceof RubyBasicObject) {
                ((RubyBasicObject)this.begin).visitObjectGraph(visitor);
            }
            if (this.end instanceof RubyBasicObject) {
                ((RubyBasicObject)this.end).visitObjectGraph(visitor);
            }
        }
    }

    public static class LongFixnumRange
    extends RubyRange {
        private final boolean excludeEnd;
        private final long begin;
        private final long end;

        public LongFixnumRange(RubyClass rangeClass, long begin, long end, boolean excludeEnd) {
            super(rangeClass);
            this.begin = begin;
            this.end = end;
            this.excludeEnd = excludeEnd;
        }

        public final long getBegin() {
            return this.begin;
        }

        public final long getEnd() {
            return this.end;
        }

        @Override
        public boolean doesExcludeEnd() {
            return this.excludeEnd;
        }

        public final long getExclusiveEnd() {
            if (this.excludeEnd) {
                return this.end;
            }
            return this.end + 1L;
        }
    }

    public static class IntegerFixnumRange
    extends RubyRange {
        private final boolean excludeEnd;
        private final int begin;
        private final int end;

        public IntegerFixnumRange(RubyClass rangeClass, int begin, int end, boolean excludeEnd) {
            super(rangeClass);
            this.begin = begin;
            this.end = end;
            this.excludeEnd = excludeEnd;
        }

        public final int getBegin() {
            return this.begin;
        }

        public final int getEnd() {
            return this.end;
        }

        @Override
        public boolean doesExcludeEnd() {
            return this.excludeEnd;
        }

        public final int getExclusiveEnd() {
            if (this.excludeEnd) {
                return this.end;
            }
            return this.end + 1;
        }

        public int getLength() {
            return this.getExclusiveEnd() - this.begin;
        }
    }
}

