/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.runtime.subsystems.ObjectSpaceManager;

public class RubyProc
extends RubyBasicObject {
    private final Type type;
    @CompilerDirectives.CompilationFinal
    private SharedMethodInfo sharedMethodInfo;
    @CompilerDirectives.CompilationFinal
    private CallTarget callTargetForBlocks;
    @CompilerDirectives.CompilationFinal
    private CallTarget callTargetForProcs;
    @CompilerDirectives.CompilationFinal
    private CallTarget callTargetForMethods;
    @CompilerDirectives.CompilationFinal
    private MaterializedFrame declarationFrame;
    @CompilerDirectives.CompilationFinal
    private InternalMethod method;
    @CompilerDirectives.CompilationFinal
    private Object self;
    @CompilerDirectives.CompilationFinal
    private RubyProc block;

    public RubyProc(RubyClass procClass, Type type) {
        super(procClass);
        this.type = type;
    }

    public RubyProc(RubyClass procClass, Type type, SharedMethodInfo sharedMethodInfo, CallTarget callTargetForBlocks, CallTarget callTargetForProcs, CallTarget callTargetForMethods, MaterializedFrame declarationFrame, InternalMethod method, Object self, RubyProc block) {
        this(procClass, type);
        this.initialize(sharedMethodInfo, callTargetForBlocks, callTargetForProcs, callTargetForMethods, declarationFrame, method, self, block);
    }

    public void initialize(SharedMethodInfo sharedMethodInfo, CallTarget callTargetForBlocks, CallTarget callTargetForProcs, CallTarget callTargetForMethods, MaterializedFrame declarationFrame, InternalMethod method, Object self, RubyProc block) {
        this.sharedMethodInfo = sharedMethodInfo;
        this.callTargetForBlocks = callTargetForBlocks;
        this.callTargetForProcs = callTargetForProcs;
        this.callTargetForMethods = callTargetForMethods;
        this.declarationFrame = declarationFrame;
        this.method = method;
        this.self = self;
        this.block = block;
    }

    public CallTarget getCallTargetForType() {
        switch (this.type) {
            case BLOCK: {
                return this.callTargetForBlocks;
            }
            case PROC: {
                return this.callTargetForProcs;
            }
            case LAMBDA: {
                return this.callTargetForMethods;
            }
        }
        throw new UnsupportedOperationException(this.type.toString());
    }

    public Object rootCall(Object ... args) {
        RubyNode.notDesignedForCompilation();
        return this.getCallTargetForType().call(RubyArguments.pack(this.getMethod(), this.declarationFrame, this.self, this.block, args));
    }

    public Type getType() {
        return this.type;
    }

    public SharedMethodInfo getSharedMethodInfo() {
        return this.sharedMethodInfo;
    }

    public CallTarget getCallTargetForBlocks() {
        return this.callTargetForBlocks;
    }

    public CallTarget getCallTargetForProcs() {
        return this.callTargetForProcs;
    }

    public CallTarget getCallTargetForMethods() {
        return this.callTargetForMethods;
    }

    public MaterializedFrame getDeclarationFrame() {
        return this.declarationFrame;
    }

    public InternalMethod getMethod() {
        return this.method;
    }

    public Object getSelfCapturedInScope() {
        return this.self;
    }

    public RubyProc getBlockCapturedInScope() {
        return this.block;
    }

    @Override
    public void visitObjectGraphChildren(ObjectSpaceManager.ObjectGraphVisitor visitor) {
        this.getContext().getObjectSpaceManager().visitFrame((Frame)this.declarationFrame, visitor);
    }

    public static class ProcAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return new RubyProc(rubyClass, Type.PROC);
        }
    }

    public static enum Type {
        BLOCK,
        PROC,
        LAMBDA;

    }
}

