/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import java.util.Arrays;
import org.joni.Regex;
import org.joni.Region;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.subsystems.ObjectSpaceManager;
import org.jruby.truffle.runtime.util.ArrayUtils;
import org.jruby.util.ByteList;

public class RubyMatchData
extends RubyBasicObject {
    private final RubyString source;
    private final Regex regex;
    private final Region region;
    private final Object[] values;
    private final RubyString pre;
    private final RubyString post;
    private final RubyString global;

    public RubyMatchData(RubyClass rubyClass, RubyString source, Regex regex, Region region, Object[] values, RubyString pre, RubyString post, RubyString global) {
        super(rubyClass);
        this.source = source;
        this.regex = regex;
        this.region = region;
        this.values = values;
        this.pre = pre;
        this.post = post;
        this.global = global;
    }

    public Object[] valuesAt(int ... indices) {
        RubyNode.notDesignedForCompilation();
        Object[] result = new Object[indices.length];
        for (int n = 0; n < indices.length; ++n) {
            result[n] = this.values[indices[n]];
        }
        return result;
    }

    public Object[] getValues() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    public Object[] getCaptures() {
        return ArrayUtils.extractRange(this.values, 1, this.values.length);
    }

    public Object begin(int index) {
        if (this.region == null) {
            throw new UnsupportedOperationException("begin is not yet working when no grouping data is available");
        }
        int begin = this.region.beg[index];
        if (begin < 0) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
        return begin;
    }

    public Object end(int index) {
        if (this.region == null) {
            throw new UnsupportedOperationException("end is not yet working when no grouping data is available");
        }
        int end = this.region.end[index];
        if (end < 0) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
        return end;
    }

    public int getNumberOfRegions() {
        return this.region.numRegs;
    }

    public int getBackrefNumber(ByteList value) {
        return this.regex.nameToBackrefNumber(value.getUnsafeBytes(), value.getBegin(), value.getBegin() + value.getRealSize(), this.region);
    }

    @Override
    public void visitObjectGraphChildren(ObjectSpaceManager.ObjectGraphVisitor visitor) {
        for (Object object : this.values) {
            if (!(object instanceof RubyBasicObject)) continue;
            ((RubyBasicObject)object).visitObjectGraph(visitor);
        }
    }

    public RubyString getPre() {
        return this.pre;
    }

    public RubyString getPost() {
        return this.post;
    }

    public RubyString getGlobal() {
        return this.global;
    }

    public Region getRegion() {
        return this.region;
    }

    public RubyString getSource() {
        return this.source;
    }
}

