/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyString;

public class RubyException
extends RubyBasicObject {
    private RubyString message;
    private Backtrace backtrace;

    public RubyException(RubyClass rubyClass) {
        super(rubyClass);
        this.message = rubyClass.getContext().makeString("");
    }

    public RubyException(RubyClass rubyClass, RubyString message, Backtrace backtrace) {
        this(rubyClass);
        this.initialize(message);
        this.backtrace = backtrace;
    }

    public void initialize(RubyString message) {
        assert (message != null);
        this.message = message;
    }

    public RubyString getMessage() {
        return this.message;
    }

    public Backtrace getBacktrace() {
        return this.backtrace;
    }

    public void setBacktrace(Backtrace backtrace) {
        this.backtrace = backtrace;
    }

    public Object asRubyStringArray() {
        assert (this.backtrace != null);
        String[] lines = Backtrace.EXCEPTION_FORMATTER.format(this.getContext(), this, this.backtrace);
        Object[] array = new Object[lines.length];
        for (int n = 0; n < lines.length; ++n) {
            array[n] = this.getContext().makeString(lines[n]);
        }
        return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), array);
    }

    public static class ExceptionAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return new RubyException(rubyClass);
        }
    }
}

