/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyModule;

public class RubyClass
extends RubyModule {
    @CompilerDirectives.CompilationFinal
    Allocator allocator;
    private final boolean isSingleton;
    private final RubyModule attached;

    public static RubyClass createBootClass(RubyContext context, RubyClass classClass, String name, Allocator allocator) {
        return new RubyClass(context, classClass, null, null, name, false, null, allocator);
    }

    public RubyClass(RubyContext context, RubyModule lexicalParent, RubyClass superclass, String name, Allocator allocator) {
        this(context, superclass.getLogicalClass(), lexicalParent, superclass, name, false, null, allocator);
        this.ensureSingletonConsistency();
    }

    protected static RubyClass createSingletonClassOfObject(RubyContext context, RubyClass superclass, RubyModule attached, String name) {
        return new RubyClass(context, superclass.getLogicalClass(), null, superclass, name, true, attached, null).ensureSingletonConsistency();
    }

    private RubyClass(RubyContext context, RubyClass classClass, RubyModule lexicalParent, RubyClass superclass, String name, boolean isSingleton, RubyModule attached, Allocator allocator) {
        super(context, classClass, lexicalParent, name, null);
        assert (isSingleton || attached == null);
        this.allocator = allocator;
        this.isSingleton = isSingleton;
        this.attached = attached;
        if (superclass != null) {
            this.unsafeSetSuperclass(superclass);
        }
    }

    public void initialize(RubyClass superclass) {
        this.unsafeSetSuperclass(superclass);
        this.ensureSingletonConsistency();
        this.allocator = superclass.allocator;
    }

    protected void unsafeSetSuperclass(RubyClass superClass) {
        RubyNode.notDesignedForCompilation();
        assert (this.parentModule == null);
        this.parentModule = superClass;
        superClass.addDependent(this);
        this.newVersion();
    }

    public void initCopy(RubyClass from) {
        super.initCopy(from);
        this.allocator = from.allocator;
    }

    private RubyClass ensureSingletonConsistency() {
        this.createOneSingletonClass();
        return this;
    }

    @Override
    public RubyClass getSingletonClass(Node currentNode) {
        return this.createOneSingletonClass().ensureSingletonConsistency();
    }

    private RubyClass createOneSingletonClass() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.metaClass.isSingleton()) {
            return this.metaClass;
        }
        RubyClass singletonSuperclass = this.getSuperClass() == null ? this.getLogicalClass() : this.getSuperClass().createOneSingletonClass();
        this.metaClass = new RubyClass(this.getContext(), this.getLogicalClass(), null, singletonSuperclass, String.format("#<Class:%s>", this.getName()), true, this, null);
        return this.metaClass;
    }

    public RubyBasicObject allocate(Node currentNode) {
        return this.allocator.allocate(this.getContext(), this, currentNode);
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public RubyModule getAttached() {
        return this.attached;
    }

    public RubyClass getSuperClass() {
        CompilerAsserts.neverPartOfCompilation();
        for (RubyModule ancestor : this.parentAncestors()) {
            if (!(ancestor instanceof RubyClass)) continue;
            return (RubyClass)ancestor;
        }
        return null;
    }

    public Allocator getAllocator() {
        return this.allocator;
    }

    public static class ClassAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return new RubyClass(context, context.getCoreLibrary().getClassClass(), null, null, null, false, null, null);
        }
    }
}

