/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import java.util.Arrays;
import java.util.Random;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.ArrayAllocationSite;
import org.jruby.truffle.nodes.objects.Allocator;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.CoreLibrary;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.subsystems.ObjectSpaceManager;
import org.jruby.truffle.runtime.util.ArrayUtils;
import org.jruby.util.cli.Options;

public final class RubyArray
extends RubyBasicObject {
    public static final int ARRAYS_SMALL = (Integer)Options.TRUFFLE_ARRAYS_SMALL.load();
    private static final boolean RANDOMIZE_STORAGE_ARRAY = (Boolean)Options.TRUFFLE_RANDOMIZE_STORAGE_ARRAY.load();
    private static final Random random = new Random(((Integer)Options.TRUFFLE_RANDOMIZE_SEED.load()).intValue());
    private final ArrayAllocationSite allocationSite;
    private Object store;
    private int size;

    public RubyArray(RubyClass arrayClass) {
        this(arrayClass, null, 0);
    }

    public RubyArray(RubyClass arrayClass, Object store, int size) {
        this(arrayClass, null, store, size);
    }

    public RubyArray(RubyClass arrayClass, ArrayAllocationSite allocationSite, Object store, int size) {
        super(arrayClass);
        this.allocationSite = allocationSite;
        this.setStore(store, size);
    }

    public static RubyArray fromObject(RubyClass arrayClass, Object object) {
        RubyNode.notDesignedForCompilation();
        Object[] store = object instanceof Integer ? new int[]{(Integer)object} : (object instanceof Long ? (Object[])new long[]{(Long)object} : (object instanceof Double ? (Object[])new double[]{(Double)object} : (Object[])new Object[]{object}));
        return new RubyArray(arrayClass, store, 1);
    }

    public static RubyArray fromObjects(RubyClass arrayClass, Object ... objects) {
        return new RubyArray(arrayClass, RubyArray.storeFromObjects(objects), objects.length);
    }

    private static Object storeFromObjects(Object ... objects) {
        int n;
        Object[] store;
        RubyNode.notDesignedForCompilation();
        if (objects.length == 0) {
            return null;
        }
        boolean canUseInteger = true;
        boolean canUseLong = true;
        boolean canUseDouble = true;
        for (Object object : objects) {
            if (object instanceof Integer) {
                canUseDouble = false;
                continue;
            }
            if (object instanceof Long) {
                canUseInteger = canUseInteger && CoreLibrary.fitsIntoInteger((Long)object);
                canUseDouble = false;
                continue;
            }
            if (object instanceof Double) {
                canUseInteger = false;
                canUseLong = false;
                continue;
            }
            canUseInteger = false;
            canUseLong = false;
            canUseDouble = false;
        }
        if (canUseInteger) {
            store = new int[objects.length];
            for (n = 0; n < objects.length; ++n) {
                Object object = objects[n];
                if (object instanceof Integer) {
                    store[n] = (Integer)object;
                    continue;
                }
                if (object instanceof Long) {
                    store[n] = (int)((Long)object).longValue();
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            return store;
        }
        if (canUseLong) {
            store = new long[objects.length];
            for (n = 0; n < objects.length; ++n) {
                Object object = objects[n];
                if (object instanceof Integer) {
                    store[n] = (int)((long)((Integer)object).intValue());
                    continue;
                }
                if (object instanceof Long) {
                    store[n] = (int)((Long)object).longValue();
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            return store;
        }
        if (canUseDouble) {
            store = new double[objects.length];
            for (n = 0; n < objects.length; ++n) {
                store[n] = (int)CoreLibrary.toDouble(objects[n]);
            }
            return store;
        }
        return objects;
    }

    public Object[] slowToArray() {
        RubyNode.notDesignedForCompilation();
        return Arrays.copyOf(ArrayUtils.box(this.store), this.size);
    }

    public Object slowShift() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.size == 0) {
            return this.getContext().getCoreLibrary().getNilObject();
        }
        this.store = ArrayUtils.box(this.store);
        Object value = ((Object[])this.store)[0];
        System.arraycopy(this.store, 1, this.store, 0, this.size - 1);
        --this.size;
        return value;
    }

    public void slowUnshift(Object ... values) {
        RubyNode.notDesignedForCompilation();
        Object[] newStore = new Object[this.size + values.length];
        System.arraycopy(values, 0, newStore, 0, values.length);
        ArrayUtils.copy(this.store, newStore, values.length, this.size);
        this.setStore(newStore, newStore.length);
    }

    public void slowPush(Object value) {
        RubyNode.notDesignedForCompilation();
        this.store = Arrays.copyOf(ArrayUtils.box(this.store), this.size + 1);
        ((Object[])this.store)[this.size] = value;
        ++this.size;
    }

    public int normalizeIndex(int index) {
        return RubyArray.normalizeIndex(this.size, index);
    }

    public static int normalizeIndex(int length, int index) {
        if (CompilerDirectives.injectBranchProbability((double)0.25, (index < 0 ? 1 : 0) != 0)) {
            return length + index;
        }
        return index;
    }

    public int clampExclusiveIndex(int index) {
        return RubyArray.clampExclusiveIndex(this.size, index);
    }

    public static int clampExclusiveIndex(int length, int index) {
        if (index < 0) {
            return 0;
        }
        if (index > length) {
            return length;
        }
        return index;
    }

    public Object getStore() {
        return this.store;
    }

    public void setStore(Object store, int size) {
        assert (this.verifyStore(store, size));
        if (RANDOMIZE_STORAGE_ARRAY) {
            store = RubyArray.randomizeStorageStrategy(store, size);
            assert (this.verifyStore(store, size));
        }
        this.store = store;
        this.size = size;
    }

    @CompilerDirectives.TruffleBoundary
    private static Object randomizeStorageStrategy(Object store, int size) {
        if (size == 0) {
            switch (random.nextInt(5)) {
                case 0: {
                    return null;
                }
                case 1: {
                    return new int[0];
                }
                case 2: {
                    return new long[0];
                }
                case 3: {
                    return new double[0];
                }
                case 4: {
                    return new Object[0];
                }
            }
            throw new IllegalStateException();
        }
        Object[] boxedStore = ArrayUtils.box(store);
        Object canonicalStore = RubyArray.storeFromObjects(boxedStore);
        if (canonicalStore instanceof int[]) {
            switch (random.nextInt(3)) {
                case 0: {
                    return boxedStore;
                }
                case 1: {
                    return ArrayUtils.longCopyOf((int[])canonicalStore);
                }
                case 2: {
                    return canonicalStore;
                }
            }
            throw new IllegalStateException();
        }
        if (canonicalStore instanceof long[]) {
            if (random.nextBoolean()) {
                return boxedStore;
            }
            return canonicalStore;
        }
        if (canonicalStore instanceof double[]) {
            if (random.nextBoolean()) {
                return boxedStore;
            }
            return canonicalStore;
        }
        if (canonicalStore instanceof Object[]) {
            return canonicalStore;
        }
        throw new UnsupportedOperationException();
    }

    public int getSize() {
        return this.size;
    }

    private boolean verifyStore(Object store, int size) {
        assert (size >= 0);
        assert (store == null || store instanceof Object[] || store instanceof int[] || store instanceof long[] || store instanceof double[]);
        assert (!(store instanceof Object[]) || size <= ((Object[])store).length);
        assert (!(store instanceof int[]) || size <= ((int[])store).length);
        assert (!(store instanceof long[]) || size <= ((long[])store).length);
        assert (!(store instanceof double[]) || size <= ((double[])store).length);
        if (store instanceof Object[]) {
            for (int n = 0; n < size; ++n) {
                assert (((Object[])store)[n] != null) : String.format("array of size %s had null at %d", size, n);
            }
        }
        return true;
    }

    public ArrayAllocationSite getAllocationSite() {
        return this.allocationSite;
    }

    @Override
    public void visitObjectGraphChildren(ObjectSpaceManager.ObjectGraphVisitor visitor) {
        for (Object object : this.slowToArray()) {
            if (!(object instanceof RubyBasicObject)) continue;
            ((RubyBasicObject)object).visitObjectGraph(visitor);
        }
    }

    public static class ArrayAllocator
    implements Allocator {
        @Override
        public RubyBasicObject allocate(RubyContext context, RubyClass rubyClass, Node currentNode) {
            return new RubyArray(rubyClass);
        }
    }
}

