/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerOptions;
import com.oracle.truffle.api.ExecutionContext;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.BytesDecoder;
import com.oracle.truffle.api.source.Source;
import java.io.File;
import java.math.BigInteger;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import jnr.posix.POSIXHandler;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyNil;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.TruffleHooks;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.methods.SetMethodDeclarationContext;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveManager;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyOperations;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.CoreLibrary;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.subsystems.AtExitManager;
import org.jruby.truffle.runtime.subsystems.FeatureManager;
import org.jruby.truffle.runtime.subsystems.InstrumentationServerManager;
import org.jruby.truffle.runtime.subsystems.ObjectSpaceManager;
import org.jruby.truffle.runtime.subsystems.RubiniusConfiguration;
import org.jruby.truffle.runtime.subsystems.SafepointManager;
import org.jruby.truffle.runtime.subsystems.ThreadManager;
import org.jruby.truffle.runtime.subsystems.TraceManager;
import org.jruby.truffle.runtime.subsystems.TrufflePOSIXHandler;
import org.jruby.truffle.runtime.subsystems.Warnings;
import org.jruby.truffle.runtime.util.FileUtils;
import org.jruby.truffle.translator.NodeWrapper;
import org.jruby.truffle.translator.TranslatorDriver;
import org.jruby.util.ByteList;
import org.jruby.util.cli.Options;

public class RubyContext
extends ExecutionContext {
    private final Ruby runtime;
    private final POSIX posix;
    private final TranslatorDriver translator;
    private final CoreLibrary coreLibrary;
    private final FeatureManager featureManager;
    private final TraceManager traceManager;
    private final ObjectSpaceManager objectSpaceManager;
    private final ThreadManager threadManager;
    private final AtExitManager atExitManager;
    private final RubySymbol.SymbolTable symbolTable = new RubySymbol.SymbolTable(this);
    private final Shape emptyShape;
    private final Warnings warnings;
    private final SafepointManager safepointManager;
    private final Random random = new Random();
    private final LexicalScope rootLexicalScope;
    private final CompilerOptions compilerOptions;
    private final RubiniusPrimitiveManager rubiniusPrimitiveManager;
    private final InstrumentationServerManager instrumentationServerManager;
    private final RubiniusConfiguration rubiniusConfiguration;
    private final AtomicLong nextObjectID = new AtomicLong(6L);
    private final boolean runningOnWindows;

    public RubyContext(Ruby runtime) {
        assert (runtime != null);
        this.compilerOptions = Truffle.getRuntime().createCompilerOptions();
        if (this.compilerOptions.supportsOption("MinTimeThreshold")) {
            this.compilerOptions.setOption("MinTimeThreshold", (Object)100000000);
        }
        if (this.compilerOptions.supportsOption("MinInliningMaxCallerSize")) {
            this.compilerOptions.setOption("MinInliningMaxCallerSize", (Object)5000);
        }
        this.safepointManager = new SafepointManager(this);
        this.runtime = runtime;
        this.posix = POSIXFactory.getPOSIX((POSIXHandler)new TrufflePOSIXHandler(this), (boolean)true);
        this.warnings = new Warnings(this);
        this.objectSpaceManager = new ObjectSpaceManager(this);
        this.emptyShape = RubyBasicObject.LAYOUT.createShape((ObjectType)new RubyOperations(this));
        this.coreLibrary = new CoreLibrary(this);
        this.rootLexicalScope = new LexicalScope(null, this.coreLibrary.getObjectClass());
        this.coreLibrary.initialize();
        this.translator = new TranslatorDriver(this);
        this.featureManager = new FeatureManager(this);
        this.traceManager = new TraceManager();
        this.atExitManager = new AtExitManager();
        this.threadManager = new ThreadManager(this);
        this.threadManager.initialize();
        this.rubiniusPrimitiveManager = RubiniusPrimitiveManager.create();
        if ((Integer)Options.TRUFFLE_INSTRUMENTATION_SERVER_PORT.load() != 0) {
            this.instrumentationServerManager = new InstrumentationServerManager(this, (Integer)Options.TRUFFLE_INSTRUMENTATION_SERVER_PORT.load());
            this.instrumentationServerManager.start();
        } else {
            this.instrumentationServerManager = null;
        }
        this.runningOnWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).indexOf("win") >= 0;
        this.rubiniusConfiguration = new RubiniusConfiguration(this);
    }

    public Shape getEmptyShape() {
        return this.emptyShape;
    }

    public static String checkInstanceVariableName(RubyContext context, String name, Node currentNode) {
        RubyNode.notDesignedForCompilation();
        if (!name.startsWith("@")) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(context.getCoreLibrary().nameErrorInstanceNameNotAllowable(name, currentNode));
        }
        return name;
    }

    public static String checkClassVariableName(RubyContext context, String name, Node currentNode) {
        RubyNode.notDesignedForCompilation();
        if (!name.startsWith("@@")) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(context.getCoreLibrary().nameErrorInstanceNameNotAllowable(name, currentNode));
        }
        return name;
    }

    public boolean isRunningOnWindows() {
        return this.runningOnWindows;
    }

    public void loadFile(String fileName, Node currentNode) {
        if (new File(fileName).isAbsolute()) {
            this.loadFileAbsolute(fileName, currentNode);
        } else {
            this.loadFileAbsolute(this.getRuntime().getCurrentDirectory() + File.separator + fileName, currentNode);
        }
    }

    private void loadFileAbsolute(String path, Node currentNode) {
        byte[] bytes = FileUtils.readAllBytesInterruptedly(this, path);
        Source source = Source.fromBytes((byte[])bytes, (String)path, (BytesDecoder)new BytesDecoder.UTF8BytesDecoder());
        this.load(source, currentNode, NodeWrapper.IDENTITY);
    }

    public void load(Source source, Node currentNode, final NodeWrapper nodeWrapper) {
        final NodeWrapper loadWrapper = new NodeWrapper(){

            @Override
            public RubyNode wrap(RubyNode node) {
                return new SetMethodDeclarationContext(node.getContext(), node.getSourceSection(), Visibility.PRIVATE, "load", node);
            }
        };
        NodeWrapper composed = new NodeWrapper(){

            @Override
            public RubyNode wrap(RubyNode node) {
                return nodeWrapper.wrap(loadWrapper.wrap(node));
            }
        };
        this.execute(source, (Encoding)UTF8Encoding.INSTANCE, TranslatorDriver.ParserContext.TOP_LEVEL, this.coreLibrary.getMainObject(), null, currentNode, composed);
    }

    public RubySymbol.SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @CompilerDirectives.TruffleBoundary
    public org.jruby.truffle.runtime.core.RubySymbol getSymbol(String name) {
        return this.symbolTable.getSymbol(name, (Encoding)ASCIIEncoding.INSTANCE);
    }

    @CompilerDirectives.TruffleBoundary
    public org.jruby.truffle.runtime.core.RubySymbol getSymbol(String name, Encoding encoding) {
        return this.symbolTable.getSymbol(name, encoding);
    }

    @CompilerDirectives.TruffleBoundary
    public org.jruby.truffle.runtime.core.RubySymbol getSymbol(ByteList name) {
        return this.symbolTable.getSymbol(name);
    }

    @CompilerDirectives.TruffleBoundary
    public Object instanceEval(ByteList code, Object self, String filename, Node currentNode) {
        Source source = Source.fromText((CharSequence)code, (String)filename);
        return this.execute(source, code.getEncoding(), TranslatorDriver.ParserContext.EVAL, self, null, currentNode, new NodeWrapper(){

            @Override
            public RubyNode wrap(RubyNode node) {
                return new SetMethodDeclarationContext(node.getContext(), node.getSourceSection(), Visibility.PUBLIC, "instance_eval", node);
            }
        });
    }

    public Object instanceEval(ByteList code, Object self, Node currentNode) {
        return this.instanceEval(code, self, "(eval)", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public Object eval(String code, RubyBinding binding, boolean ownScopeForAssignments, String filename, Node currentNode) {
        return this.eval(ByteList.create((CharSequence)code), binding, ownScopeForAssignments, filename, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public Object eval(ByteList code, RubyBinding binding, boolean ownScopeForAssignments, String filename, Node currentNode) {
        Source source = Source.fromText((CharSequence)code, (String)filename);
        return this.execute(source, code.getEncoding(), TranslatorDriver.ParserContext.EVAL, binding.getSelf(), binding.getFrame(), ownScopeForAssignments, currentNode, NodeWrapper.IDENTITY);
    }

    @CompilerDirectives.TruffleBoundary
    public Object eval(ByteList code, RubyBinding binding, boolean ownScopeForAssignments, Node currentNode) {
        return this.eval(code, binding, ownScopeForAssignments, "(eval)", currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public Object execute(Source source, Encoding defaultEncoding, TranslatorDriver.ParserContext parserContext, Object self, MaterializedFrame parentFrame, Node currentNode, NodeWrapper wrapper) {
        return this.execute(source, defaultEncoding, parserContext, self, parentFrame, true, currentNode, wrapper);
    }

    @CompilerDirectives.TruffleBoundary
    public Object execute(Source source, Encoding defaultEncoding, TranslatorDriver.ParserContext parserContext, Object self, MaterializedFrame parentFrame, boolean ownScopeForAssignments, Node currentNode, NodeWrapper wrapper) {
        RubyRootNode rootNode = this.translator.parse(this, source, defaultEncoding, parserContext, parentFrame, ownScopeForAssignments, currentNode, wrapper);
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)rootNode);
        InternalMethod method = new InternalMethod(rootNode.getSharedMethodInfo(), rootNode.getSharedMethodInfo().getName(), this.getCoreLibrary().getObjectClass(), Visibility.PUBLIC, false, (CallTarget)callTarget, parentFrame);
        return callTarget.call(RubyArguments.pack(method, parentFrame, self, null, new Object[0]));
    }

    public long getNextObjectID() {
        long id = this.nextObjectID.getAndAdd(2L);
        if (id < 0L) {
            this.nextObjectID.set(Long.MIN_VALUE);
            throw new RuntimeException("Object IDs exhausted");
        }
        return id;
    }

    public void shutdown() {
        this.atExitManager.run();
        if (this.instrumentationServerManager != null) {
            this.instrumentationServerManager.shutdown();
        }
        this.threadManager.shutdown();
    }

    public org.jruby.truffle.runtime.core.RubyString makeString(String string) {
        return this.makeString(this.coreLibrary.getStringClass(), string);
    }

    public org.jruby.truffle.runtime.core.RubyString makeString(RubyClass stringClass, String string) {
        return org.jruby.truffle.runtime.core.RubyString.fromJavaString(stringClass, string);
    }

    public org.jruby.truffle.runtime.core.RubyString makeString(String string, Encoding encoding) {
        return this.makeString(this.coreLibrary.getStringClass(), string, encoding);
    }

    public org.jruby.truffle.runtime.core.RubyString makeString(RubyClass stringClass, String string, Encoding encoding) {
        return org.jruby.truffle.runtime.core.RubyString.fromJavaString(stringClass, string, encoding);
    }

    public org.jruby.truffle.runtime.core.RubyString makeString(char string) {
        return this.makeString(Character.toString(string));
    }

    public org.jruby.truffle.runtime.core.RubyString makeString(char string, Encoding encoding) {
        return this.makeString(Character.toString(string), encoding);
    }

    public org.jruby.truffle.runtime.core.RubyString makeString(RubyClass stringClass, char string, Encoding encoding) {
        return this.makeString(stringClass, Character.toString(string), encoding);
    }

    public org.jruby.truffle.runtime.core.RubyString makeString(byte[] bytes) {
        return this.makeString(new ByteList(bytes));
    }

    public org.jruby.truffle.runtime.core.RubyString makeString(ByteList bytes) {
        return this.makeString(this.coreLibrary.getStringClass(), bytes);
    }

    public org.jruby.truffle.runtime.core.RubyString makeString(RubyClass stringClass, ByteList bytes) {
        return org.jruby.truffle.runtime.core.RubyString.fromByteList(stringClass, bytes);
    }

    public Object makeTuple(VirtualFrame frame, CallDispatchHeadNode newTupleNode, Object ... values) {
        return newTupleNode.call(frame, this.getCoreLibrary().getTupleClass(), "create", null, values);
    }

    public IRubyObject toJRuby(Object object) {
        RubyNode.notDesignedForCompilation();
        if (object instanceof RubyNilClass) {
            return this.runtime.getNil();
        }
        if (object == this.getCoreLibrary().getKernelModule()) {
            return this.runtime.getKernel();
        }
        if (object == this.getCoreLibrary().getMainObject()) {
            return this.runtime.getTopSelf();
        }
        if (object instanceof Boolean) {
            return this.runtime.newBoolean(((Boolean)object).booleanValue());
        }
        if (object instanceof Integer) {
            return this.runtime.newFixnum(((Integer)object).intValue());
        }
        if (object instanceof Long) {
            return this.runtime.newFixnum(((Long)object).longValue());
        }
        if (object instanceof Double) {
            return this.runtime.newFloat(((Double)object).doubleValue());
        }
        if (object instanceof org.jruby.truffle.runtime.core.RubyString) {
            return this.toJRuby((org.jruby.truffle.runtime.core.RubyString)object);
        }
        if (object instanceof org.jruby.truffle.runtime.core.RubyArray) {
            return this.toJRuby((org.jruby.truffle.runtime.core.RubyArray)object);
        }
        if (object instanceof RubyEncoding) {
            return this.toJRuby((RubyEncoding)object);
        }
        throw this.getRuntime().newRuntimeError("cannot pass " + object + " (" + object.getClass().getName() + ") to JRuby");
    }

    public RubyArray toJRuby(org.jruby.truffle.runtime.core.RubyArray array) {
        RubyNode.notDesignedForCompilation();
        Object[] objects = array.slowToArray();
        IRubyObject[] store = new IRubyObject[objects.length];
        for (int n = 0; n < objects.length; ++n) {
            store[n] = this.toJRuby(objects[n]);
        }
        return this.runtime.newArray(store);
    }

    public IRubyObject toJRuby(RubyEncoding encoding) {
        return this.runtime.getEncodingService().rubyEncodingFromObject((IRubyObject)this.runtime.newString(encoding.getName()));
    }

    public RubyString toJRuby(org.jruby.truffle.runtime.core.RubyString string) {
        RubyString jrubyString = this.runtime.newString(string.getBytes().dup());
        Object tainted = string.getOperations().getInstanceVariable(string, RubyBasicObject.TAINTED_IDENTIFIER);
        if (tainted instanceof Boolean && ((Boolean)tainted).booleanValue()) {
            jrubyString.setTaint(true);
        }
        return jrubyString;
    }

    public Object toTruffle(IRubyObject object) {
        RubyNode.notDesignedForCompilation();
        if (object == this.runtime.getTopSelf()) {
            return this.getCoreLibrary().getMainObject();
        }
        if (object == this.runtime.getKernel()) {
            return this.getCoreLibrary().getKernelModule();
        }
        if (object instanceof RubyNil) {
            return this.getCoreLibrary().getNilObject();
        }
        if (object instanceof RubyBoolean.True) {
            return true;
        }
        if (object instanceof RubyBoolean.False) {
            return false;
        }
        if (object instanceof RubyFixnum) {
            long value = ((RubyFixnum)object).getLongValue();
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                return value;
            }
            return (int)value;
        }
        if (object instanceof RubyFloat) {
            return ((RubyFloat)object).getDoubleValue();
        }
        if (object instanceof RubyBignum) {
            BigInteger value = ((RubyBignum)object).getBigIntegerValue();
            return new org.jruby.truffle.runtime.core.RubyBignum(this.coreLibrary.getBignumClass(), value);
        }
        if (object instanceof RubyString) {
            return this.toTruffle((RubyString)object);
        }
        if (object instanceof RubySymbol) {
            return this.getSymbolTable().getSymbol(object.toString());
        }
        if (object instanceof RubyArray) {
            RubyArray jrubyArray = (RubyArray)object;
            Object[] truffleArray = new Object[jrubyArray.size()];
            for (int n = 0; n < truffleArray.length; ++n) {
                truffleArray[n] = this.toTruffle((IRubyObject)jrubyArray.get(n));
            }
            return new org.jruby.truffle.runtime.core.RubyArray(this.coreLibrary.getArrayClass(), truffleArray, truffleArray.length);
        }
        if (object instanceof RubyException) {
            return this.toTruffle((RubyException)object, null);
        }
        throw object.getRuntime().newRuntimeError("cannot pass " + object.inspect() + " (" + object.getClass().getName() + ") to Truffle");
    }

    public org.jruby.truffle.runtime.core.RubyString toTruffle(RubyString jrubyString) {
        org.jruby.truffle.runtime.core.RubyString truffleString = new org.jruby.truffle.runtime.core.RubyString(this.getCoreLibrary().getStringClass(), jrubyString.getByteList().dup());
        if (jrubyString.isTaint()) {
            truffleString.getOperations().setInstanceVariable(truffleString, RubyBasicObject.TAINTED_IDENTIFIER, true);
        }
        return truffleString;
    }

    public org.jruby.truffle.runtime.core.RubyException toTruffle(RubyException jrubyException, RubyNode currentNode) {
        switch (jrubyException.getMetaClass().getName()) {
            case "ArgumentError": {
                return this.getCoreLibrary().argumentError(jrubyException.getMessage().toString(), currentNode);
            }
            case "Encoding::CompatibilityError": {
                return this.getCoreLibrary().encodingCompatibilityError(jrubyException.getMessage().toString(), currentNode);
            }
            case "TypeError": {
                return this.getCoreLibrary().typeError(jrubyException.getMessage().toString(), currentNode);
            }
        }
        throw new UnsupportedOperationException("Don't know how to translate " + jrubyException.getMetaClass().getName());
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public CoreLibrary getCoreLibrary() {
        return this.coreLibrary;
    }

    public FeatureManager getFeatureManager() {
        return this.featureManager;
    }

    public ObjectSpaceManager getObjectSpaceManager() {
        return this.objectSpaceManager;
    }

    public ThreadManager getThreadManager() {
        return this.threadManager;
    }

    public TranslatorDriver getTranslator() {
        return this.translator;
    }

    public AtExitManager getAtExitManager() {
        return this.atExitManager;
    }

    public String getLanguageShortName() {
        return "ruby";
    }

    public TruffleHooks getHooks() {
        return (TruffleHooks)this.runtime.getInstanceConfig().getTruffleHooks();
    }

    public TraceManager getTraceManager() {
        return this.traceManager;
    }

    public Warnings getWarnings() {
        return this.warnings;
    }

    public SafepointManager getSafepointManager() {
        return this.safepointManager;
    }

    public Random getRandom() {
        return this.random;
    }

    public LexicalScope getRootLexicalScope() {
        return this.rootLexicalScope;
    }

    public CompilerOptions getCompilerOptions() {
        return this.compilerOptions;
    }

    public RubiniusPrimitiveManager getRubiniusPrimitiveManager() {
        return this.rubiniusPrimitiveManager;
    }

    public RubiniusConfiguration getRubiniusConfiguration() {
        return this.rubiniusConfiguration;
    }

    public POSIX getPosix() {
        return this.posix;
    }
}

