/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.ArrayList;
import org.jruby.truffle.nodes.CoreSourceSection;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.backtrace.Activation;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.util.cli.Options;

public abstract class RubyCallStack {
    private static final boolean BACKTRACE_GENERATE = (Boolean)Options.TRUFFLE_BACKTRACE_GENERATE.load();

    public static InternalMethod getCallingMethod(VirtualFrame frame) {
        CompilerAsserts.neverPartOfCompilation();
        final InternalMethod currentMethod = RubyArguments.getMethod(frame.getArguments());
        return (InternalMethod)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<InternalMethod>(){

            public InternalMethod visitFrame(FrameInstance frameInstance) {
                InternalMethod method = RubyCallStack.getMethod(frameInstance);
                assert (method != null);
                if (method != currentMethod) {
                    return method;
                }
                return null;
            }
        });
    }

    public static InternalMethod getMethod(FrameInstance frame) {
        CompilerAsserts.neverPartOfCompilation();
        return RubyArguments.getMethod(frame.getFrame(FrameInstance.FrameAccess.READ_ONLY, true).getArguments());
    }

    public static Backtrace getBacktrace(Node currentNode) {
        return RubyCallStack.getBacktrace(currentNode, 0);
    }

    public static Backtrace getBacktrace(Node currentNode, final int omit) {
        CompilerAsserts.neverPartOfCompilation();
        final ArrayList<Activation> activations = new ArrayList<Activation>();
        if (BACKTRACE_GENERATE) {
            if (omit == 0 && currentNode != null && Truffle.getRuntime().getCurrentFrame() != null) {
                activations.add(new Activation(currentNode, Truffle.getRuntime().getCurrentFrame().getFrame(FrameInstance.FrameAccess.MATERIALIZE, true).materialize()));
            }
            Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<InternalMethod>(){
                int depth = 1;

                public InternalMethod visitFrame(FrameInstance frameInstance) {
                    if (frameInstance.getCallNode() != null && this.depth >= omit) {
                        activations.add(new Activation(frameInstance.getCallNode(), frameInstance.getFrame(FrameInstance.FrameAccess.MATERIALIZE, true).materialize()));
                    }
                    ++this.depth;
                    return null;
                }
            });
        }
        return new Backtrace(activations.toArray(new Activation[activations.size()]));
    }

    public static Node getTopMostUserCallNode() {
        CompilerAsserts.neverPartOfCompilation();
        return (Node)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<Node>(){

            public Node visitFrame(FrameInstance frameInstance) {
                if (frameInstance.getCallNode().getEncapsulatingSourceSection() instanceof CoreSourceSection) {
                    return null;
                }
                return frameInstance.getCallNode();
            }
        });
    }
}

