/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime;

import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import org.jruby.truffle.nodes.methods.MarkerNode;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.util.ArrayUtils;

public final class RubyArguments {
    public static final int METHOD_INDEX = 0;
    public static final int DECLARATION_FRAME_INDEX = 1;
    public static final int SELF_INDEX = 2;
    public static final int BLOCK_INDEX = 3;
    public static final int RUNTIME_ARGUMENT_COUNT = 4;

    public static Object[] pack(InternalMethod method, MaterializedFrame declarationFrame, Object self, RubyProc block, Object[] arguments) {
        Object[] packed = new Object[arguments.length + 4];
        packed[0] = method;
        packed[1] = declarationFrame;
        packed[2] = self;
        packed[3] = block;
        RubyArguments.arraycopy(arguments, 0, packed, 4, arguments.length);
        return packed;
    }

    public static Object getOptimizedKeywordArgument(Object[] arguments, int index) {
        return arguments[arguments.length - 1 + index];
    }

    public static boolean isKwOptimized(Object[] arguments) {
        return arguments[arguments.length - 1] instanceof MarkerNode.Marker;
    }

    public static InternalMethod getMethod(Object[] arguments) {
        return (InternalMethod)arguments[0];
    }

    public static Object getSelf(Object[] arguments) {
        return arguments[2];
    }

    public static RubyProc getBlock(Object[] arguments) {
        return (RubyProc)arguments[3];
    }

    public static Object[] extractUserArguments(Object[] arguments) {
        return ArrayUtils.extractRange(arguments, 4, arguments.length);
    }

    public static Object[] extractUserArgumentsWithUnshift(Object first, Object[] arguments) {
        Object[] range = ArrayUtils.extractRange(arguments, 3, arguments.length);
        range[0] = first;
        return range;
    }

    public static Object[] concatUserArguments(Object o, Object[] arguments) {
        Object[] concatenatedArguments;
        if (o instanceof Object[]) {
            Object[] concatArray = (Object[])o;
            concatenatedArguments = new Object[concatArray.length + arguments.length - 4];
            RubyArguments.arraycopy(concatArray, 0, concatenatedArguments, 0, concatArray.length);
            RubyArguments.arraycopy(arguments, 4, concatenatedArguments, concatArray.length, RubyArguments.getUserArgumentsCount(arguments));
        } else {
            concatenatedArguments = new Object[1 + arguments.length - 4];
            concatenatedArguments[0] = o;
            RubyArguments.arraycopy(arguments, 4, concatenatedArguments, 1, RubyArguments.getUserArgumentsCount(arguments));
        }
        return concatenatedArguments;
    }

    public static int getUserArgumentsCount(Object[] internalArguments) {
        return internalArguments.length - 4;
    }

    public static int getNamedUserArgumentsCount(Object[] internalArguments) {
        if (RubyArguments.isKwOptimized(internalArguments)) {
            return RubyArguments.getUserArgumentsCount(internalArguments) - RubyArguments.getMethod(internalArguments).getSharedMethodInfo().getArity().getKeywordArguments().size() - 1;
        }
        return RubyArguments.getUserArgumentsCount(internalArguments);
    }

    public static Object getUserArgument(Object[] internalArguments, int index) {
        return internalArguments[4 + index];
    }

    public static RubyHash getUserKeywordsHash(Object[] internalArguments, int minArgumentCount) {
        int argumentCount = RubyArguments.getUserArgumentsCount(internalArguments);
        if (argumentCount <= minArgumentCount) {
            return null;
        }
        Object lastArgument = RubyArguments.getUserArgument(internalArguments, argumentCount - 1);
        if (lastArgument instanceof RubyHash) {
            return (RubyHash)lastArgument;
        }
        return null;
    }

    public static MaterializedFrame getDeclarationFrame(Object[] arguments) {
        return (MaterializedFrame)arguments[1];
    }

    @ExplodeLoop
    public static void arraycopy(Object[] src, int srcPos, Object[] dest, int destPos, int length) {
        for (int i = 0; i < length; ++i) {
            dest[destPos + i] = src[srcPos + i];
        }
    }

    public static MaterializedFrame getDeclarationFrame(VirtualFrame frame, int level) {
        assert (level > 0);
        MaterializedFrame parentFrame = RubyArguments.getDeclarationFrame(frame.getArguments());
        return RubyArguments.getDeclarationFrame(parentFrame, level - 1);
    }

    @ExplodeLoop
    private static MaterializedFrame getDeclarationFrame(MaterializedFrame frame, int level) {
        assert (frame != null);
        assert (level >= 0);
        MaterializedFrame parentFrame = frame;
        for (int n = 0; n < level; ++n) {
            parentFrame = RubyArguments.getDeclarationFrame(parentFrame.getArguments());
        }
        return parentFrame;
    }
}

