/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.supercall;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import org.jruby.truffle.nodes.supercall.AbstractGeneralSuperCallNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;

public class GeneralSuperReCallNode
extends AbstractGeneralSuperCallNode {
    private final boolean inBlock;

    public GeneralSuperReCallNode(RubyContext context, SourceSection sourceSection, boolean inBlock) {
        super(context, sourceSection);
        this.inBlock = inBlock;
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        Object self = RubyArguments.getSelf(frame.getArguments());
        if (!this.guard(frame, self)) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.lookup(frame);
        }
        Object[] originalArguments = this.inBlock ? RubyArguments.getDeclarationFrame(frame.getArguments()).getArguments() : frame.getArguments();
        Object[] superArguments = Arrays.copyOf(originalArguments, originalArguments.length);
        superArguments[0] = this.superMethod;
        return this.callNode.call(frame, superArguments);
    }
}

