/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportGuards;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.util.ArrayList;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.exception.EncodingException;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyEncoding;
import org.jruby.RubyInteger;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.TaintResultNode;
import org.jruby.truffle.nodes.core.StringGuards;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.StringNodesFactory;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.nodes.rubinius.StringPrimitiveNodesFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.rubinius.RubiniusByteArray;
import org.jruby.util.ByteList;
import org.jruby.util.CodeRangeable;
import org.jruby.util.ConvertBytes;
import org.jruby.util.StringSupport;

public abstract class StringPrimitiveNodes {

    @RubiniusPrimitive(name="string_from_bytearray", needsSelf=false, lowerFixnumParameters={1, 2})
    public static abstract class StringFromByteArrayPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringFromByteArrayPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StringFromByteArrayPrimitiveNode(StringFromByteArrayPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString stringFromByteArray(RubiniusByteArray bytes, int start, int count) {
            return this.getContext().makeString(Arrays.copyOfRange(bytes.getBytes().unsafeBytes(), bytes.getBytes().begin() + start, bytes.getBytes().begin() + start + count));
        }
    }

    @RubiniusPrimitive(name="string_substring")
    @ImportGuards(value={StringGuards.class})
    public static abstract class StringSubstringPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private TaintResultNode taintResultNode;

        public StringSubstringPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StringSubstringPrimitiveNode(StringSubstringPrimitiveNode prev) {
            super(prev);
            this.taintResultNode = prev.taintResultNode;
        }

        public abstract Object execute(VirtualFrame var1, RubyString var2, int var3, int var4);

        @Specialization(guards={"isSingleByteOptimizable"})
        public Object stringSubstringSingleByteOptimizable(RubyString string, int beg, int len) {
            if (len < 0) {
                return this.nil();
            }
            int length = string.getByteList().getRealSize();
            if (length == 0) {
                len = 0;
            }
            if (beg > length) {
                return this.nil();
            }
            if (beg < 0 && (beg += length) < 0) {
                return this.nil();
            }
            if (beg + len > length) {
                len = length - beg;
            }
            if (len <= 0) {
                len = 0;
                beg = 0;
            }
            return this.makeSubstring(string, beg, len);
        }

        @Specialization(guards={"!isSingleByteOptimizable"})
        public Object stringSubstring(RubyString string, int beg, int len) {
            int p;
            if (len < 0) {
                return this.nil();
            }
            int length = string.getByteList().getRealSize();
            if (length == 0) {
                len = 0;
            }
            if (beg + len > length) {
                len = length - beg;
            }
            ByteList value = string.getByteList();
            Encoding enc = value.getEncoding();
            int s = value.getBegin();
            int end = s + length;
            byte[] bytes = value.getUnsafeBytes();
            if (beg < 0) {
                if (len > -beg) {
                    len = -beg;
                }
                if (-beg * enc.maxLength() < length >>> 3) {
                    beg = -beg;
                    int e = end;
                    while (beg-- > len && (e = enc.prevCharHead(bytes, s, e, e)) != -1) {
                    }
                    int p2 = e;
                    if (p2 == -1) {
                        return this.nil();
                    }
                    while (len-- > 0 && (p2 = enc.prevCharHead(bytes, s, p2, e)) != -1) {
                    }
                    if (p2 == -1) {
                        return this.nil();
                    }
                    return this.makeSubstring(string, p2 - s, e - p2);
                }
                if ((beg += StringSupport.strLengthFromRubyString((CodeRangeable)string, (Encoding)enc)) < 0) {
                    return this.nil();
                }
            } else if (beg > 0 && beg > StringSupport.strLengthFromRubyString((CodeRangeable)string, (Encoding)enc)) {
                return this.nil();
            }
            if (len == 0) {
                p = 0;
            } else if (string.isCodeRangeValid() && enc instanceof UTF8Encoding) {
                p = StringSupport.utf8Nth((byte[])bytes, (int)s, (int)end, (int)beg);
                len = StringSupport.utf8Offset((byte[])bytes, (int)p, (int)end, (int)len);
            } else if (enc.isFixedWidth()) {
                int w = enc.maxLength();
                p = s + beg * w;
                if (p > end) {
                    p = end;
                    len = 0;
                } else {
                    len = len * w > end - p ? end - p : (len *= w);
                }
            } else {
                p = StringSupport.nth((Encoding)enc, (byte[])bytes, (int)s, (int)end, (int)beg);
                len = p == end ? 0 : StringSupport.offset((Encoding)enc, (byte[])bytes, (int)p, (int)end, (int)len);
            }
            return this.makeSubstring(string, p - s, len);
        }

        private RubyString makeSubstring(RubyString string, int beg, int len) {
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintResultNode = (TaintResultNode)this.insert(new TaintResultNode(this.getContext(), this.getSourceSection()));
            }
            RubyString ret = this.getContext().makeString(string.getLogicalClass(), new ByteList(string.getByteList(), beg, len));
            ret.getByteList().setEncoding(string.getByteList().getEncoding());
            this.taintResultNode.maybeTaint(string, ret);
            return ret;
        }
    }

    @RubiniusPrimitive(name="string_byte_append")
    public static abstract class StringByteAppendPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringByteAppendPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StringByteAppendPrimitiveNode(StringByteAppendPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString stringByteAppend(RubyString string, RubyString other) {
            StringByteAppendPrimitiveNode.notDesignedForCompilation();
            string.getByteList().append(other.getByteList());
            return string;
        }
    }

    @RubiniusPrimitive(name="string_to_inum")
    public static abstract class StringToInumPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringToInumPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StringToInumPrimitiveNode(StringToInumPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public Object stringToInum(RubyString string, int fixBase, boolean strict) {
            StringToInumPrimitiveNode.notDesignedForCompilation();
            try {
                RubyInteger result = ConvertBytes.byteListToInum19((Ruby)this.getContext().getRuntime(), (ByteList)string.getBytes(), (int)fixBase, (boolean)strict);
                return this.getContext().toTruffle((IRubyObject)result);
            }
            catch (RaiseException e) {
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().toTruffle(e.getException(), this));
            }
        }
    }

    @RubiniusPrimitive(name="string_pattern")
    public static abstract class StringPatternPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringPatternPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StringPatternPrimitiveNode(StringPatternPrimitiveNode prev) {
            super(prev);
        }

        @Specialization(guards={"isZero(arguments[1]))"})
        public RubyString stringPatternZero(RubyClass stringClass, int size, int value) {
            return new RubyString(stringClass, new ByteList(new byte[size]));
        }

        @Specialization(guards={"!isZero(arguments[1]))"})
        public RubyString stringPattern(RubyClass stringClass, int size, int value) {
            byte[] bytes = new byte[size];
            Arrays.fill(bytes, (byte)value);
            return new RubyString(stringClass, new ByteList(bytes));
        }

        @Specialization
        public RubyString stringPattern(RubyClass stringClass, int size, RubyString string) {
            byte[] bytes = new byte[size];
            byte[] stringBytes = string.getByteList().unsafeBytes();
            if (string.getByteList().length() > 0) {
                for (int n = 0; n < size; n += string.getByteList().length()) {
                    System.arraycopy(stringBytes, 0, bytes, n, Math.min(string.getByteList().length(), size - n));
                }
            }
            return new RubyString(stringClass, new ByteList(bytes));
        }

        protected boolean isZero(int value) {
            return value == 0;
        }
    }

    @RubiniusPrimitive(name="string_rindex")
    public static abstract class StringRindexPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringRindexPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StringRindexPrimitiveNode(StringRindexPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public Object stringRindex(RubyString string, RubyString pattern, int start) {
            int pos = start;
            if (pos < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative start given", this));
            }
            ByteList buf = string.getByteList();
            int total = buf.getRealSize();
            int matchSize = pattern.getByteList().getRealSize();
            if (pos >= total) {
                pos = total - 1;
            }
            switch (matchSize) {
                case 0: {
                    return start;
                }
                case 1: {
                    int matcher = pattern.getByteList().get(0);
                    while (pos >= 0) {
                        if (buf.get(pos) == matcher) {
                            return pos;
                        }
                        --pos;
                    }
                    return this.nil();
                }
            }
            if (total - pos < matchSize) {
                pos = total - matchSize;
            }
            for (int cur = pos; cur >= 0; --cur) {
                if (ByteList.memcmp((byte[])string.getByteList().getUnsafeBytes(), (int)cur, (byte[])pattern.getByteList().getUnsafeBytes(), (int)0, (int)matchSize) != 0) continue;
                return cur;
            }
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="string_resize_capacity", needsSelf=false)
    public static abstract class StringResizeCapacityPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringResizeCapacityPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StringResizeCapacityPrimitiveNode(StringResizeCapacityPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString stringResizeCapacity(RubyString string, int capacity) {
            string.getByteList().ensure(capacity);
            return string;
        }
    }

    @RubiniusPrimitive(name="string_copy_from", needsSelf=false)
    public static abstract class StringCopyFromPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringCopyFromPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StringCopyFromPrimitiveNode(StringCopyFromPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString stringCopyFrom(RubyString string, RubyString other, int start, int size, int dest) {
            int sz;
            int src = start;
            int dst = dest;
            int cnt = size;
            int osz = other.getByteList().length();
            if (src >= osz) {
                return string;
            }
            if (cnt < 0) {
                return string;
            }
            if (src < 0) {
                src = 0;
            }
            if (cnt > osz - src) {
                cnt = osz - src;
            }
            if (dst >= (sz = string.getByteList().getUnsafeBytes().length)) {
                return string;
            }
            if (dst < 0) {
                dst = 0;
            }
            if (cnt > sz - dst) {
                cnt = sz - dst;
            }
            System.arraycopy(other.getByteList().unsafeBytes(), src, string.getByteList().getUnsafeBytes(), dest, cnt);
            return string;
        }
    }

    @RubiniusPrimitive(name="string_previous_byte_index")
    public static abstract class StringPreviousByteIndexPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringPreviousByteIndexPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StringPreviousByteIndexPrimitiveNode(StringPreviousByteIndexPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public Object stringPreviousByteIndex(RubyString string, int index) {
            if (index < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative index given", this));
            }
            ByteList bytes = string.getByteList();
            int p = bytes.getBegin();
            int end = p + bytes.getRealSize();
            int b = bytes.getEncoding().prevCharHead(bytes.getUnsafeBytes(), p, p + index, end);
            if (b == -1) {
                return this.nil();
            }
            return b - p;
        }
    }

    @RubiniusPrimitive(name="string_byte_index", needsSelf=false)
    public static abstract class StringByteIndexPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringByteIndexPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StringByteIndexPrimitiveNode(StringByteIndexPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public Object stringByteIndex(RubyString string, int index, int start) {
            int i;
            ByteList bytes = string.getByteList();
            Encoding enc = bytes.getEncoding();
            int p = bytes.getBegin();
            int e = p + bytes.getRealSize();
            int k = index;
            if (k < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("character index is negative", this));
            }
            for (i = 0; i < k && p < e; ++i) {
                int c = StringSupport.preciseLength((Encoding)enc, (byte[])bytes.getUnsafeBytes(), (int)p, (int)e);
                if (!StringSupport.MBCLEN_CHARFOUND_P((int)c)) {
                    ++p;
                    continue;
                }
                p += StringSupport.MBCLEN_CHARFOUND_LEN((int)c);
            }
            if (i < k) {
                return this.nil();
            }
            return p;
        }

        @Specialization
        public Object stringByteIndex(RubyString string, RubyString pattern, int offset) {
            int match_size = pattern.getByteList().length();
            if (offset < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative start given", this));
            }
            if (match_size == 0) {
                return offset;
            }
            if (string.scanForCodeRange() == 48) {
                return this.nil();
            }
            Encoding encoding = string.checkEncoding(pattern, this);
            int p = string.getByteList().getBegin();
            int e = p + string.getByteList().getRealSize();
            int pp = pattern.getByteList().getBegin();
            int pe = pp + pattern.getByteList().getRealSize();
            byte[] stringBytes = string.getByteList().getUnsafeBytes();
            byte[] patternBytes = pattern.getByteList().getUnsafeBytes();
            int s = p;
            int ss = pp;
            while (p < e) {
                if (stringBytes[p] == patternBytes[pp]) {
                    while (p < e && pp < pe && stringBytes[p] == patternBytes[pp]) {
                        ++p;
                        ++pp;
                    }
                    if (pp < pe) {
                        p = s;
                        pp = ss;
                    } else {
                        int c = StringSupport.preciseLength((Encoding)encoding, (byte[])stringBytes, (int)s, (int)e);
                        if (StringSupport.MBCLEN_CHARFOUND_P((int)c)) {
                            return s;
                        }
                        return this.nil();
                    }
                }
                s = ++p;
            }
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="string_character_index", needsSelf=false)
    public static abstract class StringCharacterIndexPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringCharacterIndexPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StringCharacterIndexPrimitiveNode(StringCharacterIndexPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public Object stringCharacterIndex(RubyString string, RubyString pattern, int offset) {
            int index;
            int c;
            StringCharacterIndexPrimitiveNode.notDesignedForCompilation();
            if (offset < 0) {
                return this.nil();
            }
            int total = string.getByteList().length();
            int p = string.getByteList().getBegin();
            int e = p + total;
            int pp = pattern.getByteList().getBegin();
            int pe = pp + pattern.getByteList().length();
            byte[] stringBytes = string.getByteList().getUnsafeBytes();
            byte[] patternBytes = pattern.getByteList().getUnsafeBytes();
            if (StringSupport.isSingleByteOptimizable((CodeRangeable)string, (Encoding)string.getByteList().getEncoding())) {
                int s = p += offset;
                int ss = pp;
                while (p < e) {
                    if (stringBytes[p] == patternBytes[pp]) {
                        while (p < e && pp < pe && stringBytes[p] == patternBytes[pp]) {
                            ++p;
                            ++pp;
                        }
                        if (pp < pe) {
                            p = s;
                            pp = ss;
                        } else {
                            return s;
                        }
                    }
                    s = ++p;
                }
                return this.nil();
            }
            Encoding enc = string.getByteList().getEncoding();
            for (index = 0; p < e && index < offset; p += c, ++index) {
                c = StringSupport.preciseLength((Encoding)enc, (byte[])stringBytes, (int)p, (int)e);
                if (StringSupport.MBCLEN_CHARFOUND_P((int)c)) {
                    continue;
                }
                return this.nil();
            }
            int s = p;
            int ss = pp;
            while (p < e) {
                c = StringSupport.preciseLength((Encoding)enc, (byte[])stringBytes, (int)p, (int)e);
                if (!StringSupport.MBCLEN_CHARFOUND_P((int)c)) {
                    return this.nil();
                }
                if (stringBytes[p] == patternBytes[pp]) {
                    while (p < e && pp < pe) {
                        boolean breakOut = false;
                        int pc = p + c;
                        while (p < e && p < pc && pp < pe) {
                            if (stringBytes[p] == patternBytes[pp]) {
                                ++p;
                                ++pp;
                                continue;
                            }
                            breakOut = true;
                            break;
                        }
                        if (!breakOut && StringSupport.MBCLEN_CHARFOUND_P((int)(c = StringSupport.preciseLength((Encoding)enc, (byte[])stringBytes, (int)p, (int)e)))) continue;
                        break;
                    }
                    if (pp < pe) {
                        p = s;
                        pp = ss;
                    } else {
                        return index;
                    }
                }
                s = p += c;
                ++index;
            }
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="string_byte_character_index", needsSelf=false)
    @ImportGuards(value={StringGuards.class})
    public static abstract class StringByteCharacterIndexPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringByteCharacterIndexPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StringByteCharacterIndexPrimitiveNode(StringByteCharacterIndexPrimitiveNode prev) {
            super(prev);
        }

        @Specialization(guards={"isSingleByteOptimizableOrAsciiCompatible"})
        public int stringByteCharacterIndexSingleByte(RubyString string, int index, int start) {
            return index;
        }

        @Specialization(guards={"!isSingleByteOptimizableOrAsciiCompatible", "isFixedWidthEncoding", "!isValidUtf8"})
        public int stringByteCharacterIndexFixedWidth(RubyString string, int index, int start) {
            return index / string.getByteList().getEncoding().minLength();
        }

        @Specialization(guards={"!isSingleByteOptimizableOrAsciiCompatible", "!isFixedWidthEncoding", "isValidUtf8"})
        public int stringByteCharacterIndexValidUtf8(RubyString string, int index, int start) {
            return this.stringByteCharacterIndex(string, index, start);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isSingleByteOptimizableOrAsciiCompatible", "!isFixedWidthEncoding", "!isValidUtf8"})
        public int stringByteCharacterIndex(RubyString string, int index, int start) {
            ByteList bytes = string.getByteList();
            Encoding encoding = bytes.getEncoding();
            int p = bytes.begin() + start;
            int end = bytes.begin() + bytes.realSize();
            int charIndex = 0;
            while (p < end && index > 0) {
                int charLen = StringSupport.length((Encoding)encoding, (byte[])bytes.getUnsafeBytes(), (int)p, (int)end);
                p += charLen;
                index -= charLen;
                ++charIndex;
            }
            return charIndex;
        }
    }

    @RubiniusPrimitive(name="string_character_byte_index", needsSelf=false)
    @ImportGuards(value={StringGuards.class})
    public static abstract class CharacterByteIndexNode
    extends RubiniusPrimitiveNode {
        public CharacterByteIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CharacterByteIndexNode(CharacterByteIndexNode prev) {
            super(prev);
        }

        @Specialization(guards={"isSingleByteOptimizable"})
        public int stringCharacterByteIndex(RubyString string, int index, int start) {
            return start + index;
        }

        @Specialization(guards={"!isSingleByteOptimizable"})
        public int stringCharacterByteIndexMultiByteEncoding(RubyString string, int index, int start) {
            ByteList bytes = string.getBytes();
            return StringSupport.nth((Encoding)bytes.getEncoding(), (byte[])bytes.getUnsafeBytes(), (int)bytes.getBegin(), (int)(bytes.getBegin() + bytes.getRealSize()), (int)(start + index));
        }
    }

    @RubiniusPrimitive(name="string_index", lowerFixnumParameters={1})
    public static abstract class StringIndexPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringIndexPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StringIndexPrimitiveNode(StringIndexPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public Object stringIndex(RubyString string, RubyString pattern, int start) {
            int index = StringSupport.index((CodeRangeable)string, (CodeRangeable)pattern, (int)start, (Encoding)string.getBytes().getEncoding());
            if (index == -1) {
                return this.nil();
            }
            return index;
        }
    }

    @RubiniusPrimitive(name="string_to_f", needsSelf=false)
    public static abstract class StringToFPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringToFPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StringToFPrimitiveNode(StringToFPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public Object stringToF(RubyString string) {
            StringToFPrimitiveNode.notDesignedForCompilation();
            try {
                return Double.parseDouble(string.toString());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    @RubiniusPrimitive(name="string_from_codepoint", needsSelf=false)
    public static abstract class StringFromCodepointPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringFromCodepointPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StringFromCodepointPrimitiveNode(StringFromCodepointPrimitiveNode prev) {
            super(prev);
        }

        @Specialization(guards={"isSimple"})
        public RubyString stringFromCodepointSimple(int code, org.jruby.truffle.runtime.core.RubyEncoding encoding) {
            return new RubyString(this.getContext().getCoreLibrary().getStringClass(), new ByteList(new byte[]{(byte)code}, encoding.getEncoding()));
        }

        @Specialization(guards={"!isSimple"})
        public RubyString stringFromCodepoint(int code, org.jruby.truffle.runtime.core.RubyEncoding encoding) {
            int length;
            StringFromCodepointPrimitiveNode.notDesignedForCompilation();
            try {
                length = encoding.getEncoding().codeToMbcLength(code);
            }
            catch (EncodingException e) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().rangeError(code, encoding, this));
            }
            if (length <= 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().rangeError(code, encoding, this));
            }
            byte[] bytes = new byte[length];
            try {
                encoding.getEncoding().codeToMbc(code, bytes, 0);
            }
            catch (EncodingException e) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().rangeError(code, encoding, this));
            }
            return new RubyString(this.getContext().getCoreLibrary().getStringClass(), new ByteList(bytes, encoding.getEncoding()));
        }

        @Specialization
        public RubyString stringFromCodepointSimple(long code, org.jruby.truffle.runtime.core.RubyEncoding encoding) {
            StringFromCodepointPrimitiveNode.notDesignedForCompilation();
            if (code < Integer.MIN_VALUE || code > Integer.MAX_VALUE) {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException();
            }
            return this.stringFromCodepointSimple((int)code, encoding);
        }

        protected boolean isSimple(int code, org.jruby.truffle.runtime.core.RubyEncoding encoding) {
            return encoding.getEncoding() == ASCIIEncoding.INSTANCE && code >= 0 && code <= 255;
        }
    }

    @RubiniusPrimitive(name="string_find_character")
    @ImportGuards(value={StringGuards.class})
    public static abstract class StringFindCharacterPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private TaintResultNode taintResultNode;

        public StringFindCharacterPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StringFindCharacterPrimitiveNode(StringFindCharacterPrimitiveNode prev) {
            super(prev);
            this.taintResultNode = prev.taintResultNode;
        }

        @Specialization(guards={"isSingleByte"})
        public Object stringFindCharacterSingleByte(RubyString string, int offset) {
            if (offset < 0) {
                return this.nil();
            }
            if (offset >= string.getByteList().getRealSize()) {
                return this.nil();
            }
            RubyString ret = this.getContext().makeString(string.getLogicalClass(), new ByteList(string.getByteList().unsafeBytes(), offset, 1));
            return this.propagate(string, ret);
        }

        @Specialization(guards={"!isSingleByte"})
        public Object stringFindCharacter(RubyString string, int offset) {
            if (offset < 0) {
                return this.nil();
            }
            if (offset >= string.getByteList().getRealSize()) {
                return this.nil();
            }
            ByteList bytes = string.getByteList();
            Encoding enc = bytes.getEncoding();
            int clen = StringSupport.preciseLength((Encoding)enc, (byte[])bytes.getUnsafeBytes(), (int)bytes.begin(), (int)(bytes.begin() + bytes.realSize()));
            RubyString ret = StringSupport.MBCLEN_CHARFOUND_P((int)clen) ? this.getContext().makeString(string.getLogicalClass(), new ByteList(string.getByteList().unsafeBytes(), offset, clen)) : this.getContext().makeString(string.getLogicalClass(), new ByteList(string.getByteList().unsafeBytes(), offset, 1));
            return this.propagate(string, ret);
        }

        private Object propagate(RubyString string, RubyString ret) {
            ret.getByteList().setEncoding(string.getByteList().getEncoding());
            ret.setCodeRange(string.getCodeRange());
            return this.maybeTaint(string, ret);
        }

        private Object maybeTaint(RubyString source, RubyString value) {
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintResultNode = (TaintResultNode)this.insert(new TaintResultNode(this.getContext(), this.getSourceSection()));
            }
            return this.taintResultNode.maybeTaint(source, value);
        }
    }

    @RubiniusPrimitive(name="string_equal", needsSelf=true)
    public static abstract class StringEqualPrimitiveNode
    extends RubiniusPrimitiveNode {
        private final ConditionProfile incompatibleEncodingProfile = ConditionProfile.createBinaryProfile();

        public StringEqualPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StringEqualPrimitiveNode(StringEqualPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public boolean stringEqual(RubyString string, RubyString other) {
            ByteList a = string.getBytes();
            ByteList b = other.getBytes();
            if (this.incompatibleEncodingProfile.profile(a.getEncoding() != b.getEncoding() && RubyEncoding.areCompatible((CodeRangeable)string, (CodeRangeable)other) == null)) {
                return false;
            }
            return a.equal(b);
        }
    }

    @RubiniusPrimitive(name="string_compare_substring")
    public static abstract class StringCompareSubstringPrimitiveNode
    extends RubiniusPrimitiveNode {
        private final ConditionProfile startTooLargeProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile startTooSmallProfile = ConditionProfile.createBinaryProfile();
        @Node.Child
        private StringNodes.SizeNode sizeNode;

        public StringCompareSubstringPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.sizeNode = StringNodesFactory.SizeNodeFactory.create(context, sourceSection, new RubyNode[]{null});
        }

        public StringCompareSubstringPrimitiveNode(StringCompareSubstringPrimitiveNode prev) {
            super(prev);
            this.sizeNode = prev.sizeNode;
        }

        @Specialization
        public int stringCompareSubstring(VirtualFrame frame, RubyString string, RubyString other, int start, int size) {
            int stringLength = this.sizeNode.executeIntegerFixnum(frame, string);
            int otherLength = this.sizeNode.executeIntegerFixnum(frame, other);
            if (start < 0) {
                start += otherLength;
            }
            if (this.startTooLargeProfile.profile(start > otherLength)) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().indexError(String.format("index %d out of string", start), this));
            }
            if (this.startTooSmallProfile.profile(start < 0)) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().indexError(String.format("index %d out of string", start), this));
            }
            if (start + size > otherLength) {
                size = otherLength - start;
            }
            if (size > stringLength) {
                size = stringLength;
            }
            ByteList bytes = string.getByteList();
            ByteList otherBytes = other.getByteList();
            return ByteList.memcmp((byte[])bytes.getUnsafeBytes(), (int)bytes.getBegin(), (int)size, (byte[])otherBytes.getUnsafeBytes(), (int)(otherBytes.getBegin() + start), (int)size);
        }
    }

    @RubiniusPrimitive(name="string_chr_at")
    public static abstract class StringChrAtPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private StringByteSubstringPrimitiveNode stringByteSubstringNode;

        public StringChrAtPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StringChrAtPrimitiveNode(StringChrAtPrimitiveNode prev) {
            super(prev);
            this.stringByteSubstringNode = prev.stringByteSubstringNode;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object stringChrAt(RubyString string, int byteIndex) {
            ByteList bytes = string.getByteList();
            if (byteIndex < 0 || byteIndex >= bytes.getRealSize()) {
                return this.nil();
            }
            int p = bytes.getBegin() + byteIndex;
            int end = bytes.getBegin() + bytes.getRealSize();
            int c = StringSupport.preciseLength((Encoding)bytes.getEncoding(), (byte[])bytes.getUnsafeBytes(), (int)p, (int)end);
            if (!StringSupport.MBCLEN_CHARFOUND_P((int)c)) {
                return this.nil();
            }
            int n = StringSupport.MBCLEN_CHARFOUND_LEN((int)c);
            if (n + byteIndex > end) {
                return this.nil();
            }
            if (this.stringByteSubstringNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.stringByteSubstringNode = (StringByteSubstringPrimitiveNode)this.insert(StringPrimitiveNodesFactory.StringByteSubstringPrimitiveNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
            }
            return this.stringByteSubstringNode.stringByteSubstring(string, byteIndex, n);
        }
    }

    @RubiniusPrimitive(name="string_check_null_safe", needsSelf=false)
    public static abstract class StringCheckNullSafePrimitiveNode
    extends RubiniusPrimitiveNode {
        private final ConditionProfile nullByteProfile = ConditionProfile.createBinaryProfile();

        public StringCheckNullSafePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StringCheckNullSafePrimitiveNode(StringCheckNullSafePrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public boolean stringCheckNullSafe(RubyString string) {
            for (byte b : string.getBytes().unsafeBytes()) {
                if (!this.nullByteProfile.profile(b == 0)) continue;
                return false;
            }
            return true;
        }
    }

    @RubiniusPrimitive(name="string_byte_substring")
    public static abstract class StringByteSubstringPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private TaintResultNode taintResultNode;

        public StringByteSubstringPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.taintResultNode = new TaintResultNode(context, sourceSection);
        }

        public StringByteSubstringPrimitiveNode(StringByteSubstringPrimitiveNode prev) {
            super(prev);
            this.taintResultNode = prev.taintResultNode;
        }

        @Specialization
        public Object stringByteSubstring(RubyString string, int index, UndefinedPlaceholder length) {
            Object subString = this.stringByteSubstring(string, index, 1);
            if (subString == this.nil()) {
                return subString;
            }
            if (((RubyString)subString).getByteList().length() == 0) {
                return this.nil();
            }
            return subString;
        }

        @Specialization
        public Object stringByteSubstring(RubyString string, int index, int length) {
            ByteList bytes = string.getBytes();
            if (length < 0) {
                return this.nil();
            }
            int normalizedIndex = string.normalizeIndex(index);
            if (normalizedIndex > bytes.length()) {
                return this.nil();
            }
            int rangeEnd = normalizedIndex + length;
            if (rangeEnd > bytes.length()) {
                rangeEnd = bytes.length();
            }
            if (normalizedIndex < bytes.getBegin()) {
                return this.nil();
            }
            byte[] copiedBytes = Arrays.copyOfRange(bytes.getUnsafeBytes(), normalizedIndex, rangeEnd);
            RubyString result = this.getContext().makeString(string.getLogicalClass(), new ByteList(copiedBytes, string.getBytes().getEncoding()));
            return this.taintResultNode.maybeTaint(string, result);
        }

        @Specialization
        public Object stringByteSubstring(RubyString string, int index, double length) {
            return this.stringByteSubstring(string, index, (int)length);
        }

        @Specialization
        public Object stringByteSubstring(RubyString string, double index, UndefinedPlaceholder length) {
            return this.stringByteSubstring(string, (int)index, 1);
        }

        @Specialization
        public Object stringByteSubstring(RubyString string, long index, int length) {
            return this.stringByteSubstring(string, index, (long)length);
        }

        @Specialization
        public Object stringByteSubstring(RubyString string, int index, long length) {
            return this.stringByteSubstring(string, (long)index, length);
        }

        @Specialization
        public Object stringByteSubstring(RubyString string, long index, long length) {
            if (index > Integer.MAX_VALUE || index < Integer.MIN_VALUE) {
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("index out of int range", this));
            }
            if (length > Integer.MAX_VALUE || length < Integer.MIN_VALUE) {
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("length out of int range", this));
            }
            return this.stringByteSubstring(string, (int)index, (int)length);
        }

        @Specialization
        public Object stringByteSubstring(RubyString string, double index, double length) {
            return this.stringByteSubstring(string, (int)index, (int)length);
        }

        @Specialization
        public Object stringByteSubstring(RubyString string, double index, int length) {
            return this.stringByteSubstring(string, (int)index, length);
        }

        @Specialization
        public Object stringByteSubstring(RubyString string, RubyRange range, UndefinedPlaceholder unused) {
            return null;
        }

        @Specialization(guards={"!isRubyRange(arguments[1])"})
        public Object stringByteSubstring(RubyString string, Object indexOrRange, Object length) {
            return null;
        }
    }

    @RubiniusPrimitive(name="string_awk_split")
    public static abstract class StringAwkSplitPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private TaintResultNode taintResultNode;

        public StringAwkSplitPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.taintResultNode = new TaintResultNode(context, sourceSection);
        }

        public StringAwkSplitPrimitiveNode(StringAwkSplitPrimitiveNode prev) {
            super(prev);
            this.taintResultNode = prev.taintResultNode;
        }

        @Specialization
        public RubyArray stringAwkSplit(RubyString string, int lim) {
            int p;
            StringAwkSplitPrimitiveNode.notDesignedForCompilation();
            ArrayList<RubyString> ret = new ArrayList<RubyString>();
            ByteList value = string.getBytes();
            boolean limit = lim > 0;
            int i = lim > 0 ? 1 : 0;
            byte[] bytes = value.getUnsafeBytes();
            int ptr = p = value.getBegin();
            int len = value.getRealSize();
            int end = p + len;
            Encoding enc = value.getEncoding();
            boolean skip = true;
            int e = 0;
            int b = 0;
            boolean singlebyte = StringSupport.isSingleByteOptimizable((CodeRangeable)string, (Encoding)enc);
            while (p < end) {
                int c;
                if (singlebyte) {
                    c = bytes[p++] & 0xFF;
                } else {
                    try {
                        c = StringSupport.codePoint((Ruby)this.getContext().getRuntime(), (Encoding)enc, (byte[])bytes, (int)p, (int)end);
                    }
                    catch (RaiseException ex) {
                        throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().toTruffle(ex.getException(), this));
                    }
                    p += StringSupport.length((Encoding)enc, (byte[])bytes, (int)p, (int)end);
                }
                if (skip) {
                    if (enc.isSpace(c)) {
                        b = p - ptr;
                        continue;
                    }
                    e = p - ptr;
                    skip = false;
                    if (!limit || lim > i) continue;
                    break;
                }
                if (enc.isSpace(c)) {
                    ret.add(this.makeString(string, b, e - b));
                    skip = true;
                    b = p - ptr;
                    if (!limit) continue;
                    ++i;
                    continue;
                }
                e = p - ptr;
            }
            if (len > 0 && (limit || len > b || lim < 0)) {
                ret.add(this.makeString(string, b, len - b));
            }
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), ret.toArray());
        }

        private RubyString makeString(RubyString source, int index, int length) {
            ByteList bytes = new ByteList(source.getBytes(), index, length);
            bytes.setEncoding(source.getBytes().getEncoding());
            RubyString ret = this.getContext().makeString(source.getLogicalClass(), bytes);
            this.taintResultNode.maybeTaint(source, ret);
            return ret;
        }
    }

    @RubiniusPrimitive(name="character_ascii_p")
    public static abstract class CharacterAsciiPrimitiveNode
    extends RubiniusPrimitiveNode {
        public CharacterAsciiPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CharacterAsciiPrimitiveNode(CharacterAsciiPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public boolean isCharacterAscii(RubyString character) {
            ByteList bytes = character.getByteList();
            int codepoint = StringSupport.preciseCodePoint((Encoding)bytes.getEncoding(), (byte[])bytes.getUnsafeBytes(), (int)bytes.getBegin(), (int)(bytes.getBegin() + bytes.getRealSize()));
            boolean found = codepoint != -1;
            return found && Encoding.isAscii((int)codepoint);
        }
    }
}

