/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.source.SourceSection;
import jnr.posix.FileStat;
import org.jruby.truffle.nodes.objectstorage.ReadHeadObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.WriteHeadObjectFieldNode;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyString;

public abstract class StatPrimitiveNodes {
    public static final HiddenKey STAT_IDENTIFIER = new HiddenKey("stat");

    @RubiniusPrimitive(name="stat_uid")
    public static abstract class StatUIDPrimitiveNode
    extends StatReadPrimitiveNode {
        public StatUIDPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StatUIDPrimitiveNode(StatUIDPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public int uid(RubyBasicObject rubyStat) {
            return this.getStat(rubyStat).uid();
        }
    }

    @RubiniusPrimitive(name="stat_gid")
    public static abstract class StatGIDPrimitiveNode
    extends StatReadPrimitiveNode {
        public StatGIDPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StatGIDPrimitiveNode(StatGIDPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public int gid(RubyBasicObject rubyStat) {
            return this.getStat(rubyStat).gid();
        }
    }

    @RubiniusPrimitive(name="stat_mode")
    public static abstract class StatModePrimitiveNode
    extends StatReadPrimitiveNode {
        public StatModePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StatModePrimitiveNode(StatModePrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public int mode(RubyBasicObject rubyStat) {
            return this.getStat(rubyStat).mode();
        }
    }

    @RubiniusPrimitive(name="stat_size")
    public static abstract class StatSizePrimitiveNode
    extends StatReadPrimitiveNode {
        public StatSizePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StatSizePrimitiveNode(StatSizePrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public long size(RubyBasicObject rubyStat) {
            return this.getStat(rubyStat).st_size();
        }
    }

    public static abstract class StatReadPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private ReadHeadObjectFieldNode readStatNode;

        public StatReadPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.readStatNode = new ReadHeadObjectFieldNode(STAT_IDENTIFIER);
        }

        public StatReadPrimitiveNode(StatReadPrimitiveNode prev) {
            super(prev);
            this.readStatNode = prev.readStatNode;
        }

        public FileStat getStat(RubyBasicObject rubyStat) {
            return (FileStat)this.readStatNode.execute(rubyStat);
        }
    }

    @RubiniusPrimitive(name="stat_lstat")
    public static abstract class StatLStatPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private WriteHeadObjectFieldNode writeStatNode;

        public StatLStatPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.writeStatNode = new WriteHeadObjectFieldNode(STAT_IDENTIFIER);
        }

        public StatLStatPrimitiveNode(StatLStatPrimitiveNode prev) {
            super(prev);
            this.writeStatNode = prev.writeStatNode;
        }

        @Specialization
        public int lstat(RubyBasicObject rubyStat, RubyString path) {
            FileStat stat = this.posix().allocateStat();
            int code = this.posix().lstat(path.toString(), stat);
            if (code == 0) {
                this.writeStatNode.execute(rubyStat, stat);
            }
            return code;
        }

        @Specialization(guards={"!isRubyString(arguments[1])"})
        public Object stat(RubyBasicObject rubyStat, Object path) {
            return null;
        }
    }

    @RubiniusPrimitive(name="stat_stat")
    public static abstract class StatStatPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private WriteHeadObjectFieldNode writeStatNode;

        public StatStatPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.writeStatNode = new WriteHeadObjectFieldNode(STAT_IDENTIFIER);
        }

        public StatStatPrimitiveNode(StatStatPrimitiveNode prev) {
            super(prev);
            this.writeStatNode = prev.writeStatNode;
        }

        @Specialization
        public int stat(RubyBasicObject rubyStat, RubyString path) {
            FileStat stat = this.posix().allocateStat();
            int code = this.posix().stat(path.toString(), stat);
            if (code == 0) {
                this.writeStatNode.execute(rubyStat, stat);
            }
            return code;
        }

        @Specialization(guards={"!isRubyString(arguments[1])"})
        public Object stat(RubyBasicObject rubyStat, Object path) {
            return null;
        }
    }
}

