/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.rubinius.ArrayPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.BignumPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.DirPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.EncodingConverterPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.EncodingPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.ExceptionPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.FixnumPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.FloatPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.IOBufferPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.IOPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.ModulePrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.NativeFunctionPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.ObjectPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.PointerPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.RandomPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.RegexpPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveConstructor;
import org.jruby.truffle.nodes.rubinius.StatPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.StringPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.SymbolPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.TimePrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.UndefinedPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.VMPrimitiveNodesFactory;

public class RubiniusPrimitiveManager {
    private final Map<String, RubiniusPrimitiveConstructor> primitives;

    private RubiniusPrimitiveManager(Map<String, RubiniusPrimitiveConstructor> primitives) {
        this.primitives = primitives;
    }

    public RubiniusPrimitiveConstructor getPrimitive(String name) {
        RubiniusPrimitiveConstructor constructor = this.primitives.get(name);
        if (constructor == null) {
            return this.primitives.get("undefined");
        }
        return constructor;
    }

    public static RubiniusPrimitiveManager create() {
        ArrayList<Object> nodeFactories = new ArrayList<Object>();
        nodeFactories.addAll(VMPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(ObjectPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(TimePrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(StringPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(SymbolPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(FixnumPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(BignumPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(FloatPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(EncodingPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(EncodingConverterPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(RegexpPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(ModulePrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(RandomPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(ArrayPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(StatPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(PointerPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(NativeFunctionPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(DirPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(IOPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(IOBufferPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(ExceptionPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(UndefinedPrimitiveNodesFactory.getFactories());
        HashMap<String, RubiniusPrimitiveConstructor> primitives = new HashMap<String, RubiniusPrimitiveConstructor>();
        for (NodeFactory nodeFactory : nodeFactories) {
            GeneratedBy generatedBy = nodeFactory.getClass().getAnnotation(GeneratedBy.class);
            Class nodeClass = generatedBy.value();
            RubiniusPrimitive annotation = nodeClass.getAnnotation(RubiniusPrimitive.class);
            primitives.put(annotation.name(), new RubiniusPrimitiveConstructor(annotation, (NodeFactory<? extends RubyNode>)nodeFactory));
        }
        return new RubiniusPrimitiveManager(primitives);
    }
}

