/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.joni.Matcher;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyRegexp;
import org.jruby.truffle.runtime.core.RubyString;

public abstract class RegexpPrimitiveNodes {

    @RubiniusPrimitive(name="regexp_set_block_last_match")
    public static abstract class RegexpSetBlockLastMatchPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpSetBlockLastMatchPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RegexpSetBlockLastMatchPrimitiveNode(RegexpSetBlockLastMatchPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass setBlockLastMatch(RubyClass regexpClass) {
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="regexp_set_last_match")
    public static abstract class RegexpSetLastMatchPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpSetLastMatchPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RegexpSetLastMatchPrimitiveNode(RegexpSetLastMatchPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public Object setLastMatch(RubyClass regexpClass, Object matchData) {
            RegexpSetLastMatchPrimitiveNode.notDesignedForCompilation();
            this.getContext().getThreadManager().getCurrentThread().getThreadLocals().getOperations().setInstanceVariable(this.getContext().getThreadManager().getCurrentThread().getThreadLocals(), "$~", matchData);
            return matchData;
        }
    }

    @RubiniusPrimitive(name="regexp_search_region", lowerFixnumParameters={1, 2})
    public static abstract class RegexpSearchRegionPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpSearchRegionPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RegexpSearchRegionPrimitiveNode(RegexpSearchRegionPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public Object searchRegion(RubyRegexp regexp, RubyString string, int start, int end, boolean forward) {
            RegexpSearchRegionPrimitiveNode.notDesignedForCompilation();
            if (regexp.getRegex() == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("uninitialized Regexp", this));
            }
            if (string.scanForCodeRange() == 48) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError(String.format("invalid byte sequence in %s", string.getByteList().getEncoding()), this));
            }
            Matcher matcher = regexp.getRegex().matcher(string.getBytes().bytes());
            return regexp.matchCommon(string, false, false, matcher, start, end);
        }
    }

    @RubiniusPrimitive(name="regexp_initialize")
    public static abstract class RegexpInitializePrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpInitializePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RegexpInitializePrimitiveNode(RegexpInitializePrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public RubyRegexp initialize(RubyRegexp regexp, RubyString pattern, int options) {
            RegexpInitializePrimitiveNode.notDesignedForCompilation();
            regexp.initialize(this, pattern.getBytes(), options);
            return regexp;
        }
    }
}

