/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.rubinius.PosixNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyString;

@GeneratedBy(value=PosixNodes.class)
public final class PosixNodesFactory {
    public static List<NodeFactory<? extends RubyNode>> getFactories() {
        return Arrays.asList(GetEGIDNodeFactory.getInstance(), GetEUIDNodeFactory.getInstance(), GetGIDNodeFactory.getInstance(), GetGroupsNodeFactory.getInstance(), GetUIDNodeFactory.getInstance(), MemsetNodeFactory.getInstance(), UnlinkNodeFactory.getInstance(), MkdirNodeFactory.getInstance(), ChdirNodeFactory.getInstance(), RmdirNodeFactory.getInstance(), GetcwdNodeFactory.getInstance(), ErrnoNodeFactory.getInstance(), FcntlNodeFactory.getInstance(), IsATTYNodeFactory.getInstance(), SymlinkNodeFactory.getInstance());
    }

    @GeneratedBy(value=PosixNodes.SymlinkNode.class)
    public static final class SymlinkNodeFactory
    extends NodeFactoryBase<PosixNodes.SymlinkNode> {
        private static SymlinkNodeFactory symlinkNodeFactoryInstance;

        private SymlinkNodeFactory() {
            super(PosixNodes.SymlinkNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public PosixNodes.SymlinkNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SymlinkNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static PosixNodes.SymlinkNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SymlinkUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<PosixNodes.SymlinkNode> getInstance() {
            if (symlinkNodeFactoryInstance == null) {
                symlinkNodeFactoryInstance = new SymlinkNodeFactory();
            }
            return symlinkNodeFactoryInstance;
        }

        @GeneratedBy(value=PosixNodes.SymlinkNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SymlinkPolymorphicNode
        extends SymlinkBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            SymlinkPolymorphicNode(SymlinkBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=PosixNodes.SymlinkNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SymlinkRubyStringNode
        extends SymlinkBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SymlinkRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class}, 0, 0);

            SymlinkRubyStringNode(SymlinkBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.symlink(arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.symlink(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static PosixNodes.SymlinkNode create0(PosixNodes.SymlinkNode current) {
                return new SymlinkRubyStringNode((SymlinkBaseNode)current);
            }
        }

        @GeneratedBy(value=PosixNodes.SymlinkNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SymlinkUninitializedNode
        extends SymlinkBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SymlinkUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SymlinkUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SymlinkUninitializedNode(SymlinkBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                SymlinkBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SymlinkBaseNode rootNode = (SymlinkBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SymlinkBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static PosixNodes.SymlinkNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SymlinkUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=PosixNodes.SymlinkNode.class)
        private static abstract class SymlinkBaseNode
        extends PosixNodes.SymlinkNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SymlinkBaseNode next0;

            SymlinkBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SymlinkBaseNode(SymlinkBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                SymlinkBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SymlinkBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new SymlinkUninitializedNode(this);
                    ((SymlinkUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SymlinkBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SymlinkBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (SymlinkBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SymlinkUninitializedNode(this), (Node)new SymlinkPolymorphicNode(this), (DSLNode)((SymlinkBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SymlinkBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    return (SymlinkBaseNode)SymlinkRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    SymlinkBaseNode otherCast = (SymlinkBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (SymlinkBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=PosixNodes.IsATTYNode.class)
    public static final class IsATTYNodeFactory
    extends NodeFactoryBase<PosixNodes.IsATTYNode> {
        private static IsATTYNodeFactory isATTYNodeFactoryInstance;

        private IsATTYNodeFactory() {
            super(PosixNodes.IsATTYNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public PosixNodes.IsATTYNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IsATTYNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static PosixNodes.IsATTYNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IsATTYUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<PosixNodes.IsATTYNode> getInstance() {
            if (isATTYNodeFactoryInstance == null) {
                isATTYNodeFactoryInstance = new IsATTYNodeFactory();
            }
            return isATTYNodeFactoryInstance;
        }

        @GeneratedBy(value=PosixNodes.IsATTYNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IsATTYPolymorphicNode
        extends IsATTYBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            IsATTYPolymorphicNode(IsATTYBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=PosixNodes.IsATTYNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IsATTYIntNode
        extends IsATTYBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsATTYIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            IsATTYIntNode(IsATTYBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.isATTY(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.isATTY(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static PosixNodes.IsATTYNode create0(PosixNodes.IsATTYNode current) {
                return new IsATTYIntNode((IsATTYBaseNode)current);
            }
        }

        @GeneratedBy(value=PosixNodes.IsATTYNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IsATTYUninitializedNode
        extends IsATTYBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsATTYUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IsATTYUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IsATTYUninitializedNode(IsATTYBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                IsATTYBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IsATTYBaseNode rootNode = (IsATTYBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((IsATTYBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static PosixNodes.IsATTYNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IsATTYUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=PosixNodes.IsATTYNode.class)
        private static abstract class IsATTYBaseNode
        extends PosixNodes.IsATTYNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IsATTYBaseNode next0;

            IsATTYBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IsATTYBaseNode(IsATTYBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                IsATTYBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IsATTYBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new IsATTYUninitializedNode(this);
                    ((IsATTYUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (IsATTYBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = IsATTYBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (IsATTYBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new IsATTYUninitializedNode(this), (Node)new IsATTYPolymorphicNode(this), (DSLNode)((IsATTYBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IsATTYBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (IsATTYBaseNode)IsATTYIntNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((IsATTYBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (IsATTYBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=PosixNodes.FcntlNode.class)
    public static final class FcntlNodeFactory
    extends NodeFactoryBase<PosixNodes.FcntlNode> {
        private static FcntlNodeFactory fcntlNodeFactoryInstance;

        private FcntlNodeFactory() {
            super(PosixNodes.FcntlNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public PosixNodes.FcntlNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return FcntlNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static PosixNodes.FcntlNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return FcntlUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<PosixNodes.FcntlNode> getInstance() {
            if (fcntlNodeFactoryInstance == null) {
                fcntlNodeFactoryInstance = new FcntlNodeFactory();
            }
            return fcntlNodeFactoryInstance;
        }

        @GeneratedBy(value=PosixNodes.FcntlNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class FcntlPolymorphicNode
        extends FcntlBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            FcntlPolymorphicNode(FcntlBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments2Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments2PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[2].executeIntegerFixnum(frameValue)) : (this.arguments2PolymorphicType == RubyNilClass.class ? this.arguments[2].executeRubyNilClass(frameValue) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=PosixNodes.FcntlNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FcntlIntNode
        extends FcntlBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FcntlIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE}, 0, 0);

            FcntlIntNode(FcntlBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments2Value;
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                return super.fcntl(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    return super.fcntl(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static PosixNodes.FcntlNode create0(PosixNodes.FcntlNode current) {
                return new FcntlIntNode((FcntlBaseNode)current);
            }
        }

        @GeneratedBy(value=PosixNodes.FcntlNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FcntlIntRubyNilClassNode
        extends FcntlBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FcntlIntRubyNilClassNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE, RubyNilClass.class}, 0, 0);

            FcntlIntRubyNilClassNode(FcntlBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyNilClass arguments2Value;
                int arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyNilClass");
                }
                return super.fcntl(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyNilClass(arguments2Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    RubyNilClass arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyNilClass(arguments2Value);
                    return super.fcntl(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static PosixNodes.FcntlNode create0(PosixNodes.FcntlNode current) {
                return new FcntlIntRubyNilClassNode((FcntlBaseNode)current);
            }
        }

        @GeneratedBy(value=PosixNodes.FcntlNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class FcntlUninitializedNode
        extends FcntlBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FcntlUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            FcntlUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            FcntlUninitializedNode(FcntlBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                FcntlBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    FcntlBaseNode rootNode = (FcntlBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((FcntlBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static PosixNodes.FcntlNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new FcntlUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=PosixNodes.FcntlNode.class)
        private static abstract class FcntlBaseNode
        extends PosixNodes.FcntlNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected FcntlBaseNode next0;

            FcntlBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            FcntlBaseNode(FcntlBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                FcntlBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                FcntlBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new FcntlUninitializedNode(this);
                    ((FcntlUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (FcntlBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = FcntlBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (FcntlBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new FcntlUninitializedNode(this), (Node)new FcntlPolymorphicNode(this), (DSLNode)((FcntlBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final FcntlBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyNilClass(arguments2Value)) {
                        return (FcntlBaseNode)FcntlIntRubyNilClassNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                        return (FcntlBaseNode)FcntlIntNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    FcntlBaseNode otherCast = (FcntlBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (FcntlBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=PosixNodes.ErrnoNode.class)
    public static final class ErrnoNodeFactory
    extends NodeFactoryBase<PosixNodes.ErrnoNode> {
        private static ErrnoNodeFactory errnoNodeFactoryInstance;

        private ErrnoNodeFactory() {
            super(PosixNodes.ErrnoNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public PosixNodes.ErrnoNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ErrnoNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static PosixNodes.ErrnoNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ErrnoDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<PosixNodes.ErrnoNode> getInstance() {
            if (errnoNodeFactoryInstance == null) {
                errnoNodeFactoryInstance = new ErrnoNodeFactory();
            }
            return errnoNodeFactoryInstance;
        }

        @GeneratedBy(value=PosixNodes.ErrnoNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ErrnoDefaultNode
        extends ErrnoBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ErrnoDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            ErrnoDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.errno();
            }

            static PosixNodes.ErrnoNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ErrnoDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=PosixNodes.ErrnoNode.class)
        private static abstract class ErrnoBaseNode
        extends PosixNodes.ErrnoNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            ErrnoBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=PosixNodes.GetcwdNode.class)
    public static final class GetcwdNodeFactory
    extends NodeFactoryBase<PosixNodes.GetcwdNode> {
        private static GetcwdNodeFactory getcwdNodeFactoryInstance;

        private GetcwdNodeFactory() {
            super(PosixNodes.GetcwdNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public PosixNodes.GetcwdNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetcwdNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static PosixNodes.GetcwdNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GetcwdUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<PosixNodes.GetcwdNode> getInstance() {
            if (getcwdNodeFactoryInstance == null) {
                getcwdNodeFactoryInstance = new GetcwdNodeFactory();
            }
            return getcwdNodeFactoryInstance;
        }

        @GeneratedBy(value=PosixNodes.GetcwdNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class GetcwdPolymorphicNode
        extends GetcwdBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            GetcwdPolymorphicNode(GetcwdBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=PosixNodes.GetcwdNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetcwdRubyStringNode
        extends GetcwdBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetcwdRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE}, 0, 0);

            GetcwdRubyStringNode(GetcwdBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.getcwd(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.getcwd(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static PosixNodes.GetcwdNode create0(PosixNodes.GetcwdNode current) {
                return new GetcwdRubyStringNode((GetcwdBaseNode)current);
            }
        }

        @GeneratedBy(value=PosixNodes.GetcwdNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class GetcwdUninitializedNode
        extends GetcwdBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetcwdUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            GetcwdUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            GetcwdUninitializedNode(GetcwdBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                GetcwdBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    GetcwdBaseNode rootNode = (GetcwdBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((GetcwdBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static PosixNodes.GetcwdNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GetcwdUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=PosixNodes.GetcwdNode.class)
        private static abstract class GetcwdBaseNode
        extends PosixNodes.GetcwdNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected GetcwdBaseNode next0;

            GetcwdBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            GetcwdBaseNode(GetcwdBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                GetcwdBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                GetcwdBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new GetcwdUninitializedNode(this);
                    ((GetcwdUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (GetcwdBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = GetcwdBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (GetcwdBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new GetcwdUninitializedNode(this), (Node)new GetcwdPolymorphicNode(this), (DSLNode)((GetcwdBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final GetcwdBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    return (GetcwdBaseNode)GetcwdRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    GetcwdBaseNode otherCast = (GetcwdBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (GetcwdBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=PosixNodes.RmdirNode.class)
    public static final class RmdirNodeFactory
    extends NodeFactoryBase<PosixNodes.RmdirNode> {
        private static RmdirNodeFactory rmdirNodeFactoryInstance;

        private RmdirNodeFactory() {
            super(PosixNodes.RmdirNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public PosixNodes.RmdirNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RmdirNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static PosixNodes.RmdirNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RmdirUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<PosixNodes.RmdirNode> getInstance() {
            if (rmdirNodeFactoryInstance == null) {
                rmdirNodeFactoryInstance = new RmdirNodeFactory();
            }
            return rmdirNodeFactoryInstance;
        }

        @GeneratedBy(value=PosixNodes.RmdirNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RmdirPolymorphicNode
        extends RmdirBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            RmdirPolymorphicNode(RmdirBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=PosixNodes.RmdirNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RmdirRubyStringNode
        extends RmdirBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RmdirRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            RmdirRubyStringNode(RmdirBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.rmdir(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.rmdir(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static PosixNodes.RmdirNode create0(PosixNodes.RmdirNode current) {
                return new RmdirRubyStringNode((RmdirBaseNode)current);
            }
        }

        @GeneratedBy(value=PosixNodes.RmdirNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RmdirUninitializedNode
        extends RmdirBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RmdirUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RmdirUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RmdirUninitializedNode(RmdirBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                RmdirBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RmdirBaseNode rootNode = (RmdirBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RmdirBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static PosixNodes.RmdirNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RmdirUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=PosixNodes.RmdirNode.class)
        private static abstract class RmdirBaseNode
        extends PosixNodes.RmdirNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RmdirBaseNode next0;

            RmdirBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RmdirBaseNode(RmdirBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                RmdirBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RmdirBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new RmdirUninitializedNode(this);
                    ((RmdirUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RmdirBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = RmdirBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (RmdirBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RmdirUninitializedNode(this), (Node)new RmdirPolymorphicNode(this), (DSLNode)((RmdirBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RmdirBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (RmdirBaseNode)RmdirRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((RmdirBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (RmdirBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=PosixNodes.ChdirNode.class)
    public static final class ChdirNodeFactory
    extends NodeFactoryBase<PosixNodes.ChdirNode> {
        private static ChdirNodeFactory chdirNodeFactoryInstance;

        private ChdirNodeFactory() {
            super(PosixNodes.ChdirNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public PosixNodes.ChdirNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ChdirNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static PosixNodes.ChdirNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ChdirUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<PosixNodes.ChdirNode> getInstance() {
            if (chdirNodeFactoryInstance == null) {
                chdirNodeFactoryInstance = new ChdirNodeFactory();
            }
            return chdirNodeFactoryInstance;
        }

        @GeneratedBy(value=PosixNodes.ChdirNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ChdirPolymorphicNode
        extends ChdirBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ChdirPolymorphicNode(ChdirBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=PosixNodes.ChdirNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ChdirRubyStringNode
        extends ChdirBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ChdirRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            ChdirRubyStringNode(ChdirBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.chdir(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.chdir(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static PosixNodes.ChdirNode create0(PosixNodes.ChdirNode current) {
                return new ChdirRubyStringNode((ChdirBaseNode)current);
            }
        }

        @GeneratedBy(value=PosixNodes.ChdirNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ChdirUninitializedNode
        extends ChdirBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ChdirUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ChdirUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ChdirUninitializedNode(ChdirBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ChdirBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ChdirBaseNode rootNode = (ChdirBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ChdirBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static PosixNodes.ChdirNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ChdirUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=PosixNodes.ChdirNode.class)
        private static abstract class ChdirBaseNode
        extends PosixNodes.ChdirNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ChdirBaseNode next0;

            ChdirBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ChdirBaseNode(ChdirBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ChdirBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ChdirBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ChdirUninitializedNode(this);
                    ((ChdirUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ChdirBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ChdirBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ChdirBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ChdirUninitializedNode(this), (Node)new ChdirPolymorphicNode(this), (DSLNode)((ChdirBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ChdirBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (ChdirBaseNode)ChdirRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ChdirBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ChdirBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=PosixNodes.MkdirNode.class)
    public static final class MkdirNodeFactory
    extends NodeFactoryBase<PosixNodes.MkdirNode> {
        private static MkdirNodeFactory mkdirNodeFactoryInstance;

        private MkdirNodeFactory() {
            super(PosixNodes.MkdirNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public PosixNodes.MkdirNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MkdirNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static PosixNodes.MkdirNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MkdirUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<PosixNodes.MkdirNode> getInstance() {
            if (mkdirNodeFactoryInstance == null) {
                mkdirNodeFactoryInstance = new MkdirNodeFactory();
            }
            return mkdirNodeFactoryInstance;
        }

        @GeneratedBy(value=PosixNodes.MkdirNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MkdirPolymorphicNode
        extends MkdirBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            MkdirPolymorphicNode(MkdirBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=PosixNodes.MkdirNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MkdirRubyStringNode
        extends MkdirBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MkdirRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE}, 0, 0);

            MkdirRubyStringNode(MkdirBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.mkdir(arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.mkdir(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static PosixNodes.MkdirNode create0(PosixNodes.MkdirNode current) {
                return new MkdirRubyStringNode((MkdirBaseNode)current);
            }
        }

        @GeneratedBy(value=PosixNodes.MkdirNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MkdirUninitializedNode
        extends MkdirBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MkdirUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MkdirUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MkdirUninitializedNode(MkdirBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                MkdirBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MkdirBaseNode rootNode = (MkdirBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MkdirBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static PosixNodes.MkdirNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MkdirUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=PosixNodes.MkdirNode.class)
        private static abstract class MkdirBaseNode
        extends PosixNodes.MkdirNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MkdirBaseNode next0;

            MkdirBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MkdirBaseNode(MkdirBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                MkdirBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MkdirBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new MkdirUninitializedNode(this);
                    ((MkdirUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MkdirBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = MkdirBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (MkdirBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MkdirUninitializedNode(this), (Node)new MkdirPolymorphicNode(this), (DSLNode)((MkdirBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MkdirBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    return (MkdirBaseNode)MkdirRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MkdirBaseNode otherCast = (MkdirBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (MkdirBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=PosixNodes.UnlinkNode.class)
    public static final class UnlinkNodeFactory
    extends NodeFactoryBase<PosixNodes.UnlinkNode> {
        private static UnlinkNodeFactory unlinkNodeFactoryInstance;

        private UnlinkNodeFactory() {
            super(PosixNodes.UnlinkNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public PosixNodes.UnlinkNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UnlinkNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static PosixNodes.UnlinkNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return UnlinkUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<PosixNodes.UnlinkNode> getInstance() {
            if (unlinkNodeFactoryInstance == null) {
                unlinkNodeFactoryInstance = new UnlinkNodeFactory();
            }
            return unlinkNodeFactoryInstance;
        }

        @GeneratedBy(value=PosixNodes.UnlinkNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class UnlinkPolymorphicNode
        extends UnlinkBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            UnlinkPolymorphicNode(UnlinkBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=PosixNodes.UnlinkNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UnlinkRubyStringNode
        extends UnlinkBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UnlinkRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            UnlinkRubyStringNode(UnlinkBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.unlink(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.unlink(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static PosixNodes.UnlinkNode create0(PosixNodes.UnlinkNode current) {
                return new UnlinkRubyStringNode((UnlinkBaseNode)current);
            }
        }

        @GeneratedBy(value=PosixNodes.UnlinkNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class UnlinkUninitializedNode
        extends UnlinkBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UnlinkUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            UnlinkUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            UnlinkUninitializedNode(UnlinkBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                UnlinkBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    UnlinkBaseNode rootNode = (UnlinkBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((UnlinkBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static PosixNodes.UnlinkNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new UnlinkUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=PosixNodes.UnlinkNode.class)
        private static abstract class UnlinkBaseNode
        extends PosixNodes.UnlinkNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected UnlinkBaseNode next0;

            UnlinkBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            UnlinkBaseNode(UnlinkBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                UnlinkBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                UnlinkBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new UnlinkUninitializedNode(this);
                    ((UnlinkUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (UnlinkBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = UnlinkBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (UnlinkBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new UnlinkUninitializedNode(this), (Node)new UnlinkPolymorphicNode(this), (DSLNode)((UnlinkBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final UnlinkBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (UnlinkBaseNode)UnlinkRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((UnlinkBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (UnlinkBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=PosixNodes.MemsetNode.class)
    public static final class MemsetNodeFactory
    extends NodeFactoryBase<PosixNodes.MemsetNode> {
        private static MemsetNodeFactory memsetNodeFactoryInstance;

        private MemsetNodeFactory() {
            super(PosixNodes.MemsetNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public PosixNodes.MemsetNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MemsetNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static PosixNodes.MemsetNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MemsetUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<PosixNodes.MemsetNode> getInstance() {
            if (memsetNodeFactoryInstance == null) {
                memsetNodeFactoryInstance = new MemsetNodeFactory();
            }
            return memsetNodeFactoryInstance;
        }

        @GeneratedBy(value=PosixNodes.MemsetNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MemsetPolymorphicNode
        extends MemsetBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            MemsetPolymorphicNode(MemsetBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments2Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments2PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[2].executeIntegerFixnum(frameValue)) : (this.arguments2PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[2].executeLongFixnum(frameValue)) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=PosixNodes.MemsetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MemsetRubyBasicObjectLongNode
        extends MemsetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MemsetRubyBasicObjectLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, Integer.TYPE, Long.TYPE}, 0, 0);

            MemsetRubyBasicObjectLongNode(MemsetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments2Value;
                int arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof long");
                }
                return super.memset(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isLong(arguments2Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    long arguments2ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments2Value);
                    return super.memset(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static PosixNodes.MemsetNode create0(PosixNodes.MemsetNode current) {
                return new MemsetRubyBasicObjectLongNode((MemsetBaseNode)current);
            }
        }

        @GeneratedBy(value=PosixNodes.MemsetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MemsetRubyBasicObjectIntNode
        extends MemsetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MemsetRubyBasicObjectIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            MemsetRubyBasicObjectIntNode(MemsetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments2Value;
                int arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                return super.memset(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    return super.memset(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static PosixNodes.MemsetNode create0(PosixNodes.MemsetNode current) {
                return new MemsetRubyBasicObjectIntNode((MemsetBaseNode)current);
            }
        }

        @GeneratedBy(value=PosixNodes.MemsetNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MemsetUninitializedNode
        extends MemsetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MemsetUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MemsetUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MemsetUninitializedNode(MemsetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected RubyBasicObject executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                MemsetBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MemsetBaseNode rootNode = (MemsetBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MemsetBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static PosixNodes.MemsetNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MemsetUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=PosixNodes.MemsetNode.class)
        private static abstract class MemsetBaseNode
        extends PosixNodes.MemsetNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MemsetBaseNode next0;

            MemsetBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MemsetBaseNode(MemsetBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyBasicObject executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final RubyBasicObject rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                MemsetBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MemsetBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new MemsetUninitializedNode(this);
                    ((MemsetUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MemsetBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = MemsetBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (MemsetBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MemsetUninitializedNode(this), (Node)new MemsetPolymorphicNode(this), (DSLNode)((MemsetBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MemsetBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                        return (MemsetBaseNode)MemsetRubyBasicObjectIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(arguments2Value)) {
                        return (MemsetBaseNode)MemsetRubyBasicObjectLongNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    MemsetBaseNode otherCast = (MemsetBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (MemsetBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=PosixNodes.GetUIDNode.class)
    public static final class GetUIDNodeFactory
    extends NodeFactoryBase<PosixNodes.GetUIDNode> {
        private static GetUIDNodeFactory getUIDNodeFactoryInstance;

        private GetUIDNodeFactory() {
            super(PosixNodes.GetUIDNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public PosixNodes.GetUIDNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetUIDNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static PosixNodes.GetUIDNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GetUIDDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<PosixNodes.GetUIDNode> getInstance() {
            if (getUIDNodeFactoryInstance == null) {
                getUIDNodeFactoryInstance = new GetUIDNodeFactory();
            }
            return getUIDNodeFactoryInstance;
        }

        @GeneratedBy(value=PosixNodes.GetUIDNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetUIDDefaultNode
        extends GetUIDBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetUIDDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            GetUIDDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.getUID();
            }

            static PosixNodes.GetUIDNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GetUIDDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=PosixNodes.GetUIDNode.class)
        private static abstract class GetUIDBaseNode
        extends PosixNodes.GetUIDNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            GetUIDBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=PosixNodes.GetGroupsNode.class)
    public static final class GetGroupsNodeFactory
    extends NodeFactoryBase<PosixNodes.GetGroupsNode> {
        private static GetGroupsNodeFactory getGroupsNodeFactoryInstance;

        private GetGroupsNodeFactory() {
            super(PosixNodes.GetGroupsNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public PosixNodes.GetGroupsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetGroupsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static PosixNodes.GetGroupsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GetGroupsUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<PosixNodes.GetGroupsNode> getInstance() {
            if (getGroupsNodeFactoryInstance == null) {
                getGroupsNodeFactoryInstance = new GetGroupsNodeFactory();
            }
            return getGroupsNodeFactoryInstance;
        }

        @GeneratedBy(value=PosixNodes.GetGroupsNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class GetGroupsPolymorphicNode
        extends GetGroupsBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            GetGroupsPolymorphicNode(GetGroupsBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=PosixNodes.GetGroupsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetGroupsIntNode
        extends GetGroupsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetGroupsIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, RubyBasicObject.class}, 0, 0);

            GetGroupsIntNode(GetGroupsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject arguments1Value;
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof int");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                return super.getGroups(arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    return super.getGroups(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static PosixNodes.GetGroupsNode create0(PosixNodes.GetGroupsNode current) {
                return new GetGroupsIntNode((GetGroupsBaseNode)current);
            }
        }

        @GeneratedBy(value=PosixNodes.GetGroupsNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class GetGroupsUninitializedNode
        extends GetGroupsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetGroupsUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            GetGroupsUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            GetGroupsUninitializedNode(GetGroupsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                GetGroupsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    GetGroupsBaseNode rootNode = (GetGroupsBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((GetGroupsBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static PosixNodes.GetGroupsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GetGroupsUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=PosixNodes.GetGroupsNode.class)
        private static abstract class GetGroupsBaseNode
        extends PosixNodes.GetGroupsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected GetGroupsBaseNode next0;

            GetGroupsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            GetGroupsBaseNode(GetGroupsBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                GetGroupsBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                GetGroupsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new GetGroupsUninitializedNode(this);
                    ((GetGroupsUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (GetGroupsBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = GetGroupsBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (GetGroupsBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new GetGroupsUninitializedNode(this), (Node)new GetGroupsPolymorphicNode(this), (DSLNode)((GetGroupsBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final GetGroupsBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    return (GetGroupsBaseNode)GetGroupsIntNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    GetGroupsBaseNode otherCast = (GetGroupsBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (GetGroupsBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=PosixNodes.GetGIDNode.class)
    public static final class GetGIDNodeFactory
    extends NodeFactoryBase<PosixNodes.GetGIDNode> {
        private static GetGIDNodeFactory getGIDNodeFactoryInstance;

        private GetGIDNodeFactory() {
            super(PosixNodes.GetGIDNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public PosixNodes.GetGIDNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetGIDNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static PosixNodes.GetGIDNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GetGIDDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<PosixNodes.GetGIDNode> getInstance() {
            if (getGIDNodeFactoryInstance == null) {
                getGIDNodeFactoryInstance = new GetGIDNodeFactory();
            }
            return getGIDNodeFactoryInstance;
        }

        @GeneratedBy(value=PosixNodes.GetGIDNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetGIDDefaultNode
        extends GetGIDBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetGIDDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            GetGIDDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.getGID();
            }

            static PosixNodes.GetGIDNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GetGIDDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=PosixNodes.GetGIDNode.class)
        private static abstract class GetGIDBaseNode
        extends PosixNodes.GetGIDNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            GetGIDBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=PosixNodes.GetEUIDNode.class)
    public static final class GetEUIDNodeFactory
    extends NodeFactoryBase<PosixNodes.GetEUIDNode> {
        private static GetEUIDNodeFactory getEUIDNodeFactoryInstance;

        private GetEUIDNodeFactory() {
            super(PosixNodes.GetEUIDNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public PosixNodes.GetEUIDNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetEUIDNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static PosixNodes.GetEUIDNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GetEUIDDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<PosixNodes.GetEUIDNode> getInstance() {
            if (getEUIDNodeFactoryInstance == null) {
                getEUIDNodeFactoryInstance = new GetEUIDNodeFactory();
            }
            return getEUIDNodeFactoryInstance;
        }

        @GeneratedBy(value=PosixNodes.GetEUIDNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetEUIDDefaultNode
        extends GetEUIDBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetEUIDDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            GetEUIDDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.getEUID();
            }

            static PosixNodes.GetEUIDNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GetEUIDDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=PosixNodes.GetEUIDNode.class)
        private static abstract class GetEUIDBaseNode
        extends PosixNodes.GetEUIDNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            GetEUIDBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=PosixNodes.GetEGIDNode.class)
    public static final class GetEGIDNodeFactory
    extends NodeFactoryBase<PosixNodes.GetEGIDNode> {
        private static GetEGIDNodeFactory getEGIDNodeFactoryInstance;

        private GetEGIDNodeFactory() {
            super(PosixNodes.GetEGIDNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public PosixNodes.GetEGIDNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetEGIDNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static PosixNodes.GetEGIDNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GetEGIDDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<PosixNodes.GetEGIDNode> getInstance() {
            if (getEGIDNodeFactoryInstance == null) {
                getEGIDNodeFactoryInstance = new GetEGIDNodeFactory();
            }
            return getEGIDNodeFactoryInstance;
        }

        @GeneratedBy(value=PosixNodes.GetEGIDNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetEGIDDefaultNode
        extends GetEGIDBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetEGIDDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            GetEGIDDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.getEGID();
            }

            static PosixNodes.GetEGIDNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GetEGIDDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=PosixNodes.GetEGIDNode.class)
        private static abstract class GetEGIDBaseNode
        extends PosixNodes.GetEGIDNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            GetEGIDBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }
}

