/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import java.nio.charset.StandardCharsets;
import jnr.constants.platform.Fcntl;
import org.jruby.platform.Platform;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.rubinius.PointerPrimitiveNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.util.unsafe.UnsafeHolder;
import sun.misc.Unsafe;

@CoreClass(name="Rubinius::FFI::Platform::POSIX")
public abstract class PosixNodes {

    @CoreMethod(names={"symlink"}, isModuleFunction=true, required=2)
    public static abstract class SymlinkNode
    extends CoreMethodNode {
        public SymlinkNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SymlinkNode(SymlinkNode prev) {
            super(prev);
        }

        @Specialization
        public int symlink(RubyString first, RubyString second) {
            return this.posix().symlink(first.toString(), second.toString());
        }
    }

    @CoreMethod(names={"isatty"}, isModuleFunction=true, required=1)
    public static abstract class IsATTYNode
    extends CoreMethodNode {
        public IsATTYNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IsATTYNode(IsATTYNode prev) {
            super(prev);
        }

        @Specialization
        public int isATTY(int fd) {
            return this.posix().libc().isatty(fd);
        }
    }

    @CoreMethod(names={"fcntl"}, isModuleFunction=true, required=3)
    public static abstract class FcntlNode
    extends CoreMethodNode {
        public FcntlNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public FcntlNode(FcntlNode prev) {
            super(prev);
        }

        @Specialization
        public int fcntl(int fd, int fcntl, RubyNilClass nil) {
            return this.posix().fcntl(fd, Fcntl.valueOf((long)fcntl));
        }

        @Specialization
        public int fcntl(int fd, int fcntl, int arg) {
            return this.posix().fcntlInt(fd, Fcntl.valueOf((long)fcntl), arg);
        }
    }

    @CoreMethod(names={"errno"}, isModuleFunction=true)
    public static abstract class ErrnoNode
    extends CoreMethodNode {
        public ErrnoNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ErrnoNode(ErrnoNode prev) {
            super(prev);
        }

        @Specialization
        public int errno() {
            return this.posix().errno();
        }
    }

    @CoreMethod(names={"getcwd"}, isModuleFunction=true, required=2)
    public static abstract class GetcwdNode
    extends PointerPrimitiveNodes.ReadAddressPrimitiveNode {
        public GetcwdNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GetcwdNode(GetcwdNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString getcwd(RubyString resultPath, int maxSize) {
            String path = this.getContext().getRuntime().getCurrentDirectory();
            resultPath.getByteList().replace(path.getBytes(StandardCharsets.UTF_8));
            return resultPath;
        }
    }

    @CoreMethod(names={"rmdir"}, isModuleFunction=true, required=1)
    public static abstract class RmdirNode
    extends PointerPrimitiveNodes.ReadAddressPrimitiveNode {
        public RmdirNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RmdirNode(RmdirNode prev) {
            super(prev);
        }

        @Specialization
        public int rmdir(RubyString path) {
            return this.posix().rmdir(path.toString());
        }
    }

    @CoreMethod(names={"chdir"}, isModuleFunction=true, required=1)
    public static abstract class ChdirNode
    extends PointerPrimitiveNodes.ReadAddressPrimitiveNode {
        public ChdirNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ChdirNode(ChdirNode prev) {
            super(prev);
        }

        @Specialization
        public int chdir(RubyString path) {
            String pathString = path.toString();
            int result = this.posix().chdir(pathString);
            if (result == 0) {
                this.getContext().getRuntime().setCurrentDirectory(pathString);
            }
            return result;
        }
    }

    @CoreMethod(names={"mkdir"}, isModuleFunction=true, required=2)
    public static abstract class MkdirNode
    extends PointerPrimitiveNodes.ReadAddressPrimitiveNode {
        public MkdirNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MkdirNode(MkdirNode prev) {
            super(prev);
        }

        @Specialization
        public int mkdir(RubyString path, int mode) {
            return this.posix().mkdir(path.toString(), mode);
        }
    }

    @CoreMethod(names={"unlink"}, isModuleFunction=true, required=1)
    public static abstract class UnlinkNode
    extends PointerPrimitiveNodes.ReadAddressPrimitiveNode {
        public UnlinkNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public UnlinkNode(UnlinkNode prev) {
            super(prev);
        }

        @Specialization
        public int unlink(RubyString path) {
            return this.posix().unlink((CharSequence)path.toString());
        }
    }

    @CoreMethod(names={"memset"}, isModuleFunction=true, required=3)
    public static abstract class MemsetNode
    extends PointerPrimitiveNodes.ReadAddressPrimitiveNode {
        public MemsetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MemsetNode(MemsetNode prev) {
            super(prev);
        }

        @Specialization
        public RubyBasicObject memset(RubyBasicObject pointer, int c, int length) {
            return this.memset(pointer, c, (long)length);
        }

        @Specialization
        public RubyBasicObject memset(RubyBasicObject pointer, int c, long length) {
            long address = this.getAddress(pointer);
            UnsafeHolder.U.setMemory(address, length, (byte)c);
            return pointer;
        }
    }

    @CoreMethod(names={"getuid"}, isModuleFunction=true)
    public static abstract class GetUIDNode
    extends CoreMethodNode {
        public GetUIDNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GetUIDNode(GetUIDNode prev) {
            super(prev);
        }

        @Specialization
        public int getUID() {
            return this.posix().getuid();
        }
    }

    @CoreMethod(names={"getgroups"}, isModuleFunction=true, required=2)
    public static abstract class GetGroupsNode
    extends PointerPrimitiveNodes.ReadAddressPrimitiveNode {
        public GetGroupsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GetGroupsNode(GetGroupsNode prev) {
            super(prev);
        }

        @Specialization
        public int getGroups(int max, RubyBasicObject pointer) {
            long[] groups = Platform.getPlatform().getGroups(null);
            long address = this.getAddress(pointer);
            for (int n = 0; n < groups.length && n < max; ++n) {
                UnsafeHolder.U.putInt(address + (long)(n * Unsafe.ARRAY_LONG_INDEX_SCALE), (int)groups[n]);
            }
            return groups.length;
        }
    }

    @CoreMethod(names={"getgid"}, isModuleFunction=true)
    public static abstract class GetGIDNode
    extends CoreMethodNode {
        public GetGIDNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GetGIDNode(GetGIDNode prev) {
            super(prev);
        }

        @Specialization
        public int getGID() {
            return this.posix().getgid();
        }
    }

    @CoreMethod(names={"geteuid"}, isModuleFunction=true)
    public static abstract class GetEUIDNode
    extends CoreMethodNode {
        public GetEUIDNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GetEUIDNode(GetEUIDNode prev) {
            super(prev);
        }

        @Specialization
        public int getEUID() {
            return this.posix().geteuid();
        }
    }

    @CoreMethod(names={"getegid"}, isModuleFunction=true)
    public static abstract class GetEGIDNode
    extends CoreMethodNode {
        public GetEGIDNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GetEGIDNode(GetEGIDNode prev) {
            super(prev);
        }

        @Specialization
        public int getEGID() {
            return this.posix().getegid();
        }
    }
}

