/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.rubinius.IOPrimitiveNodes;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyString;

@GeneratedBy(value=IOPrimitiveNodes.class)
public final class IOPrimitiveNodesFactory {
    public static List<NodeFactory<? extends RubiniusPrimitiveNode>> getFactories() {
        return Arrays.asList(IOAllocatePrimitiveNodeFactory.getInstance(), IOConnectPipeNodeFactory.getInstance(), IOOpenPrimitiveNodeFactory.getInstance(), IOFNMatchPrimitiveNodeFactory.getInstance(), IOEnsureOpenPrimitiveNodeFactory.getInstance(), IOWritePrimitiveNodeFactory.getInstance(), IOClosePrimitiveNodeFactory.getInstance(), IOSeekPrimitiveNodeFactory.getInstance());
    }

    @GeneratedBy(value=IOPrimitiveNodes.IOSeekPrimitiveNode.class)
    public static final class IOSeekPrimitiveNodeFactory
    extends NodeFactoryBase<IOPrimitiveNodes.IOSeekPrimitiveNode> {
        private static IOSeekPrimitiveNodeFactory iOSeekPrimitiveNodeFactoryInstance;

        private IOSeekPrimitiveNodeFactory() {
            super(IOPrimitiveNodes.IOSeekPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public IOPrimitiveNodes.IOSeekPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IOSeekPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static IOPrimitiveNodes.IOSeekPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IOSeekPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<IOPrimitiveNodes.IOSeekPrimitiveNode> getInstance() {
            if (iOSeekPrimitiveNodeFactoryInstance == null) {
                iOSeekPrimitiveNodeFactoryInstance = new IOSeekPrimitiveNodeFactory();
            }
            return iOSeekPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOSeekPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IOSeekPrimitivePolymorphicNode
        extends IOSeekPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            IOSeekPrimitivePolymorphicNode(IOSeekPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOSeekPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IOSeekPrimitiveRubyBasicObjectIntNode
        extends IOSeekPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IOSeekPrimitiveRubyBasicObjectIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            IOSeekPrimitiveRubyBasicObjectIntNode(IOSeekPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments2Value;
                int arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                return super.seek(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    return super.seek(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static IOPrimitiveNodes.IOSeekPrimitiveNode create0(IOPrimitiveNodes.IOSeekPrimitiveNode current) {
                return new IOSeekPrimitiveRubyBasicObjectIntNode((IOSeekPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOSeekPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IOSeekPrimitiveUninitializedNode
        extends IOSeekPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IOSeekPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IOSeekPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IOSeekPrimitiveUninitializedNode(IOSeekPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                IOSeekPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IOSeekPrimitiveBaseNode rootNode = (IOSeekPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((IOSeekPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static IOPrimitiveNodes.IOSeekPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IOSeekPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOSeekPrimitiveNode.class)
        private static abstract class IOSeekPrimitiveBaseNode
        extends IOPrimitiveNodes.IOSeekPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IOSeekPrimitiveBaseNode next0;

            IOSeekPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IOSeekPrimitiveBaseNode(IOSeekPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                IOSeekPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IOSeekPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new IOSeekPrimitiveUninitializedNode(this);
                    ((IOSeekPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (IOSeekPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = IOSeekPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (IOSeekPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new IOSeekPrimitiveUninitializedNode(this), (Node)new IOSeekPrimitivePolymorphicNode(this), (DSLNode)((IOSeekPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IOSeekPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    return (IOSeekPrimitiveBaseNode)IOSeekPrimitiveRubyBasicObjectIntNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    IOSeekPrimitiveBaseNode otherCast = (IOSeekPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (IOSeekPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=IOPrimitiveNodes.IOClosePrimitiveNode.class)
    public static final class IOClosePrimitiveNodeFactory
    extends NodeFactoryBase<IOPrimitiveNodes.IOClosePrimitiveNode> {
        private static IOClosePrimitiveNodeFactory iOClosePrimitiveNodeFactoryInstance;

        private IOClosePrimitiveNodeFactory() {
            super(IOPrimitiveNodes.IOClosePrimitiveNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public IOPrimitiveNodes.IOClosePrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IOClosePrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static IOPrimitiveNodes.IOClosePrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IOClosePrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<IOPrimitiveNodes.IOClosePrimitiveNode> getInstance() {
            if (iOClosePrimitiveNodeFactoryInstance == null) {
                iOClosePrimitiveNodeFactoryInstance = new IOClosePrimitiveNodeFactory();
            }
            return iOClosePrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOClosePrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IOClosePrimitivePolymorphicNode
        extends IOClosePrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            IOClosePrimitivePolymorphicNode(IOClosePrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOClosePrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IOClosePrimitiveRubyBasicObjectNode
        extends IOClosePrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IOClosePrimitiveRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

            IOClosePrimitiveRubyBasicObjectNode(IOClosePrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBasicObject");
                }
                return super.close(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    return super.close(frameValue, arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static IOPrimitiveNodes.IOClosePrimitiveNode create0(IOPrimitiveNodes.IOClosePrimitiveNode current) {
                return new IOClosePrimitiveRubyBasicObjectNode((IOClosePrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOClosePrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IOClosePrimitiveUninitializedNode
        extends IOClosePrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IOClosePrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IOClosePrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IOClosePrimitiveUninitializedNode(IOClosePrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                IOClosePrimitiveBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IOClosePrimitiveBaseNode rootNode = (IOClosePrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((IOClosePrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static IOPrimitiveNodes.IOClosePrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IOClosePrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOClosePrimitiveNode.class)
        private static abstract class IOClosePrimitiveBaseNode
        extends IOPrimitiveNodes.IOClosePrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IOClosePrimitiveBaseNode next0;

            IOClosePrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IOClosePrimitiveBaseNode(IOClosePrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                IOClosePrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IOClosePrimitiveBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new IOClosePrimitiveUninitializedNode(this);
                    ((IOClosePrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (IOClosePrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = IOClosePrimitiveBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (IOClosePrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new IOClosePrimitiveUninitializedNode(this), (Node)new IOClosePrimitivePolymorphicNode(this), (DSLNode)((IOClosePrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IOClosePrimitiveBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    return (IOClosePrimitiveBaseNode)IOClosePrimitiveRubyBasicObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((IOClosePrimitiveBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (IOClosePrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=IOPrimitiveNodes.IOWritePrimitiveNode.class)
    public static final class IOWritePrimitiveNodeFactory
    extends NodeFactoryBase<IOPrimitiveNodes.IOWritePrimitiveNode> {
        private static IOWritePrimitiveNodeFactory iOWritePrimitiveNodeFactoryInstance;

        private IOWritePrimitiveNodeFactory() {
            super(IOPrimitiveNodes.IOWritePrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public IOPrimitiveNodes.IOWritePrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IOWritePrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static IOPrimitiveNodes.IOWritePrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IOWritePrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<IOPrimitiveNodes.IOWritePrimitiveNode> getInstance() {
            if (iOWritePrimitiveNodeFactoryInstance == null) {
                iOWritePrimitiveNodeFactoryInstance = new IOWritePrimitiveNodeFactory();
            }
            return iOWritePrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOWritePrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IOWritePrimitivePolymorphicNode
        extends IOWritePrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            IOWritePrimitivePolymorphicNode(IOWritePrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOWritePrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IOWritePrimitiveRubyBasicObjectNode
        extends IOWritePrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IOWritePrimitiveRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, RubyString.class}, 0, 0);

            IOWritePrimitiveRubyBasicObjectNode(IOWritePrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.write(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.write(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static IOPrimitiveNodes.IOWritePrimitiveNode create0(IOPrimitiveNodes.IOWritePrimitiveNode current) {
                return new IOWritePrimitiveRubyBasicObjectNode((IOWritePrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOWritePrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IOWritePrimitiveUninitializedNode
        extends IOWritePrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IOWritePrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IOWritePrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IOWritePrimitiveUninitializedNode(IOWritePrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                IOWritePrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IOWritePrimitiveBaseNode rootNode = (IOWritePrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((IOWritePrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static IOPrimitiveNodes.IOWritePrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IOWritePrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOWritePrimitiveNode.class)
        private static abstract class IOWritePrimitiveBaseNode
        extends IOPrimitiveNodes.IOWritePrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IOWritePrimitiveBaseNode next0;

            IOWritePrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IOWritePrimitiveBaseNode(IOWritePrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                IOWritePrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IOWritePrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new IOWritePrimitiveUninitializedNode(this);
                    ((IOWritePrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (IOWritePrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = IOWritePrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (IOWritePrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new IOWritePrimitiveUninitializedNode(this), (Node)new IOWritePrimitivePolymorphicNode(this), (DSLNode)((IOWritePrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IOWritePrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    return (IOWritePrimitiveBaseNode)IOWritePrimitiveRubyBasicObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    IOWritePrimitiveBaseNode otherCast = (IOWritePrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (IOWritePrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=IOPrimitiveNodes.IOEnsureOpenPrimitiveNode.class)
    public static final class IOEnsureOpenPrimitiveNodeFactory
    extends NodeFactoryBase<IOPrimitiveNodes.IOEnsureOpenPrimitiveNode> {
        private static IOEnsureOpenPrimitiveNodeFactory iOEnsureOpenPrimitiveNodeFactoryInstance;

        private IOEnsureOpenPrimitiveNodeFactory() {
            super(IOPrimitiveNodes.IOEnsureOpenPrimitiveNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public IOPrimitiveNodes.IOEnsureOpenPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IOEnsureOpenPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static IOPrimitiveNodes.IOEnsureOpenPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IOEnsureOpenPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<IOPrimitiveNodes.IOEnsureOpenPrimitiveNode> getInstance() {
            if (iOEnsureOpenPrimitiveNodeFactoryInstance == null) {
                iOEnsureOpenPrimitiveNodeFactoryInstance = new IOEnsureOpenPrimitiveNodeFactory();
            }
            return iOEnsureOpenPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOEnsureOpenPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IOEnsureOpenPrimitivePolymorphicNode
        extends IOEnsureOpenPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            IOEnsureOpenPrimitivePolymorphicNode(IOEnsureOpenPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOEnsureOpenPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IOEnsureOpenPrimitiveRubyBasicObjectNode
        extends IOEnsureOpenPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IOEnsureOpenPrimitiveRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

            IOEnsureOpenPrimitiveRubyBasicObjectNode(IOEnsureOpenPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBasicObject");
                }
                return super.ensureOpen(arguments0Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    return super.ensureOpen(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static IOPrimitiveNodes.IOEnsureOpenPrimitiveNode create0(IOPrimitiveNodes.IOEnsureOpenPrimitiveNode current) {
                return new IOEnsureOpenPrimitiveRubyBasicObjectNode((IOEnsureOpenPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOEnsureOpenPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IOEnsureOpenPrimitiveUninitializedNode
        extends IOEnsureOpenPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IOEnsureOpenPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IOEnsureOpenPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IOEnsureOpenPrimitiveUninitializedNode(IOEnsureOpenPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyNilClass executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                IOEnsureOpenPrimitiveBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IOEnsureOpenPrimitiveBaseNode rootNode = (IOEnsureOpenPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((IOEnsureOpenPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static IOPrimitiveNodes.IOEnsureOpenPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IOEnsureOpenPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOEnsureOpenPrimitiveNode.class)
        private static abstract class IOEnsureOpenPrimitiveBaseNode
        extends IOPrimitiveNodes.IOEnsureOpenPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IOEnsureOpenPrimitiveBaseNode next0;

            IOEnsureOpenPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IOEnsureOpenPrimitiveBaseNode(IOEnsureOpenPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyNilClass executeChained0(VirtualFrame var1, Object var2);

            protected final RubyNilClass rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                IOEnsureOpenPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IOEnsureOpenPrimitiveBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new IOEnsureOpenPrimitiveUninitializedNode(this);
                    ((IOEnsureOpenPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (IOEnsureOpenPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = IOEnsureOpenPrimitiveBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (IOEnsureOpenPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new IOEnsureOpenPrimitiveUninitializedNode(this), (Node)new IOEnsureOpenPrimitivePolymorphicNode(this), (DSLNode)((IOEnsureOpenPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IOEnsureOpenPrimitiveBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    return (IOEnsureOpenPrimitiveBaseNode)IOEnsureOpenPrimitiveRubyBasicObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((IOEnsureOpenPrimitiveBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (IOEnsureOpenPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=IOPrimitiveNodes.IOFNMatchPrimitiveNode.class)
    public static final class IOFNMatchPrimitiveNodeFactory
    extends NodeFactoryBase<IOPrimitiveNodes.IOFNMatchPrimitiveNode> {
        private static IOFNMatchPrimitiveNodeFactory iOFNMatchPrimitiveNodeFactoryInstance;

        private IOFNMatchPrimitiveNodeFactory() {
            super(IOPrimitiveNodes.IOFNMatchPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public IOPrimitiveNodes.IOFNMatchPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IOFNMatchPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static IOPrimitiveNodes.IOFNMatchPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IOFNMatchPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<IOPrimitiveNodes.IOFNMatchPrimitiveNode> getInstance() {
            if (iOFNMatchPrimitiveNodeFactoryInstance == null) {
                iOFNMatchPrimitiveNodeFactoryInstance = new IOFNMatchPrimitiveNodeFactory();
            }
            return iOFNMatchPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOFNMatchPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IOFNMatchPrimitivePolymorphicNode
        extends IOFNMatchPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            IOFNMatchPrimitivePolymorphicNode(IOFNMatchPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOFNMatchPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IOFNMatchPrimitiveRubyStringIntNode
        extends IOFNMatchPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IOFNMatchPrimitiveRubyStringIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyString.class, Integer.TYPE}, 0, 0);

            IOFNMatchPrimitiveRubyStringIntNode(IOFNMatchPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments2Value;
                RubyString arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                return super.fnmatch(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    return super.fnmatch(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static IOPrimitiveNodes.IOFNMatchPrimitiveNode create0(IOPrimitiveNodes.IOFNMatchPrimitiveNode current) {
                return new IOFNMatchPrimitiveRubyStringIntNode((IOFNMatchPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOFNMatchPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IOFNMatchPrimitiveUninitializedNode
        extends IOFNMatchPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IOFNMatchPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IOFNMatchPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IOFNMatchPrimitiveUninitializedNode(IOFNMatchPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                IOFNMatchPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IOFNMatchPrimitiveBaseNode rootNode = (IOFNMatchPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((IOFNMatchPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static IOPrimitiveNodes.IOFNMatchPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IOFNMatchPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOFNMatchPrimitiveNode.class)
        private static abstract class IOFNMatchPrimitiveBaseNode
        extends IOPrimitiveNodes.IOFNMatchPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IOFNMatchPrimitiveBaseNode next0;

            IOFNMatchPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IOFNMatchPrimitiveBaseNode(IOFNMatchPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                IOFNMatchPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IOFNMatchPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new IOFNMatchPrimitiveUninitializedNode(this);
                    ((IOFNMatchPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (IOFNMatchPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = IOFNMatchPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (IOFNMatchPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new IOFNMatchPrimitiveUninitializedNode(this), (Node)new IOFNMatchPrimitivePolymorphicNode(this), (DSLNode)((IOFNMatchPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IOFNMatchPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    return (IOFNMatchPrimitiveBaseNode)IOFNMatchPrimitiveRubyStringIntNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    IOFNMatchPrimitiveBaseNode otherCast = (IOFNMatchPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (IOFNMatchPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=IOPrimitiveNodes.IOOpenPrimitiveNode.class)
    public static final class IOOpenPrimitiveNodeFactory
    extends NodeFactoryBase<IOPrimitiveNodes.IOOpenPrimitiveNode> {
        private static IOOpenPrimitiveNodeFactory iOOpenPrimitiveNodeFactoryInstance;

        private IOOpenPrimitiveNodeFactory() {
            super(IOPrimitiveNodes.IOOpenPrimitiveNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public IOPrimitiveNodes.IOOpenPrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IOOpenPrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static IOPrimitiveNodes.IOOpenPrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IOOpenPrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<IOPrimitiveNodes.IOOpenPrimitiveNode> getInstance() {
            if (iOOpenPrimitiveNodeFactoryInstance == null) {
                iOOpenPrimitiveNodeFactoryInstance = new IOOpenPrimitiveNodeFactory();
            }
            return iOOpenPrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOOpenPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IOOpenPrimitivePolymorphicNode
        extends IOOpenPrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            IOOpenPrimitivePolymorphicNode(IOOpenPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOOpenPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IOOpenPrimitiveRubyStringIntNode
        extends IOOpenPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IOOpenPrimitiveRubyStringIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            IOOpenPrimitiveRubyStringIntNode(IOOpenPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments2Value;
                int arguments1Value;
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyString");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                return super.open(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    return super.open(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static IOPrimitiveNodes.IOOpenPrimitiveNode create0(IOPrimitiveNodes.IOOpenPrimitiveNode current) {
                return new IOOpenPrimitiveRubyStringIntNode((IOOpenPrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOOpenPrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IOOpenPrimitiveUninitializedNode
        extends IOOpenPrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IOOpenPrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IOOpenPrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IOOpenPrimitiveUninitializedNode(IOOpenPrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                IOOpenPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IOOpenPrimitiveBaseNode rootNode = (IOOpenPrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((IOOpenPrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static IOPrimitiveNodes.IOOpenPrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IOOpenPrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOOpenPrimitiveNode.class)
        private static abstract class IOOpenPrimitiveBaseNode
        extends IOPrimitiveNodes.IOOpenPrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IOOpenPrimitiveBaseNode next0;

            IOOpenPrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IOOpenPrimitiveBaseNode(IOOpenPrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                IOOpenPrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IOOpenPrimitiveBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new IOOpenPrimitiveUninitializedNode(this);
                    ((IOOpenPrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (IOOpenPrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = IOOpenPrimitiveBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (IOOpenPrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new IOOpenPrimitiveUninitializedNode(this), (Node)new IOOpenPrimitivePolymorphicNode(this), (DSLNode)((IOOpenPrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IOOpenPrimitiveBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    return (IOOpenPrimitiveBaseNode)IOOpenPrimitiveRubyStringIntNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    IOOpenPrimitiveBaseNode otherCast = (IOOpenPrimitiveBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (IOOpenPrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=IOPrimitiveNodes.IOConnectPipeNode.class)
    public static final class IOConnectPipeNodeFactory
    extends NodeFactoryBase<IOPrimitiveNodes.IOConnectPipeNode> {
        private static IOConnectPipeNodeFactory iOConnectPipeNodeFactoryInstance;

        private IOConnectPipeNodeFactory() {
            super(IOPrimitiveNodes.IOConnectPipeNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public IOPrimitiveNodes.IOConnectPipeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IOConnectPipeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static IOPrimitiveNodes.IOConnectPipeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IOConnectPipeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<IOPrimitiveNodes.IOConnectPipeNode> getInstance() {
            if (iOConnectPipeNodeFactoryInstance == null) {
                iOConnectPipeNodeFactoryInstance = new IOConnectPipeNodeFactory();
            }
            return iOConnectPipeNodeFactoryInstance;
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOConnectPipeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IOConnectPipePolymorphicNode
        extends IOConnectPipeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            IOConnectPipePolymorphicNode(IOConnectPipeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOConnectPipeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IOConnectPipeRubyBasicObjectNode
        extends IOConnectPipeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IOConnectPipeRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, RubyBasicObject.class}, 0, 0);

            IOConnectPipeRubyBasicObjectNode(IOConnectPipeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                return super.connectPipe(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    return super.connectPipe(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static IOPrimitiveNodes.IOConnectPipeNode create0(IOPrimitiveNodes.IOConnectPipeNode current) {
                return new IOConnectPipeRubyBasicObjectNode((IOConnectPipeBaseNode)current);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOConnectPipeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IOConnectPipeUninitializedNode
        extends IOConnectPipeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IOConnectPipeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IOConnectPipeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IOConnectPipeUninitializedNode(IOConnectPipeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                IOConnectPipeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IOConnectPipeBaseNode rootNode = (IOConnectPipeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((IOConnectPipeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static IOPrimitiveNodes.IOConnectPipeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IOConnectPipeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOConnectPipeNode.class)
        private static abstract class IOConnectPipeBaseNode
        extends IOPrimitiveNodes.IOConnectPipeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IOConnectPipeBaseNode next0;

            IOConnectPipeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IOConnectPipeBaseNode(IOConnectPipeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                IOConnectPipeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IOConnectPipeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new IOConnectPipeUninitializedNode(this);
                    ((IOConnectPipeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (IOConnectPipeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = IOConnectPipeBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (IOConnectPipeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new IOConnectPipeUninitializedNode(this), (Node)new IOConnectPipePolymorphicNode(this), (DSLNode)((IOConnectPipeBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IOConnectPipeBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    return (IOConnectPipeBaseNode)IOConnectPipeRubyBasicObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    IOConnectPipeBaseNode otherCast = (IOConnectPipeBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (IOConnectPipeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=IOPrimitiveNodes.IOAllocatePrimitiveNode.class)
    public static final class IOAllocatePrimitiveNodeFactory
    extends NodeFactoryBase<IOPrimitiveNodes.IOAllocatePrimitiveNode> {
        private static IOAllocatePrimitiveNodeFactory iOAllocatePrimitiveNodeFactoryInstance;

        private IOAllocatePrimitiveNodeFactory() {
            super(IOPrimitiveNodes.IOAllocatePrimitiveNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public IOPrimitiveNodes.IOAllocatePrimitiveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IOAllocatePrimitiveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static IOPrimitiveNodes.IOAllocatePrimitiveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IOAllocatePrimitiveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<IOPrimitiveNodes.IOAllocatePrimitiveNode> getInstance() {
            if (iOAllocatePrimitiveNodeFactoryInstance == null) {
                iOAllocatePrimitiveNodeFactoryInstance = new IOAllocatePrimitiveNodeFactory();
            }
            return iOAllocatePrimitiveNodeFactoryInstance;
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOAllocatePrimitiveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IOAllocatePrimitivePolymorphicNode
        extends IOAllocatePrimitiveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            IOAllocatePrimitivePolymorphicNode(IOAllocatePrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOAllocatePrimitiveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IOAllocatePrimitiveRubyClassNode
        extends IOAllocatePrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IOAllocatePrimitiveRubyClassNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyClass.class}, 0, 0);

            IOAllocatePrimitiveRubyClassNode(IOAllocatePrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyClass arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyClass");
                }
                return super.allocate(frameValue, arguments0Value);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyClass(arguments0Value)) {
                    RubyClass arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyClass(arguments0Value);
                    return super.allocate(frameValue, arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static IOPrimitiveNodes.IOAllocatePrimitiveNode create0(IOPrimitiveNodes.IOAllocatePrimitiveNode current) {
                return new IOAllocatePrimitiveRubyClassNode((IOAllocatePrimitiveBaseNode)current);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOAllocatePrimitiveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IOAllocatePrimitiveUninitializedNode
        extends IOAllocatePrimitiveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IOAllocatePrimitiveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IOAllocatePrimitiveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IOAllocatePrimitiveUninitializedNode(IOAllocatePrimitiveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyBasicObject executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                IOAllocatePrimitiveBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IOAllocatePrimitiveBaseNode rootNode = (IOAllocatePrimitiveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((IOAllocatePrimitiveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static IOPrimitiveNodes.IOAllocatePrimitiveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IOAllocatePrimitiveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=IOPrimitiveNodes.IOAllocatePrimitiveNode.class)
        private static abstract class IOAllocatePrimitiveBaseNode
        extends IOPrimitiveNodes.IOAllocatePrimitiveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IOAllocatePrimitiveBaseNode next0;

            IOAllocatePrimitiveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IOAllocatePrimitiveBaseNode(IOAllocatePrimitiveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyBasicObject executeChained0(VirtualFrame var1, Object var2);

            protected final RubyBasicObject rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                IOAllocatePrimitiveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IOAllocatePrimitiveBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new IOAllocatePrimitiveUninitializedNode(this);
                    ((IOAllocatePrimitiveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (IOAllocatePrimitiveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = IOAllocatePrimitiveBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (IOAllocatePrimitiveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new IOAllocatePrimitiveUninitializedNode(this), (Node)new IOAllocatePrimitivePolymorphicNode(this), (DSLNode)((IOAllocatePrimitiveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IOAllocatePrimitiveBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyClass(arguments0Value)) {
                    return (IOAllocatePrimitiveBaseNode)IOAllocatePrimitiveRubyClassNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((IOAllocatePrimitiveBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (IOAllocatePrimitiveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }
}

