/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import jnr.constants.platform.Fcntl;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.util.Dir;

public abstract class IOPrimitiveNodes {

    @RubiniusPrimitive(name="io_seek", lowerFixnumParameters={0, 1})
    public static abstract class IOSeekPrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOSeekPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IOSeekPrimitiveNode(IOSeekPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public int seek(VirtualFrame frame, RubyBasicObject io, int amount, int whence) {
            int fd = (Integer)this.rubyWithSelf(frame, io, "@descriptor", new Object[0]);
            return this.posix().lseek(fd, (long)amount, whence);
        }
    }

    @RubiniusPrimitive(name="io_close")
    public static abstract class IOClosePrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOClosePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IOClosePrimitiveNode(IOClosePrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public int close(VirtualFrame frame, RubyBasicObject io) {
            int fd = (Integer)this.rubyWithSelf(frame, io, "@descriptor", new Object[0]);
            return this.posix().close(fd);
        }
    }

    @RubiniusPrimitive(name="io_write")
    public static abstract class IOWritePrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOWritePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IOWritePrimitiveNode(IOWritePrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public int write(VirtualFrame frame, RubyBasicObject file, RubyString string) {
            int fd = (Integer)this.rubyWithSelf(frame, file, "@descriptor", new Object[0]);
            byte[] bytes = string.getByteList().bytes();
            while (bytes.length > 0) {
                this.getContext().getSafepointManager().poll(this);
                int written = this.posix().write(fd, bytes, bytes.length);
                if (written == -1) {
                    throw new UnsupportedOperationException();
                }
                bytes = Arrays.copyOfRange(bytes, written, bytes.length);
            }
            return bytes.length;
        }
    }

    @RubiniusPrimitive(name="io_ensure_open")
    public static abstract class IOEnsureOpenPrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOEnsureOpenPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IOEnsureOpenPrimitiveNode(IOEnsureOpenPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass ensureOpen(RubyBasicObject file) {
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="io_fnmatch", needsSelf=false)
    public static abstract class IOFNMatchPrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOFNMatchPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IOFNMatchPrimitiveNode(IOFNMatchPrimitiveNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean fnmatch(RubyString pattern, RubyString path, int flags) {
            return Dir.fnmatch((byte[])pattern.getByteList().getUnsafeBytes(), (int)pattern.getByteList().getBegin(), (int)(pattern.getByteList().getBegin() + pattern.getByteList().getRealSize()), (byte[])path.getByteList().getUnsafeBytes(), (int)path.getByteList().getBegin(), (int)(path.getByteList().getBegin() + path.getByteList().getRealSize()), (int)flags) != 1;
        }
    }

    @RubiniusPrimitive(name="io_open", needsSelf=false)
    public static abstract class IOOpenPrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOOpenPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IOOpenPrimitiveNode(IOOpenPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public int open(RubyString path, int mode, int permission) {
            return this.posix().open((CharSequence)path.getByteList(), mode, permission);
        }
    }

    @RubiniusPrimitive(name="io_connect_pipe", needsSelf=false)
    public static abstract class IOConnectPipeNode
    extends RubiniusPrimitiveNode {
        public IOConnectPipeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IOConnectPipeNode(IOConnectPipeNode prev) {
            super(prev);
        }

        @Specialization
        public boolean connectPipe(VirtualFrame frame, RubyBasicObject lhs, RubyBasicObject rhs) {
            int[] fds = new int[2];
            if (this.posix().pipe(fds) == -1) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
            }
            this.newOpenFd(fds[0]);
            this.newOpenFd(fds[1]);
            this.rubyWithSelf(frame, lhs, "@descriptor = fd", "fd", fds[0]);
            this.rubyWithSelf(frame, lhs, "@mode = File::Constants::RDONLY", new Object[0]);
            this.rubyWithSelf(frame, rhs, "@descriptor = fd", "fd", fds[1]);
            this.rubyWithSelf(frame, rhs, "@mode = File::Constants::WRONLY", new Object[0]);
            return true;
        }

        private void newOpenFd(int newFd) {
            boolean FD_CLOEXEC = true;
            if (newFd > 2) {
                int flags = this.posix().fcntl(newFd, Fcntl.F_GETFD);
                if (flags == -1) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
                }
                flags = this.posix().fcntlInt(newFd, Fcntl.F_SETFD, flags | 1);
                if (flags == -1) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.posix().errno(), this));
                }
            }
        }
    }

    @RubiniusPrimitive(name="io_allocate")
    public static abstract class IOAllocatePrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOAllocatePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IOAllocatePrimitiveNode(IOAllocatePrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public RubyBasicObject allocate(VirtualFrame frame, RubyClass classToAllocate) {
            RubyBasicObject object = new RubyBasicObject(classToAllocate);
            this.rubyWithSelf(frame, object, "@ibuffer = IO::InternalBuffer.new", new Object[0]);
            this.rubyWithSelf(frame, object, "@lineno = 0", new Object[0]);
            return object;
        }
    }
}

