/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import jnr.constants.platform.Errno;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.rubinius.RubiniusByteArray;
import org.jruby.util.ByteList;

public abstract class IOBufferPrimitiveNodes {
    private static final int IOBUFFER_SIZE = 32768;
    private static final int STACK_BUF_SZ = 8192;

    @RubiniusPrimitive(name="iobuffer_fill")
    public static abstract class IOBufferFillPrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOBufferFillPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IOBufferFillPrimitiveNode(IOBufferFillPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public int fill(VirtualFrame frame, RubyBasicObject ioBuffer, RubyBasicObject io) {
            int bytesRead;
            int fd = (Integer)this.rubyWithSelf(frame, io, "@descriptor", new Object[0]);
            byte[] readBuffer = new byte[8192];
            int count = 8192;
            if (this.left(frame, ioBuffer) < count) {
                count = this.left(frame, ioBuffer);
            }
            while ((bytesRead = this.posix().read(fd, readBuffer, count)) == -1) {
                int errno = this.posix().errno();
                if (errno == Errno.ECONNRESET.intValue() || errno == Errno.ETIMEDOUT.intValue()) {
                    bytesRead = 0;
                    break;
                }
                if (errno == Errno.EAGAIN.intValue() || errno == Errno.EINTR.intValue()) {
                    this.getContext().getSafepointManager().poll(this);
                    continue;
                }
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(new RubyException(this.getContext().getCoreLibrary().getErrnoClass(Errno.valueOf((long)errno))));
            }
            if (bytesRead > 0) {
                if (bytesRead > this.left(frame, ioBuffer)) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().internalError("IO buffer overrun", this));
                }
                int used = (Integer)this.rubyWithSelf(frame, ioBuffer, "@used", new Object[0]);
                ByteList storage = ((RubiniusByteArray)this.rubyWithSelf(frame, ioBuffer, "@storage", new Object[0])).getBytes();
                System.arraycopy(readBuffer, 0, storage.getUnsafeBytes(), storage.getBegin() + used, bytesRead);
                storage.setRealSize(used + bytesRead);
                this.rubyWithSelf(frame, ioBuffer, "@used = used", "used", used + bytesRead);
            }
            return bytesRead;
        }

        private int left(VirtualFrame frame, RubyBasicObject ioBuffer) {
            int total = (Integer)this.rubyWithSelf(frame, ioBuffer, "@total", new Object[0]);
            int used = (Integer)this.rubyWithSelf(frame, ioBuffer, "@used", new Object[0]);
            return total - used;
        }
    }

    @RubiniusPrimitive(name="iobuffer_unshift", lowerFixnumParameters={1})
    public static abstract class IOBufferUnshiftPrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOBufferUnshiftPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IOBufferUnshiftPrimitiveNode(IOBufferUnshiftPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public int unshift(VirtualFrame frame, RubyBasicObject ioBuffer, RubyString string, int startPosition) {
            this.rubyWithSelf(frame, ioBuffer, "@write_synced = false", new Object[0]);
            int stringSize = string.getByteList().realSize() - startPosition;
            int usedSpace = (Integer)this.rubyWithSelf(frame, ioBuffer, "@used", new Object[0]);
            int availableSpace = 32768 - usedSpace;
            if (stringSize > availableSpace) {
                stringSize = availableSpace;
            }
            ByteList storage = ((RubiniusByteArray)this.rubyWithSelf(frame, ioBuffer, "@storage", new Object[0])).getBytes();
            System.arraycopy(string.getByteList().unsafeBytes(), startPosition, storage.getUnsafeBytes(), usedSpace, stringSize);
            this.rubyWithSelf(frame, ioBuffer, "@used = used", "used", usedSpace + stringSize);
            return stringSize;
        }
    }

    @RubiniusPrimitive(name="iobuffer_allocate")
    public static abstract class IOBufferAllocatePrimitiveNode
    extends RubiniusPrimitiveNode {
        public IOBufferAllocatePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IOBufferAllocatePrimitiveNode(IOBufferAllocatePrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public RubyBasicObject allocate(VirtualFrame frame, RubyClass classToAllocate) {
            RubyBasicObject ioBuffer = new RubyBasicObject(classToAllocate);
            this.rubyWithSelf(frame, ioBuffer, "@write_synced = true", new Object[0]);
            this.rubyWithSelf(frame, ioBuffer, "@storage = storage", "storage", new RubiniusByteArray(this.getContext().getCoreLibrary().getByteArrayClass(), new ByteList(32768)));
            this.rubyWithSelf(frame, ioBuffer, "@used = 0", new Object[0]);
            this.rubyWithSelf(frame, ioBuffer, "@start = 0", new Object[0]);
            this.rubyWithSelf(frame, ioBuffer, "@total = total", "total", 32768);
            return ioBuffer;
        }
    }
}

