/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.source.SourceSection;
import java.io.File;
import jnr.constants.platform.Errno;
import org.jruby.truffle.nodes.objectstorage.ReadHeadObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.WriteHeadObjectFieldNode;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyString;

public abstract class DirPrimitiveNodes {
    private static final HiddenKey contentsKey = new HiddenKey("contents");
    private static final HiddenKey positionKey = new HiddenKey("position");

    @RubiniusPrimitive(name="dir_close")
    public static abstract class DirClosePrimitiveNode
    extends RubiniusPrimitiveNode {
        public DirClosePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DirClosePrimitiveNode(DirClosePrimitiveNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyNilClass open(RubyBasicObject dir) {
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="dir_read")
    public static abstract class DirReadPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private ReadHeadObjectFieldNode readContentsNode;
        @Node.Child
        private ReadHeadObjectFieldNode readPositionNode;
        @Node.Child
        private WriteHeadObjectFieldNode writePositionNode;

        public DirReadPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.readContentsNode = new ReadHeadObjectFieldNode(contentsKey);
            this.readPositionNode = new ReadHeadObjectFieldNode(positionKey);
            this.writePositionNode = new WriteHeadObjectFieldNode(positionKey);
        }

        public DirReadPrimitiveNode(DirReadPrimitiveNode prev) {
            super(prev);
            this.readContentsNode = prev.readContentsNode;
            this.readPositionNode = prev.readPositionNode;
            this.writePositionNode = prev.writePositionNode;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object read(RubyBasicObject dir) {
            int position;
            try {
                position = this.readPositionNode.executeInteger(dir);
            }
            catch (UnexpectedResultException e) {
                throw new IllegalStateException();
            }
            this.writePositionNode.execute(dir, position + 1);
            if (position == -2) {
                return this.getContext().makeString(".");
            }
            if (position == -1) {
                return this.getContext().makeString("..");
            }
            String[] contents = (String[])this.readContentsNode.execute(dir);
            if (position < contents.length) {
                return this.getContext().makeString(contents[position]);
            }
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="dir_open")
    public static abstract class DirOpenPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private WriteHeadObjectFieldNode writeContentsNode;
        @Node.Child
        private WriteHeadObjectFieldNode writePositionNode;

        public DirOpenPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.writeContentsNode = new WriteHeadObjectFieldNode(contentsKey);
            this.writePositionNode = new WriteHeadObjectFieldNode(positionKey);
        }

        public DirOpenPrimitiveNode(DirOpenPrimitiveNode prev) {
            super(prev);
            this.writeContentsNode = prev.writeContentsNode;
            this.writePositionNode = prev.writePositionNode;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyNilClass open(RubyBasicObject dir, RubyString path, RubyNilClass encoding) {
            File file = new File(path.toString());
            if (!file.isDirectory()) {
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(Errno.ENOTDIR.intValue(), this));
            }
            String[] contents = file.list();
            if (contents == null) {
                throw new UnsupportedOperationException();
            }
            this.writeContentsNode.execute(dir, contents);
            this.writePositionNode.execute(dir, -2);
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="dir_allocate")
    public static abstract class DirAllocatePrimitiveNode
    extends RubiniusPrimitiveNode {
        public DirAllocatePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DirAllocatePrimitiveNode(DirAllocatePrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public RubyBasicObject allocate(RubyClass dirClass) {
            return new RubyBasicObject(dirClass);
        }
    }
}

