/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBignum;

public abstract class BignumPrimitiveNodes {

    @RubiniusPrimitive(name="bignum_pow")
    public static abstract class BignumPowPrimitiveNode
    extends RubiniusPrimitiveNode {
        private final ConditionProfile negativeProfile = ConditionProfile.createBinaryProfile();

        public BignumPowPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BignumPowPrimitiveNode(BignumPowPrimitiveNode prev) {
            super(prev);
        }

        @Specialization
        public RubyBignum pow(RubyBignum a, int b) {
            return this.pow(a, (long)b);
        }

        @Specialization
        public RubyBignum pow(RubyBignum a, long b) {
            if (this.negativeProfile.profile(b < 0L)) {
                return null;
            }
            return new RubyBignum(this.getContext().getCoreLibrary().getBignumClass(), a.bigIntegerValue().pow((int)b));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public double pow(RubyBignum a, double b) {
            return Math.pow(a.bigIntegerValue().doubleValue(), b);
        }

        @Specialization
        public RubyBignum pow(RubyBignum a, RubyBignum b) {
            throw new UnsupportedOperationException();
        }
    }
}

