/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objectstorage;

import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.IntLocation;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.nodes.objectstorage.WriteObjectFieldChainNode;
import org.jruby.truffle.nodes.objectstorage.WriteObjectFieldNode;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@NodeInfo(cost=NodeCost.POLYMORPHIC)
public class WriteIntegerObjectFieldNode
extends WriteObjectFieldChainNode {
    private final Shape expectedLayout;
    private final Shape newLayout;
    private final IntLocation storageLocation;

    public WriteIntegerObjectFieldNode(Shape expectedLayout, Shape newLayout, IntLocation storageLocation, WriteObjectFieldNode next) {
        super(next);
        this.expectedLayout = expectedLayout;
        this.newLayout = newLayout;
        this.storageLocation = storageLocation;
    }

    @Override
    public void execute(RubyBasicObject object, int value) {
        block7: {
            try {
                this.expectedLayout.getValidAssumption().check();
                this.newLayout.getValidAssumption().check();
            }
            catch (InvalidAssumptionException e) {
                this.replace(this.next);
                this.next.execute(object, value);
                return;
            }
            if (object.getObjectLayout() == this.expectedLayout) {
                try {
                    if (this.newLayout == this.expectedLayout) {
                        this.storageLocation.setInt(object.getDynamicObject(), value, this.expectedLayout);
                        break block7;
                    }
                    this.storageLocation.setInt(object.getDynamicObject(), value, this.expectedLayout, this.newLayout);
                }
                catch (FinalLocationException e) {
                    ((WriteObjectFieldNode)this.replace(this.next, "!final")).execute(object, value);
                }
            } else {
                this.next.execute(object, value);
            }
        }
    }

    @Override
    public void execute(RubyBasicObject object, Object value) {
        if (value instanceof Integer) {
            this.execute(object, (Integer)value);
        } else {
            this.next.execute(object, value);
        }
    }
}

