/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objectstorage;

import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.nodes.objectstorage.ReadObjectFieldChainNode;
import org.jruby.truffle.nodes.objectstorage.ReadObjectFieldNode;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@NodeInfo(cost=NodeCost.POLYMORPHIC)
public class ReadMissingObjectFieldNode
extends ReadObjectFieldChainNode {
    public ReadMissingObjectFieldNode(Shape objectLayout, ReadObjectFieldNode next) {
        super(objectLayout, next);
    }

    @Override
    public Object execute(RubyBasicObject object) {
        try {
            this.objectLayout.getValidAssumption().check();
        }
        catch (InvalidAssumptionException e) {
            this.replace(this.next);
            return this.next.execute(object);
        }
        if (object.getDynamicObject().getShape() == this.objectLayout) {
            return null;
        }
        return this.next.execute(object);
    }

    @Override
    public boolean isSet(RubyBasicObject object) {
        boolean condition;
        try {
            this.objectLayout.getValidAssumption().check();
        }
        catch (InvalidAssumptionException e) {
            this.replace(this.next);
            return this.next.isSet(object);
        }
        boolean bl = condition = object.getObjectLayout() == this.objectLayout;
        if (condition) {
            return false;
        }
        return this.next.isSet(object);
    }
}

