/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.WriteNode;
import org.jruby.truffle.nodes.objects.ReadInstanceVariableNode;
import org.jruby.truffle.nodes.objectstorage.WriteHeadObjectFieldNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;

public class WriteInstanceVariableNode
extends RubyNode
implements WriteNode {
    @Node.Child
    private RubyNode receiver;
    @Node.Child
    private RubyNode rhs;
    @Node.Child
    private WriteHeadObjectFieldNode writeNode;
    private final boolean isGlobal;

    public WriteInstanceVariableNode(RubyContext context, SourceSection sourceSection, String name, RubyNode receiver, RubyNode rhs, boolean isGlobal) {
        super(context, sourceSection);
        this.receiver = receiver;
        this.rhs = rhs;
        this.writeNode = new WriteHeadObjectFieldNode(name);
        this.isGlobal = isGlobal;
    }

    @Override
    public int executeIntegerFixnum(VirtualFrame frame) throws UnexpectedResultException {
        Object object = this.receiver.execute(frame);
        if (object instanceof RubyBasicObject) {
            try {
                int value = this.rhs.executeIntegerFixnum(frame);
                this.writeNode.execute((RubyBasicObject)object, value);
                return value;
            }
            catch (UnexpectedResultException e) {
                this.writeNode.execute((RubyBasicObject)object, e.getResult());
                throw e;
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().frozenError(this.getContext().getCoreLibrary().getLogicalClass(object).getName(), this));
    }

    @Override
    public long executeLongFixnum(VirtualFrame frame) throws UnexpectedResultException {
        Object object = this.receiver.execute(frame);
        if (object instanceof RubyBasicObject) {
            try {
                long value = this.rhs.executeLongFixnum(frame);
                this.writeNode.execute((RubyBasicObject)object, value);
                return value;
            }
            catch (UnexpectedResultException e) {
                this.writeNode.execute((RubyBasicObject)object, e.getResult());
                throw e;
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().frozenError(this.getContext().getCoreLibrary().getLogicalClass(object).getName(), this));
    }

    @Override
    public double executeFloat(VirtualFrame frame) throws UnexpectedResultException {
        Object object = this.receiver.execute(frame);
        if (object instanceof RubyBasicObject) {
            try {
                double value = this.rhs.executeFloat(frame);
                this.writeNode.execute((RubyBasicObject)object, value);
                return value;
            }
            catch (UnexpectedResultException e) {
                this.writeNode.execute((RubyBasicObject)object, e.getResult());
                throw e;
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().frozenError(this.getContext().getCoreLibrary().getLogicalClass(object).getName(), this));
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object object = this.receiver.execute(frame);
        Object value = this.rhs.execute(frame);
        if (!(object instanceof RubyBasicObject)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().frozenError(this.getContext().getCoreLibrary().getLogicalClass(object).getName(), this));
        }
        this.writeNode.execute((RubyBasicObject)object, value);
        return value;
    }

    @Override
    public RubyNode makeReadNode() {
        return new ReadInstanceVariableNode(this.getContext(), this.getSourceSection(), (String)this.writeNode.getName(), this.receiver, this.isGlobal);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.getContext().makeString("assignment");
    }
}

