/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods.locals;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.WriteNode;
import org.jruby.truffle.nodes.methods.locals.FrameSlotNode;
import org.jruby.truffle.nodes.methods.locals.ReadLocalVariableNodeFactory;
import org.jruby.truffle.runtime.RubyContext;

@NodeChild(value="rhs", type=RubyNode.class)
public abstract class WriteLocalVariableNode
extends FrameSlotNode
implements WriteNode {
    public WriteLocalVariableNode(RubyContext context, SourceSection sourceSection, FrameSlot frameSlot) {
        super(context, sourceSection, frameSlot);
    }

    protected WriteLocalVariableNode(WriteLocalVariableNode prev) {
        this(prev.getContext(), prev.getSourceSection(), prev.frameSlot);
    }

    @Specialization(guards={"isBooleanKind"})
    public boolean doFixnum(VirtualFrame frame, boolean value) {
        this.setBoolean((Frame)frame, value);
        return value;
    }

    @Specialization(guards={"isFixnumKind"})
    public int doFixnum(VirtualFrame frame, int value) {
        this.setFixnum((Frame)frame, value);
        return value;
    }

    @Specialization(guards={"isLongFixnumKind"})
    public long doLongFixnum(VirtualFrame frame, long value) {
        this.setLongFixnum((Frame)frame, value);
        return value;
    }

    @Specialization(guards={"isFloatKind"})
    public double doFloat(VirtualFrame frame, double value) {
        this.setFloat((Frame)frame, value);
        return value;
    }

    @Specialization(guards={"isObjectKind"})
    public Object doObject(VirtualFrame frame, Object value) {
        this.setObject((Frame)frame, value);
        return value;
    }

    @Override
    public RubyNode makeReadNode() {
        return ReadLocalVariableNodeFactory.create(this.getContext(), this.getSourceSection(), this.frameSlot);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.getContext().makeString("assignment");
    }
}

