/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods.locals;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.methods.locals.WriteLevelVariableNode;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=WriteLevelVariableNode.class)
public final class WriteLevelVariableNodeFactory
extends NodeFactoryBase<WriteLevelVariableNode> {
    private static WriteLevelVariableNodeFactory instance;

    private WriteLevelVariableNodeFactory() {
        super(WriteLevelVariableNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, FrameSlot.class, Integer.TYPE, RubyNode.class}});
    }

    public WriteLevelVariableNode createNode(Object ... arguments) {
        if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof FrameSlot) || !(arguments[3] instanceof Integer) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
            return WriteLevelVariableNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (FrameSlot)arguments[2], (Integer)arguments[3], (RubyNode)((Object)arguments[4]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static WriteLevelVariableNode create(RubyContext context, SourceSection sourceSection, FrameSlot frameSlot, int level, RubyNode rhs) {
        return WriteLevelVariableUninitializedNode.create0(context, sourceSection, frameSlot, level, rhs);
    }

    public static NodeFactory<WriteLevelVariableNode> getInstance() {
        if (instance == null) {
            instance = new WriteLevelVariableNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=WriteLevelVariableNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class WriteLevelVariablePolymorphicNode
    extends WriteLevelVariableBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> rhsPolymorphicType;

        WriteLevelVariablePolymorphicNode(WriteLevelVariableBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object rhsValue;
            try {
                rhsValue = this.rhsPolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.rhs.executeBoolean(frameValue)) : (this.rhsPolymorphicType == Integer.TYPE ? Integer.valueOf(this.rhs.executeIntegerFixnum(frameValue)) : (this.rhsPolymorphicType == Long.TYPE ? Long.valueOf(this.rhs.executeLongFixnum(frameValue)) : (this.rhsPolymorphicType == Double.TYPE ? Double.valueOf(this.rhs.executeFloat(frameValue)) : this.rhs.execute(frameValue))));
            }
            catch (UnexpectedResultException ex) {
                this.rhsPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, rhsValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.rhsPolymorphicType = types[0];
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object rhsValue) {
            return this.next0.executeChained0(frameValue, rhsValue);
        }
    }

    @GeneratedBy(value=WriteLevelVariableNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class WriteLevelVariableObjectNode
    extends WriteLevelVariableBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(WriteLevelVariableObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

        WriteLevelVariableObjectNode(WriteLevelVariableBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object rhsValue = this.rhs.execute(frameValue);
            if (super.isObjectKind()) {
                return super.doObject(frameValue, rhsValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, rhsValue, "One of guards [isObjectKind] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object rhsValue) {
            if (super.isObjectKind()) {
                return super.doObject(frameValue, rhsValue);
            }
            return this.next0.executeChained0(frameValue, rhsValue);
        }

        static WriteLevelVariableNode create0(WriteLevelVariableNode current) {
            return new WriteLevelVariableObjectNode((WriteLevelVariableBaseNode)current);
        }
    }

    @GeneratedBy(value=WriteLevelVariableNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class WriteLevelVariableDoubleNode
    extends WriteLevelVariableBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(WriteLevelVariableDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

        WriteLevelVariableDoubleNode(WriteLevelVariableBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            double value;
            try {
                value = this.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            double rhsValue;
            try {
                rhsValue = this.rhs.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), "Expected rhsValue instanceof double"));
            }
            if (super.isFloatKind()) {
                return super.doFloat(frameValue, rhsValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, rhsValue, "One of guards [isFloatKind] failed"));
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object rhsValue) {
            if (RubyTypesGen.RUBYTYPES.isDouble(rhsValue) && super.isFloatKind()) {
                double rhsValueCast = RubyTypesGen.RUBYTYPES.asDouble(rhsValue);
                return super.doFloat(frameValue, rhsValueCast);
            }
            return this.next0.executeChained0(frameValue, rhsValue);
        }

        static WriteLevelVariableNode create0(WriteLevelVariableNode current) {
            return new WriteLevelVariableDoubleNode((WriteLevelVariableBaseNode)current);
        }
    }

    @GeneratedBy(value=WriteLevelVariableNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class WriteLevelVariableLongNode
    extends WriteLevelVariableBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(WriteLevelVariableLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

        WriteLevelVariableLongNode(WriteLevelVariableBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            long value;
            try {
                value = this.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            long rhsValue;
            try {
                rhsValue = this.rhs.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), "Expected rhsValue instanceof long"));
            }
            if (super.isLongFixnumKind()) {
                return super.doLongFixnum(frameValue, rhsValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, rhsValue, "One of guards [isLongFixnumKind] failed"));
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object rhsValue) {
            if (RubyTypesGen.RUBYTYPES.isLong(rhsValue) && super.isLongFixnumKind()) {
                long rhsValueCast = RubyTypesGen.RUBYTYPES.asLong(rhsValue);
                return super.doLongFixnum(frameValue, rhsValueCast);
            }
            return this.next0.executeChained0(frameValue, rhsValue);
        }

        static WriteLevelVariableNode create0(WriteLevelVariableNode current) {
            return new WriteLevelVariableLongNode((WriteLevelVariableBaseNode)current);
        }
    }

    @GeneratedBy(value=WriteLevelVariableNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class WriteLevelVariableIntNode
    extends WriteLevelVariableBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(WriteLevelVariableIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

        WriteLevelVariableIntNode(WriteLevelVariableBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int value;
            try {
                value = this.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            int rhsValue;
            try {
                rhsValue = this.rhs.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), "Expected rhsValue instanceof int"));
            }
            if (super.isFixnumKind()) {
                return super.doFixnum(frameValue, rhsValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, rhsValue, "One of guards [isFixnumKind] failed"));
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object rhsValue) {
            if (RubyTypesGen.RUBYTYPES.isInteger(rhsValue) && super.isFixnumKind()) {
                int rhsValueCast = RubyTypesGen.RUBYTYPES.asInteger(rhsValue);
                return super.doFixnum(frameValue, rhsValueCast);
            }
            return this.next0.executeChained0(frameValue, rhsValue);
        }

        static WriteLevelVariableNode create0(WriteLevelVariableNode current) {
            return new WriteLevelVariableIntNode((WriteLevelVariableBaseNode)current);
        }
    }

    @GeneratedBy(value=WriteLevelVariableNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class WriteLevelVariableBooleanNode
    extends WriteLevelVariableBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(WriteLevelVariableBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE}, 0, 0);

        WriteLevelVariableBooleanNode(WriteLevelVariableBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            boolean value;
            try {
                value = this.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
            boolean rhsValue;
            try {
                rhsValue = this.rhs.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, ex.getResult(), "Expected rhsValue instanceof boolean"));
            }
            if (super.isBooleanKind()) {
                return super.doBoolean(frameValue, rhsValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, rhsValue, "One of guards [isBooleanKind] failed"));
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object rhsValue) {
            if (RubyTypesGen.RUBYTYPES.isBoolean(rhsValue) && super.isBooleanKind()) {
                boolean rhsValueCast = RubyTypesGen.RUBYTYPES.asBoolean(rhsValue);
                return super.doBoolean(frameValue, rhsValueCast);
            }
            return this.next0.executeChained0(frameValue, rhsValue);
        }

        static WriteLevelVariableNode create0(WriteLevelVariableNode current) {
            return new WriteLevelVariableBooleanNode((WriteLevelVariableBaseNode)current);
        }
    }

    @GeneratedBy(value=WriteLevelVariableNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class WriteLevelVariableUninitializedNode
    extends WriteLevelVariableBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(WriteLevelVariableUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        WriteLevelVariableUninitializedNode(RubyContext context, SourceSection sourceSection, FrameSlot frameSlot, int level, RubyNode rhs) {
            super(context, sourceSection, frameSlot, level, rhs);
        }

        WriteLevelVariableUninitializedNode(WriteLevelVariableBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object rhsValue = this.rhs.execute(frameValue);
            return this.executeUninitialized0(frameValue, rhsValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object rhsValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, rhsValue);
        }

        protected Object executeUninitialized0(VirtualFrame frameValue, Object rhsValue) {
            WriteLevelVariableBaseNode newNode = this.specialize0(rhsValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                WriteLevelVariableBaseNode rootNode = (WriteLevelVariableBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.rhs}, new Object[]{rhsValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((WriteLevelVariableBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, rhsValue);
        }

        static WriteLevelVariableNode create0(RubyContext context, SourceSection sourceSection, FrameSlot frameSlot, int level, RubyNode rhs) {
            return new WriteLevelVariableUninitializedNode(context, sourceSection, frameSlot, level, rhs);
        }
    }

    @GeneratedBy(value=WriteLevelVariableNode.class)
    private static abstract class WriteLevelVariableBaseNode
    extends WriteLevelVariableNode
    implements DSLNode {
        @Node.Child
        protected RubyNode rhs;
        @Node.Child
        protected WriteLevelVariableBaseNode next0;

        WriteLevelVariableBaseNode(RubyContext context, SourceSection sourceSection, FrameSlot frameSlot, int level, RubyNode rhs) {
            super(context, sourceSection, frameSlot, level);
            this.rhs = rhs;
        }

        WriteLevelVariableBaseNode(WriteLevelVariableBaseNode copy) {
            super(copy);
        }

        protected abstract Object executeChained0(VirtualFrame var1, Object var2);

        protected final Object rewrite0(VirtualFrame frameValue, Object rhsValue, String reason) {
            String message;
            WriteLevelVariableBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            WriteLevelVariableBaseNode newNode = this.specialize0(rhsValue);
            if (newNode == null) {
                newNode = new WriteLevelVariableUninitializedNode(this);
                ((WriteLevelVariableUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (WriteLevelVariableBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = WriteLevelVariableBaseNode.createInfo0(reason, rhsValue)))) == null) {
                returnNode = (WriteLevelVariableBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new WriteLevelVariableUninitializedNode(this), (Node)new WriteLevelVariablePolymorphicNode(this), (DSLNode)((WriteLevelVariableBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(frameValue, rhsValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final WriteLevelVariableBaseNode specialize0(Object rhsValue) {
            if (RubyTypesGen.RUBYTYPES.isBoolean(rhsValue) && super.isBooleanKind()) {
                return (WriteLevelVariableBaseNode)WriteLevelVariableBooleanNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isInteger(rhsValue) && super.isFixnumKind()) {
                return (WriteLevelVariableBaseNode)WriteLevelVariableIntNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isLong(rhsValue) && super.isLongFixnumKind()) {
                return (WriteLevelVariableBaseNode)WriteLevelVariableLongNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isDouble(rhsValue) && super.isFloatKind()) {
                return (WriteLevelVariableBaseNode)WriteLevelVariableDoubleNode.create0(this);
            }
            if (super.isObjectKind()) {
                return (WriteLevelVariableBaseNode)WriteLevelVariableObjectNode.create0(this);
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            this.rhs = other == null ? null : ((WriteLevelVariableBaseNode)other).rhs;
            this.next0 = newNext == null ? null : (WriteLevelVariableBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object rhsValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("rhsValue").append(" = ").append(rhsValue);
                if (rhsValue != null) {
                    builder.append(" (").append(rhsValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

