/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods.locals;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jruby.truffle.nodes.ReadNode;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.methods.locals.FrameSlotNode;
import org.jruby.truffle.nodes.methods.locals.WriteLocalVariableNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.translator.BodyTranslator;

public abstract class ReadLocalVariableNode
extends FrameSlotNode
implements ReadNode {
    public static final Set<String> ALWAYS_DEFINED_GLOBALS = new HashSet<String>(Arrays.asList("$~"));

    public ReadLocalVariableNode(RubyContext context, SourceSection sourceSection, FrameSlot slot) {
        super(context, sourceSection, slot);
    }

    public ReadLocalVariableNode(ReadLocalVariableNode prev) {
        this(prev.getContext(), prev.getSourceSection(), prev.frameSlot);
    }

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    public boolean doBoolean(VirtualFrame frame) throws FrameSlotTypeException {
        return this.getBoolean((Frame)frame);
    }

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    public int doFixnum(VirtualFrame frame) throws FrameSlotTypeException {
        return this.getFixnum((Frame)frame);
    }

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    public long doLongFixnum(VirtualFrame frame) throws FrameSlotTypeException {
        return this.getLongFixnum((Frame)frame);
    }

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    public double doFloat(VirtualFrame frame) throws FrameSlotTypeException {
        return this.getFloat((Frame)frame);
    }

    @Specialization(rewriteOn={FrameSlotTypeException.class})
    public Object doObject(VirtualFrame frame) throws FrameSlotTypeException {
        return this.getObject((Frame)frame);
    }

    @Specialization
    public Object doValue(VirtualFrame frame) {
        return this.getValue((Frame)frame);
    }

    @Override
    public RubyNode makeWriteNode(RubyNode rhs) {
        return WriteLocalVariableNodeFactory.create(this.getContext(), this.getSourceSection(), this.frameSlot, rhs);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        if (BodyTranslator.FRAME_LOCAL_GLOBAL_VARIABLES.contains(this.frameSlot.getIdentifier())) {
            if (ALWAYS_DEFINED_GLOBALS.contains(this.frameSlot.getIdentifier()) || this.doValue(frame) != this.nil()) {
                return this.getContext().makeString("global-variable");
            }
            return this.nil();
        }
        return this.getContext().makeString("local-variable");
    }
}

