/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods.locals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;

public abstract class FrameSlotNode
extends RubyNode {
    protected final FrameSlot frameSlot;

    protected FrameSlotNode(RubyContext context, SourceSection sourceSection, FrameSlot frameSlot) {
        super(context, sourceSection);
        assert (frameSlot != null);
        this.frameSlot = frameSlot;
    }

    public final FrameSlot getFrameSlot() {
        return this.frameSlot;
    }

    public FrameSlotNode copy() {
        return (FrameSlotNode)super.copy();
    }

    protected final void setBoolean(Frame frame, boolean value) {
        frame.setBoolean(this.frameSlot, value);
    }

    protected final void setFixnum(Frame frame, int value) {
        frame.setInt(this.frameSlot, value);
    }

    protected final void setLongFixnum(Frame frame, long value) {
        frame.setLong(this.frameSlot, value);
    }

    protected final void setFloat(Frame frame, double value) {
        frame.setDouble(this.frameSlot, value);
    }

    protected final void setObject(Frame frame, Object value) {
        frame.setObject(this.frameSlot, value);
    }

    protected final boolean getBoolean(Frame frame) throws FrameSlotTypeException {
        return frame.getBoolean(this.frameSlot);
    }

    protected final int getFixnum(Frame frame) throws FrameSlotTypeException {
        return frame.getInt(this.frameSlot);
    }

    protected final long getLongFixnum(Frame frame) throws FrameSlotTypeException {
        return frame.getLong(this.frameSlot);
    }

    protected final double getFloat(Frame frame) throws FrameSlotTypeException {
        return frame.getDouble(this.frameSlot);
    }

    protected final Object getObject(Frame frame) throws FrameSlotTypeException {
        return frame.getObject(this.frameSlot);
    }

    protected final Object getValue(Frame frame) {
        return frame.getValue(this.frameSlot);
    }

    protected final boolean isBooleanKind() {
        return this.isKind(FrameSlotKind.Boolean);
    }

    protected final boolean isFixnumKind() {
        return this.isKind(FrameSlotKind.Int);
    }

    protected final boolean isLongFixnumKind() {
        return this.isKind(FrameSlotKind.Long);
    }

    protected final boolean isFloatKind() {
        return this.isKind(FrameSlotKind.Double);
    }

    protected final boolean isObjectKind() {
        if (this.frameSlot.getKind() != FrameSlotKind.Object) {
            CompilerDirectives.transferToInterpreter();
            this.frameSlot.setKind(FrameSlotKind.Object);
        }
        return true;
    }

    private boolean isKind(FrameSlotKind kind) {
        return this.frameSlot.getKind() == kind || this.initialSetKind(kind);
    }

    private boolean initialSetKind(FrameSlotKind kind) {
        if (this.frameSlot.getKind() == FrameSlotKind.Illegal) {
            CompilerDirectives.transferToInterpreter();
            this.frameSlot.setKind(kind);
            return true;
        }
        return false;
    }
}

