/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyModule;

@NodeChild(value="module", type=RubyNode.class)
public abstract class AliasNode
extends RubyNode {
    @Node.Child
    private RubyNode module;
    final String newName;
    final String oldName;

    public AliasNode(RubyContext context, SourceSection sourceSection, String newName, String oldName) {
        super(context, sourceSection);
        this.newName = newName;
        this.oldName = oldName;
    }

    public AliasNode(AliasNode prev) {
        super(prev);
        this.newName = prev.newName;
        this.oldName = prev.oldName;
    }

    public Object noClass() {
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().typeErrorNoClassToMakeAlias(this));
    }

    @Specialization
    public Object alias(boolean value) {
        return this.noClass();
    }

    @Specialization
    public Object alias(int value) {
        return this.noClass();
    }

    @Specialization
    public Object alias(long value) {
        return this.noClass();
    }

    @Specialization
    public Object alias(double value) {
        return this.noClass();
    }

    @Specialization
    public Object alias(RubyBignum value) {
        return this.noClass();
    }

    @Specialization
    public Object alias(RubyModule module) {
        AliasNode.notDesignedForCompilation();
        module.alias(this, this.newName, this.oldName);
        return null;
    }

    @Specialization(guards={"!isRubyModule", "!isRubyBignum"})
    public Object alias(RubyBasicObject object) {
        AliasNode.notDesignedForCompilation();
        object.getSingletonClass(this).alias(this, this.newName, this.oldName);
        return null;
    }
}

