/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.methods.MethodDefinitionNode;
import org.jruby.truffle.nodes.objects.SingletonClassNode;
import org.jruby.truffle.nodes.objects.SingletonClassNodeFactory;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class AddMethodNode
extends RubyNode {
    @Node.Child
    private RubyNode receiver;
    @Node.Child
    private MethodDefinitionNode methodNode;
    @Node.Child
    private SingletonClassNode singletonClassNode;

    public AddMethodNode(RubyContext context, SourceSection section, RubyNode receiver, MethodDefinitionNode method) {
        super(context, section);
        this.receiver = receiver;
        this.methodNode = method;
        this.singletonClassNode = SingletonClassNodeFactory.create(context, section, null);
    }

    @Override
    public RubySymbol execute(VirtualFrame frame) {
        AddMethodNode.notDesignedForCompilation();
        Object receiverObject = this.receiver.execute(frame);
        InternalMethod methodObject = (InternalMethod)this.methodNode.execute(frame);
        RubyModule module = receiverObject instanceof RubyModule ? (RubyModule)receiverObject : this.singletonClassNode.executeSingletonClass(frame, receiverObject);
        Visibility visibility = AddMethodNode.getVisibility((Frame)frame, methodObject.getName());
        InternalMethod method = methodObject.withDeclaringModule(module).withVisibility(visibility);
        if (method.getVisibility() == Visibility.MODULE_FUNCTION) {
            module.addMethod(this, method.withVisibility(Visibility.PRIVATE));
            module.getSingletonClass(this).addMethod(this, method.withVisibility(Visibility.PUBLIC));
        } else {
            module.addMethod(this, method);
        }
        return this.getContext().getSymbol(method.getName());
    }

    private static Visibility getVisibility(Frame frame, String name) {
        AddMethodNode.notDesignedForCompilation();
        if (ModuleOperations.isMethodPrivateFromName(name)) {
            return Visibility.PRIVATE;
        }
        return AddMethodNode.getVisibility(frame);
    }

    private static Visibility getVisibility(Frame frame) {
        AddMethodNode.notDesignedForCompilation();
        while (frame != null) {
            Visibility visibility = AddMethodNode.findVisibility(frame);
            if (visibility != null) {
                return visibility;
            }
            frame = RubyArguments.getDeclarationFrame(frame.getArguments());
        }
        throw new UnsupportedOperationException("No declaration frame with visibility found");
    }

    private static Visibility findVisibility(Frame frame) {
        FrameSlot slot = frame.getFrameDescriptor().findFrameSlot(RubyModule.VISIBILITY_FRAME_SLOT_ID);
        if (slot == null) {
            return null;
        }
        Object visibilityObject = frame.getValue(slot);
        if (visibilityObject instanceof Visibility) {
            return (Visibility)visibilityObject;
        }
        return Visibility.PUBLIC;
    }
}

