/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.literal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.util.ArrayList;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.objects.IsFrozenNode;
import org.jruby.truffle.nodes.objects.IsFrozenNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.hash.KeyValue;

public abstract class HashLiteralNode
extends RubyNode {
    @Node.Children
    protected final RubyNode[] keyValues;
    @Node.Child
    protected CallDispatchHeadNode dupNode;
    @Node.Child
    protected CallDispatchHeadNode freezeNode;

    protected HashLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] keyValues) {
        super(context, sourceSection);
        assert (keyValues.length % 2 == 0);
        this.keyValues = keyValues;
        this.dupNode = DispatchHeadNodeFactory.createMethodCall(context);
        this.freezeNode = DispatchHeadNodeFactory.createMethodCall(context);
    }

    public int size() {
        return this.keyValues.length / 2;
    }

    public RubyNode getKey(int index) {
        return this.keyValues[2 * index];
    }

    public RubyNode getValue(int index) {
        return this.keyValues[2 * index + 1];
    }

    public static HashLiteralNode create(RubyContext context, SourceSection sourceSection, RubyNode[] keyValues) {
        if (keyValues.length == 0) {
            return new EmptyHashLiteralNode(context, sourceSection);
        }
        if (keyValues.length <= HashOperations.SMALL_HASH_SIZE * 2) {
            return new SmallHashLiteralNode(context, sourceSection, keyValues);
        }
        return new GenericHashLiteralNode(context, sourceSection, keyValues);
    }

    @Override
    public abstract RubyHash executeRubyHash(VirtualFrame var1);

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeRubyHash(frame);
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        for (RubyNode child : this.keyValues) {
            child.executeVoid(frame);
        }
    }

    public static class GenericHashLiteralNode
    extends HashLiteralNode {
        public GenericHashLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] keyValues) {
            super(context, sourceSection, keyValues);
        }

        @Override
        public RubyHash executeRubyHash(VirtualFrame frame) {
            GenericHashLiteralNode.notDesignedForCompilation();
            ArrayList<KeyValue> entries = new ArrayList<KeyValue>();
            for (int n = 0; n < this.keyValues.length; n += 2) {
                Object key = this.keyValues[n].execute(frame);
                Object value = this.keyValues[n + 1].execute(frame);
                entries.add(new KeyValue(key, value));
            }
            return HashOperations.verySlowFromEntries(this.getContext(), entries, false);
        }
    }

    public static class SmallHashLiteralNode
    extends HashLiteralNode {
        private final ConditionProfile stringKeyProfile = ConditionProfile.createBinaryProfile();
        @Node.Child
        private CallDispatchHeadNode equalNode;
        @Node.Child
        private IsFrozenNode isFrozenNode;

        public SmallHashLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] keyValues) {
            super(context, sourceSection, keyValues);
            this.equalNode = DispatchHeadNodeFactory.createMethodCall(context, false, false, null);
        }

        @Override
        @ExplodeLoop
        public RubyHash executeRubyHash(VirtualFrame frame) {
            Object[] storage = new Object[HashOperations.SMALL_HASH_SIZE * 2];
            int end = 0;
            block0: for (int n = 0; n < this.keyValues.length; n += 2) {
                Object key = this.keyValues[n].execute(frame);
                if (this.stringKeyProfile.profile(key instanceof RubyString)) {
                    if (this.isFrozenNode == null) {
                        CompilerDirectives.transferToInterpreter();
                        this.isFrozenNode = (IsFrozenNode)this.insert(IsFrozenNodeFactory.create(this.getContext(), this.getSourceSection(), null));
                    }
                    if (!this.isFrozenNode.executeIsFrozen(key)) {
                        key = this.freezeNode.call(frame, this.dupNode.call(frame, key, "dup", null, new Object[0]), "freeze", null, new Object[0]);
                    }
                }
                Object value = this.keyValues[n + 1].execute(frame);
                for (int i = 0; i < n; i += 2) {
                    if (i >= end || !this.equalNode.callBoolean(frame, key, "eql?", null, storage[i])) continue;
                    storage[i + 1] = value;
                    continue block0;
                }
                storage[end] = key;
                storage[end + 1] = value;
                end += 2;
            }
            return new RubyHash(this.getContext().getCoreLibrary().getHashClass(), null, null, storage, end / 2, null);
        }
    }

    public static class EmptyHashLiteralNode
    extends HashLiteralNode {
        public EmptyHashLiteralNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection, new RubyNode[0]);
        }

        @Override
        @ExplodeLoop
        public RubyHash executeRubyHash(VirtualFrame frame) {
            return new RubyHash(this.getContext().getCoreLibrary().getHashClass(), null, null, null, 0, null);
        }
    }
}

